/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import libcore.util.EmptyArray;

public class SparseBoolArray
implements Cloneable {
    private int[] mKeys;
    private int mSize;

    public SparseBoolArray() {
        this(10);
    }

    public SparseBoolArray(int initialCapacity) {
        this.mKeys = initialCapacity == 0 ? EmptyArray.INT : ArrayUtils.newUnpaddedIntArray(initialCapacity);
        this.mSize = 0;
    }

    public SparseBoolArray(List<Boolean> marks) {
        this((int)marks.stream().filter(e -> e).count());
        int i = 0;
        int e2 = marks.size();
        while (i < e2) {
            boolean v = marks.get(i);
            if (v) {
                this.append(i, v);
            }
            ++i;
        }
    }

    public SparseBoolArray(BitSet bs) {
        this(bs.cardinality());
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.append(i, true);
            if (i == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(i + 1);
        }
    }

    public SparseBoolArray(int nbElements, boolean b) {
        this(nbElements);
        int i = 0;
        while (i < nbElements) {
            this.append(i, b);
            ++i;
        }
    }

    public List<Boolean> toList(int size) {
        ArrayList<Boolean> res = new ArrayList<Boolean>(size);
        int j = 0;
        int i = 0;
        while (i < size) {
            if (j < this.size() && this.keyAt(j) == i) {
                res.add(true);
                ++j;
            } else {
                res.add(false);
            }
            ++i;
        }
        return res;
    }

    public SparseBoolArray clone() {
        SparseBoolArray clone = null;
        try {
            clone = (SparseBoolArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public boolean get(int key) {
        return this.get(key, false);
    }

    public boolean get(int key, boolean valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return true;
    }

    public void delete(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, boolean v) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            if (v) {
                return;
            }
            this.removeAt(i);
        } else if (v) {
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public int indexOfKey(int key) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, boolean v) {
        if (!v) {
            return;
        }
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, v);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        ++this.mSize;
    }

    public int[] copyKeys() {
        if (this.size() == 0) {
            return null;
        }
        return Arrays.copyOf(this.mKeys, this.size());
    }

    public int[] refKeys() {
        if (this.size() == 0) {
            return new int[0];
        }
        if (this.mKeys.length > this.size()) {
            this.mKeys = Arrays.copyOf(this.mKeys, this.size());
        }
        return this.mKeys;
    }

    public int hashCode() {
        int result = 1;
        result = 1409 * result + ContainerHelpers.hashCode(this.mKeys, this.mSize);
        result = 1409 * result + this.mSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparseBoolArray)) {
            return false;
        }
        SparseBoolArray other = (SparseBoolArray)obj;
        if (this.mSize != other.mSize) {
            return false;
        }
        return this.equalsRange(this.mKeys, other.mKeys, this.mSize);
    }

    private boolean equalsRange(int[] a, int[] b, int s) {
        if (a == b) {
            return true;
        }
        int i = 0;
        while (i < s) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        int i = 0;
        while (i < this.mSize) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public void clear(int j) {
        this.put(j, false);
    }

    public void set(int j) {
        this.put(j, true);
    }

    public void deleteAndShift(int i) {
        if (this.mSize == 0 || i > this.mKeys[this.mSize - 1]) {
            return;
        }
        int k = this.mSize - 1;
        while (k >= 0 && this.mKeys[k] > i) {
            int n = k--;
            this.mKeys[n] = this.mKeys[n] - 1;
        }
        if (k >= 0 && this.mKeys[k] == i) {
            this.removeAt(k);
        }
    }

    public static SparseBoolArray or(SparseBoolArray a, SparseBoolArray b) {
        int inter = 0;
        int i = 0;
        int j = 0;
        int ie = a.size();
        int je = b.size();
        while (i < ie && j < je) {
            if (a.mKeys[i] > b.mKeys[j]) {
                ++j;
                continue;
            }
            if (a.mKeys[i] < b.mKeys[j]) {
                ++i;
                continue;
            }
            ++i;
            ++j;
            ++inter;
        }
        int resSize = a.size() + b.size() - inter;
        SparseBoolArray res = new SparseBoolArray(resSize);
        int cur = 0;
        i = 0;
        j = 0;
        int ie2 = a.size();
        int je2 = b.size();
        while (i < ie2 && j < je2) {
            if (a.mKeys[i] > b.mKeys[j]) {
                res.mKeys[cur++] = b.mKeys[j];
                ++j;
                continue;
            }
            if (a.mKeys[i] < b.mKeys[j]) {
                res.mKeys[cur++] = a.mKeys[i];
                ++i;
                continue;
            }
            res.mKeys[cur++] = b.mKeys[j];
            ++i;
            ++j;
        }
        ie2 = a.size();
        while (i < ie2) {
            res.mKeys[cur++] = a.mKeys[i];
            ++i;
        }
        int je3 = b.size();
        while (j < je3) {
            res.mKeys[cur++] = b.mKeys[j];
            ++j;
        }
        res.mSize = cur;
        return res;
    }

    public static SparseBoolArray removeAll(SparseBoolArray a, SparseBoolArray b) {
        SparseBoolArray c = new SparseBoolArray(a.size());
        int asz = a.size();
        int bsz = b.size();
        int i = 0;
        int j = 0;
        while (i < asz || j < bsz) {
            int kj;
            if (i == asz) break;
            int ki = a.keyAt(i);
            int n = kj = j == bsz ? Integer.MAX_VALUE : b.keyAt(j);
            if (ki == kj) {
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                c.append(ki, true);
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            ++j;
        }
        return c;
    }

    public static boolean containsAll(SparseBoolArray s1, SparseBoolArray s2) {
        int ss1 = s1.size();
        int ss2 = s2.size();
        if (ss2 > ss1) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < ss1 && j < ss2) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                ++i;
                ++j;
                continue;
            }
            if (sk1 < sk2) {
                int ii = ContainerHelpers.binarySearch(s1.mKeys, sk2, i + 1, ss1 - 1);
                if (ii < 0) {
                    return false;
                }
                i = ii;
                if (ss1 - i >= ss2 - j) continue;
                return false;
            }
            return false;
        }
        return j == ss2;
    }

    public static boolean intersects(SparseBoolArray s1, SparseBoolArray s2) {
        int s1sz = s1.size();
        int s2sz = s2.size();
        if (s1sz == 0 || s2sz == 0) {
            return false;
        }
        int j = 0;
        int i = 0;
        while (i < s1sz && j < s2sz) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                return true;
            }
            if (sk1 > sk2) {
                ++j;
                continue;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        SparseBoolArray a = new SparseBoolArray();
        a.set(1);
        a.set(3);
        a.set(5);
        SparseBoolArray b = new SparseBoolArray();
        b.set(2);
        b.set(3);
        b.set(4);
        System.out.println("a=" + String.valueOf(a) + "\nb=" + String.valueOf(b) + "\na||b=" + String.valueOf(SparseBoolArray.or(a, b)));
        System.out.println("\na=" + String.valueOf(a) + "\nb=" + String.valueOf(b) + "\nb||a=" + String.valueOf(SparseBoolArray.or(b, a)));
    }
}

