/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.GrowingArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import libcore.util.EmptyArray;

public class SparseIntArray
implements Cloneable {
    private int[] mKeys;
    private int[] mValues;
    private int mSize;
    private static final int omega = Integer.MAX_VALUE;

    public SparseIntArray() {
        this(10);
    }

    public SparseIntArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EmptyArray.INT;
            this.mValues = EmptyArray.INT;
        } else {
            this.init(initialCapacity);
        }
        this.mSize = 0;
    }

    private void init(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new int[initialCapacity];
    }

    public SparseIntArray(List<Integer> marks) {
        int nonZeroCount = 0;
        for (Integer mark : marks) {
            if (mark == 0) continue;
            ++nonZeroCount;
        }
        this.init(nonZeroCount);
        int i = 0;
        int e = marks.size();
        while (i < e) {
            int v = marks.get(i);
            if (v != 0) {
                this.append(i, v);
            }
            ++i;
        }
    }

    public SparseIntArray(int[] marks) {
        int nonZeroCount = 0;
        int[] nArray = marks;
        int n = marks.length;
        int n2 = 0;
        while (n2 < n) {
            int mark = nArray[n2];
            if (mark != 0) {
                ++nonZeroCount;
            }
            ++n2;
        }
        this.init(nonZeroCount);
        int i = 0;
        int e = marks.length;
        while (i < e) {
            int v = marks[i];
            if (v != 0) {
                this.append(i, v);
            }
            ++i;
        }
    }

    public SparseIntArray(BitSet bs) {
        this(bs.cardinality());
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.append(i, 1);
            if (i == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(i + 1);
        }
    }

    public int[] toArray(int size) {
        int[] res = new int[size];
        int j = 0;
        int i = 0;
        while (i < size) {
            if (j < this.size() && this.keyAt(j) == i) {
                res[i] = this.valueAt(j);
                ++j;
            } else {
                res[i] = 0;
            }
            ++i;
        }
        return res;
    }

    public List<Integer> toList(int size) {
        ArrayList<Integer> res = new ArrayList<Integer>(size);
        int j = 0;
        int i = 0;
        while (i < size) {
            if (j < this.size() && this.keyAt(j) == i) {
                res.add(this.valueAt(j));
                ++j;
            } else {
                res.add(0);
            }
            ++i;
        }
        return res;
    }

    public void move(SparseIntArray source) {
        this.mKeys = source.mKeys;
        source.mKeys = null;
        this.mValues = (int[])source.mValues.clone();
        source.mValues = null;
        this.mSize = source.mSize;
    }

    public SparseIntArray clone() {
        SparseIntArray clone = null;
        try {
            clone = (SparseIntArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (int[])this.mValues.clone();
            clone.mSize = this.mSize;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public int get(int key) {
        return this.get(key, 0);
    }

    public int get(int key, int valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public int delete(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.removeAt(i);
        }
        return i;
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, int value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (value == 0) {
            if (i >= 0) {
                this.removeAt(i);
            }
        } else if (i >= 0) {
            this.mValues[i] = value;
        } else {
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i ^= 0xFFFFFFFF, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public int keyAt(int index) {
        return this.mKeys[index];
    }

    public int valueAt(int index) {
        return this.mValues[index];
    }

    public void setValueAt(int index, int value) {
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(int value) {
        int i = 0;
        while (i < this.mSize) {
            if (this.mValues[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, int value) {
        if (value == 0) {
            return;
        }
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    public int[] copyKeys() {
        if (this.size() == 0) {
            return new int[0];
        }
        return Arrays.copyOf(this.mKeys, this.size());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + ContainerHelpers.hashCode(this.mKeys, this.mValues, this.mSize);
        result = 31 * result + this.mSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SparseIntArray)) {
            return false;
        }
        SparseIntArray other = (SparseIntArray)obj;
        if (this.mSize != other.mSize) {
            return false;
        }
        if (!this.equalsRange(this.mKeys, other.mKeys, this.mSize)) {
            return false;
        }
        return this.equalsRange(this.mValues, other.mValues, this.mSize);
    }

    private boolean equalsRange(int[] a, int[] b, int s) {
        if (a == b) {
            return true;
        }
        int i = 0;
        while (i < s) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        int i = 0;
        while (i < this.mSize) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            int value = this.valueAt(i);
            buffer.append(value);
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static SparseIntArray sumProd(int alpha, SparseIntArray ta, int beta, SparseIntArray tb) {
        return SparseIntArray.sumProd(alpha, ta, beta, tb, -1);
    }

    public static SparseIntArray sumProd(int alpha, SparseIntArray ta, int beta, SparseIntArray tb, int except) {
        int asz = ta.size();
        int bsz = tb.size();
        SparseIntArray flow = new SparseIntArray(Math.max(asz, bsz));
        int i = 0;
        int j = 0;
        while (i < asz || j < bsz) {
            int val;
            int kj;
            int ki = i == asz ? Integer.MAX_VALUE : ta.keyAt(i);
            int n = kj = j == bsz ? Integer.MAX_VALUE : tb.keyAt(j);
            if (ki == kj) {
                val = alpha * ta.valueAt(i) + beta * tb.valueAt(j);
                if (val != 0 && ki != except) {
                    flow.append(ki, val);
                }
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                val = alpha * ta.valueAt(i);
                if (val != 0 && ki != except) {
                    flow.append(ki, val);
                }
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            val = beta * tb.valueAt(j);
            if (val != 0 && kj != except) {
                flow.append(kj, val);
            }
            ++j;
        }
        return flow;
    }

    public static SparseIntArray sumProdOmega(int alpha, SparseIntArray ta, int beta, SparseIntArray tb) {
        int asz = ta.size();
        int bsz = tb.size();
        SparseIntArray flow = new SparseIntArray(Math.max(asz, bsz));
        int i = 0;
        int j = 0;
        while (i < asz || j < bsz) {
            int val;
            int va;
            int kj;
            int ki = i == asz ? Integer.MAX_VALUE : ta.keyAt(i);
            int n = kj = j == bsz ? Integer.MAX_VALUE : tb.keyAt(j);
            if (ki == kj) {
                int val2;
                va = ta.valueAt(i);
                int vb = tb.valueAt(j);
                int n2 = val2 = va != Integer.MAX_VALUE && vb != Integer.MAX_VALUE ? alpha * va + beta * vb : Integer.MAX_VALUE;
                if (val2 != 0) {
                    flow.append(ki, val2);
                }
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                va = ta.valueAt(i);
                int n3 = val = va != Integer.MAX_VALUE ? alpha * va : Integer.MAX_VALUE;
                if (val != 0) {
                    flow.append(ki, val);
                }
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            int vb = tb.valueAt(j);
            int n4 = val = vb != Integer.MAX_VALUE ? beta * tb.valueAt(j) : Integer.MAX_VALUE;
            if (val != 0) {
                flow.append(kj, val);
            }
            ++j;
        }
        return flow;
    }

    public static boolean keysIntersect(SparseIntArray s1, SparseIntArray s2) {
        int s1sz = s1.size();
        int s2sz = s2.size();
        if (s1sz == 0 || s2sz == 0) {
            return false;
        }
        int j = 0;
        int i = 0;
        while (i < s1sz && j < s2sz) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                return true;
            }
            if (sk1 > sk2) {
                ++j;
                continue;
            }
            ++i;
        }
        return false;
    }

    public static boolean coversStrictly(SparseIntArray s1, SparseIntArray s2) {
        int ss2;
        int ss1 = s1.size();
        if (ss1 < (ss2 = s2.size())) {
            return false;
        }
        if (ss2 == 0 && ss1 > 0) {
            return true;
        }
        boolean dominated = false;
        int j = 0;
        int i = 0;
        while (i < ss1 && j < ss2) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                int sv2;
                int sv1 = s1.valueAt(i);
                if (sv1 < (sv2 = s2.valueAt(j))) {
                    return false;
                }
                if (sv1 > sv2) {
                    dominated = true;
                }
                ++i;
                ++j;
                continue;
            }
            if (sk1 > sk2) {
                return false;
            }
            dominated = true;
            int ii = ContainerHelpers.binarySearch(s1.mKeys, sk2, i + 1, ss1 - 1);
            if (ii < 0) {
                return false;
            }
            i = ii;
            if (ss1 - i >= ss2 - j) continue;
            return false;
        }
        return dominated;
    }

    public static boolean greaterOrEqual(SparseIntArray s1, SparseIntArray s2) {
        if (s1.size() < s2.size()) {
            return false;
        }
        if (s2.size() == 0) {
            return true;
        }
        int j = 0;
        int i = 0;
        int ss1 = s1.size();
        int ss2 = s2.size();
        while (i < ss1 && j < ss2) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                if (s1.valueAt(i) < s2.valueAt(j)) {
                    return false;
                }
                ++i;
                ++j;
                continue;
            }
            if (sk1 > sk2) {
                return false;
            }
            int ii = ContainerHelpers.binarySearch(s1.mKeys, sk2, i + 1, s1.mSize - 1);
            if (ii < 0) {
                return false;
            }
            i = ii;
            if (ss1 - i >= ss2 - j) continue;
            return false;
        }
        return true;
    }

    public static int manhattanDistance(SparseIntArray ta, SparseIntArray tb) {
        int dist = 0;
        int i = 0;
        int j = 0;
        int asz = ta.size();
        int bsz = tb.size();
        while (i < asz || j < bsz) {
            int val;
            int kj;
            int ki = i == asz ? Integer.MAX_VALUE : ta.keyAt(i);
            int n = kj = j == bsz ? Integer.MAX_VALUE : tb.keyAt(j);
            if (ki == kj) {
                dist += Math.abs(ta.valueAt(i) - tb.valueAt(j));
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                val = ta.valueAt(i);
                dist += Math.abs(val);
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            val = tb.valueAt(j);
            dist += Math.abs(val);
            ++j;
        }
        return dist;
    }

    public void deleteAndShift(int i) {
        if (this.mSize == 0 || i > this.mKeys[this.mSize - 1]) {
            return;
        }
        int k = this.mSize - 1;
        while (k >= 0 && this.mKeys[k] > i) {
            int n = k--;
            this.mKeys[n] = this.mKeys[n] - 1;
        }
        if (k >= 0 && this.mKeys[k] == i) {
            this.removeAt(k);
        }
    }

    public static boolean containsAllKeys(SparseIntArray s1, SparseIntArray s2) {
        int ss1 = s1.size();
        int ss2 = s2.size();
        if (ss2 > ss1) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < ss1 && j < ss2) {
            int sk2;
            int sk1 = s1.keyAt(i);
            if (sk1 == (sk2 = s2.keyAt(j))) {
                ++i;
                ++j;
                continue;
            }
            if (sk1 < sk2) {
                int ii = ContainerHelpers.binarySearch(s1.mKeys, sk2, i + 1, ss1 - 1);
                if (ii < 0) {
                    return false;
                }
                i = ii;
                if (ss1 - i >= ss2 - j) continue;
                return false;
            }
            return false;
        }
        return j == ss2;
    }

    public static SparseIntArray removeAll(SparseIntArray a, SparseIntArray b) {
        SparseIntArray c = new SparseIntArray(a.size());
        int asz = a.size();
        int bsz = b.size();
        int i = 0;
        int j = 0;
        while (i < asz || j < bsz) {
            int kj;
            if (i == asz) break;
            int ki = a.keyAt(i);
            int n = kj = j == bsz ? Integer.MAX_VALUE : b.keyAt(j);
            if (ki == kj) {
                ++i;
                ++j;
                continue;
            }
            if (ki < kj) {
                c.append(ki, a.valueAt(i));
                ++i;
                continue;
            }
            if (kj >= ki) continue;
            ++j;
        }
        return c;
    }

    public void deleteAndShift(List<Integer> todel) {
        if (this.mSize == 0 || todel.isEmpty() || todel.get(todel.size() - 1) > this.mKeys[this.mSize - 1]) {
            return;
        }
        int k = this.mSize - 1;
        int cur = 0;
        int e = todel.size();
        while (cur < e) {
            int val = todel.get(cur);
            while (k >= 0 && this.mKeys[k] > val) {
                int n = k--;
                this.mKeys[n] = this.mKeys[n] - (todel.size() - cur);
            }
            if (k >= 0 && this.mKeys[k] == val) {
                this.removeAt(k);
                --k;
            }
            ++cur;
        }
    }

    public int sumValues() {
        int sum = 0;
        int i = 0;
        int ie = this.mSize;
        while (i < ie) {
            sum += this.mValues[i];
            ++i;
        }
        return sum;
    }

    public int sumValuesOmega() {
        int sum = 0;
        int i = 0;
        int ie = this.mSize;
        while (i < ie) {
            int val = this.mValues[i];
            if (val != Integer.MAX_VALUE) {
                sum += val;
            }
            ++i;
        }
        return sum;
    }
}

