/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ArrayUtils {
    private static final int CACHE_SIZE = 73;
    private static Object[] sCache = new Object[73];

    private ArrayUtils() {
    }

    public static byte[] newUnpaddedByteArray(int minLen) {
        return new byte[minLen];
    }

    public static char[] newUnpaddedCharArray(int minLen) {
        return new char[minLen];
    }

    public static int[] newUnpaddedIntArray(int minLen) {
        return new int[minLen];
    }

    public static boolean[] newUnpaddedBooleanArray(int minLen) {
        return new boolean[minLen];
    }

    public static long[] newUnpaddedLongArray(int minLen) {
        return new long[minLen];
    }

    public static float[] newUnpaddedFloatArray(int minLen) {
        return new float[minLen];
    }

    public static Object[] newUnpaddedObjectArray(int minLen) {
        return new Object[minLen];
    }

    public static <T> T[] newUnpaddedArray(Class<T> clazz, int minLen) {
        return new Object[minLen];
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length < length || array2.length < length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> T[] emptyArray(Class<T> kind) {
        if (kind == Object.class) {
            return new Object[0];
        }
        int bucket = (kind.hashCode() & Integer.MAX_VALUE) % 73;
        Object cache = sCache[bucket];
        if (cache == null || cache.getClass().getComponentType() != kind) {
            ArrayUtils.sCache[bucket] = cache = Array.newInstance(kind, 0);
        }
        return (Object[])cache;
    }

    public static boolean isEmpty(Collection<?> array) {
        return array == null || array.isEmpty();
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtils.indexOf(array, value) != -1;
    }

    public static <T> int indexOf(T[] array, T value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (Objects.equals(array[i], value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> boolean containsAll(T[] array, T[] check) {
        if (check == null) {
            return true;
        }
        T[] TArray = check;
        int n = check.length;
        int n2 = 0;
        while (n2 < n) {
            T checkItem = TArray[n2];
            if (!ArrayUtils.contains(array, checkItem)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <T> boolean containsAny(T[] array, T[] check) {
        if (check == null) {
            return false;
        }
        T[] TArray = check;
        int n = check.length;
        int n2 = 0;
        while (n2 < n) {
            T checkItem = TArray[n2];
            if (ArrayUtils.contains(array, checkItem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            if (element == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        if (array == null) {
            return false;
        }
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long element = lArray[n2];
            if (element == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static long total(long[] array) {
        long total = 0L;
        if (array != null) {
            long[] lArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                long value = lArray[n2];
                total += value;
                ++n2;
            }
        }
        return total;
    }

    public static int[] convertToIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static <T> T[] appendElement(Class<T> kind, T[] array, T element) {
        Object[] result;
        if (array != null) {
            if (ArrayUtils.contains(array, element)) {
                return array;
            }
            end = array.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    public static <T> T[] removeElement(Class<T> kind, T[] array, T element) {
        if (array != null) {
            if (!ArrayUtils.contains(array, element)) {
                return array;
            }
            int length = array.length;
            int i = 0;
            while (i < length) {
                if (Objects.equals(array[i], element)) {
                    if (length == 1) {
                        return null;
                    }
                    Object[] result = (Object[])Array.newInstance(kind, length - 1);
                    System.arraycopy(array, 0, result, 0, i);
                    System.arraycopy(array, i + 1, result, i, length - i - 1);
                    return result;
                }
                ++i;
            }
        }
        return array;
    }

    public static int[] appendInt(int[] cur, int val) {
        if (cur == null) {
            return new int[]{val};
        }
        int N = cur.length;
        int i = 0;
        while (i < N) {
            if (cur[i] == val) {
                return cur;
            }
            ++i;
        }
        int[] ret = new int[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    public static int[] removeInt(int[] cur, int val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        int i = 0;
        while (i < N) {
            if (cur[i] == val) {
                int[] ret = new int[N - 1];
                if (i > 0) {
                    System.arraycopy(cur, 0, ret, 0, i);
                }
                if (i < N - 1) {
                    System.arraycopy(cur, i + 1, ret, i, N - i - 1);
                }
                return ret;
            }
            ++i;
        }
        return cur;
    }

    public static String[] removeString(String[] cur, String val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        int i = 0;
        while (i < N) {
            if (Objects.equals(cur[i], val)) {
                String[] ret = new String[N - 1];
                if (i > 0) {
                    System.arraycopy(cur, 0, ret, 0, i);
                }
                if (i < N - 1) {
                    System.arraycopy(cur, i + 1, ret, i, N - i - 1);
                }
                return ret;
            }
            ++i;
        }
        return cur;
    }

    public static long[] appendLong(long[] cur, long val) {
        if (cur == null) {
            return new long[]{val};
        }
        int N = cur.length;
        int i = 0;
        while (i < N) {
            if (cur[i] == val) {
                return cur;
            }
            ++i;
        }
        long[] ret = new long[N + 1];
        System.arraycopy(cur, 0, ret, 0, N);
        ret[N] = val;
        return ret;
    }

    public static long[] removeLong(long[] cur, long val) {
        if (cur == null) {
            return null;
        }
        int N = cur.length;
        int i = 0;
        while (i < N) {
            if (cur[i] == val) {
                long[] ret = new long[N - 1];
                if (i > 0) {
                    System.arraycopy(cur, 0, ret, 0, i);
                }
                if (i < N - 1) {
                    System.arraycopy(cur, i + 1, ret, i, N - i - 1);
                }
                return ret;
            }
            ++i;
        }
        return cur;
    }

    public static long[] cloneOrNull(long[] array) {
        return array != null ? (long[])array.clone() : null;
    }

    public static <T> ArrayList<T> remove(ArrayList<T> cur, T val) {
        if (cur == null) {
            return null;
        }
        cur.remove(val);
        if (cur.isEmpty()) {
            return null;
        }
        return cur;
    }

    public static <T> boolean contains(Collection<T> cur, T val) {
        return cur != null ? cur.contains(val) : false;
    }

    public static <T> T[] trimToSize(T[] array, int size) {
        if (array == null || size == 0) {
            return null;
        }
        if (array.length == size) {
            return array;
        }
        return Arrays.copyOf(array, size);
    }

    public static <T> boolean referenceEquals(ArrayList<T> a, ArrayList<T> b) {
        if (a == b) {
            return true;
        }
        int sizeA = a.size();
        int sizeB = b.size();
        if (a == null || b == null || sizeA != sizeB) {
            return false;
        }
        boolean diff = false;
        int i = 0;
        while (i < sizeA && !diff) {
            diff |= a.get(i) != b.get(i);
            ++i;
        }
        return !diff;
    }

    /*
     * Unable to fully structure code
     */
    public static <T> int unstableRemoveIf(ArrayList<T> collection, Predicate<T> predicate) {
        if (collection == null) {
            return 0;
        }
        size = collection.size();
        leftIdx = 0;
        rightIdx = size - 1;
        ** GOTO lbl17
        {
            ++leftIdx;
            do {
                if (leftIdx < size && !predicate.test(collection.get(leftIdx))) continue block0;
                while (rightIdx > leftIdx && predicate.test(collection.get(rightIdx))) {
                    --rightIdx;
                }
                if (leftIdx >= rightIdx) break block0;
                Collections.swap(collection, leftIdx, rightIdx);
                ++leftIdx;
                --rightIdx;
lbl17:
                // 2 sources

            } while (leftIdx <= rightIdx);
        }
        i = size - 1;
        while (i >= leftIdx) {
            collection.remove(i);
            --i;
        }
        return size - leftIdx;
    }
}

