/*
 * Decompiled with CFR 0.152.
 */
package com.github.lovasoa.bloomfilter;

import java.util.BitSet;
import java.util.Iterator;
import java.util.Random;

public class BloomFilter
implements Cloneable {
    private BitSet hashes;
    private RandomInRange prng;
    private int k;
    private static final double LN2 = 0.6931471805599453;

    public BloomFilter(int n, int m) {
        this.k = (int)Math.round(0.6931471805599453 * (double)m / (double)n);
        if (this.k <= 0) {
            this.k = 1;
        }
        this.hashes = new BitSet(m);
        this.prng = new RandomInRange(m, this.k);
    }

    public BloomFilter(int n) {
        this(n, 0x800000);
    }

    public void add(Object o) {
        this.prng.init(o);
        for (RandomInRange r : this.prng) {
            this.hashes.set(r.value);
        }
    }

    public boolean contains(Object o) {
        this.prng.init(o);
        for (RandomInRange r : this.prng) {
            if (this.hashes.get(r.value)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.hashes.clear();
    }

    public BloomFilter clone() throws CloneNotSupportedException {
        return (BloomFilter)super.clone();
    }

    public int hashCode() {
        return this.hashes.hashCode() ^ this.k;
    }

    public boolean equals(BloomFilter other) {
        return this.hashes.equals(other.hashes) && this.k == other.k;
    }

    public void merge(BloomFilter other) {
        if (other.k != this.k || other.hashes.size() != this.hashes.size()) {
            throw new IllegalArgumentException("Incompatible bloom filters");
        }
        this.hashes.or(other.hashes);
    }

    private class RandomInRange
    implements Iterable<RandomInRange>,
    Iterator<RandomInRange> {
        private Random prng;
        private int max;
        private int count;
        private int i = 0;
        public int value;

        RandomInRange(int maximum, int k) {
            this.max = maximum;
            this.count = k;
            this.prng = new Random();
        }

        public void init(Object o) {
            this.prng.setSeed(o.hashCode());
        }

        @Override
        public Iterator<RandomInRange> iterator() {
            this.i = 0;
            return this;
        }

        @Override
        public RandomInRange next() {
            ++this.i;
            this.value = this.prng.nextInt() % this.max;
            if (this.value < 0) {
                this.value = -this.value;
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.count;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

