/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.lola;

import fr.lip6.mist.io.lola.LolaBaseVisitor;
import fr.lip6.mist.io.lola.LolaLexer;
import fr.lip6.mist.io.lola.LolaParser;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ParseTree;

public class LolaTaskImporter {
    Map<String, Integer> pmap = new HashMap<String, Integer>();

    public boolean loadLolaTask(String path, SparsePetriNet pn) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        LolaLexer lexer = new LolaLexer(codePointCharStream);
        LolaParser parser = new LolaParser(new CommonTokenStream(lexer));
        Property prop = new Property(null, PropertyType.INVARIANT, path.replaceAll(".*/", ""));
        pn.getProperties().add(prop);
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        int pid = 0;
        int pide = pn.getPlaceCount();
        while (pid < pide) {
            this.pmap.put(pn.getPnames().get(pid), pid);
            ++pid;
        }
        ExprVisitor ev = new ExprVisitor();
        prop.setBody(parser.ctl().accept(ev));
        System.out.println("Parsed Lola task file at " + path + " to a property in " + (System.currentTimeMillis() - time) + " ms.");
        return true;
    }

    private class ExprVisitor
    extends LolaBaseVisitor<Expression> {
        private ExprVisitor() {
        }

        @Override
        public Expression visitPlaceref(LolaParser.PlacerefContext ctx) {
            String pname = ctx.name.getText();
            int pid = LolaTaskImporter.this.pmap.get(pname);
            return Expression.var(pid);
        }

        @Override
        public Expression visitBoolPred(LolaParser.BoolPredContext ctx) {
            Op op;
            if (ctx.sub != null) {
                return ctx.sub.accept(this);
            }
            if (ctx.nested != null) {
                return ctx.nested.accept(this);
            }
            if (ctx.tt != null) {
                if ("TRUE".equals(ctx.tt.getText())) {
                    return Expression.constant(true);
                }
                return Expression.constant(false);
            }
            String sop = ctx.op.getText();
            if ("AND".equals(sop)) {
                op = Op.AND;
            } else if ("OR".equals(sop)) {
                op = Op.OR;
            } else if ("NOT".equals(sop)) {
                op = Op.NOT;
            } else {
                throw new IllegalArgumentException("The operator whould be boolean, was :" + sop);
            }
            if (op == Op.NOT) {
                Expression res = ctx.left.accept(this);
                return Expression.not(res);
            }
            return Expression.op(op, ctx.left.accept(this), ctx.right.accept(this));
        }

        @Override
        public Expression visitExpr(LolaParser.ExprContext ctx) {
            if (ctx.nested2 != null) {
                return ctx.nested2.accept(this);
            }
            if (ctx.op != null) {
                Op op;
                String sop = ctx.op.getText();
                if ("+".equals(sop)) {
                    op = Op.ADD;
                } else if ("-".equals(sop)) {
                    op = Op.MINUS;
                } else {
                    throw new IllegalArgumentException("The operator should be arithmetic, was :" + sop);
                }
                Expression l = ctx.l.accept(this);
                Expression r = ctx.r.accept(this);
                return Expression.op(op, l, r);
            }
            return ((ParseTree)ctx.children.get(0)).accept(this);
        }

        @Override
        public Expression visitConstant(LolaParser.ConstantContext ctx) {
            int val = Integer.parseInt(ctx.val.getText());
            return Expression.constant(val);
        }

        @Override
        public Expression visitComparison(LolaParser.ComparisonContext ctx) {
            Op op;
            String ops = ctx.op.getText();
            if ("<".equals(ops)) {
                op = Op.LT;
            } else if ("<=".equals(ops)) {
                op = Op.LEQ;
            } else if ("=".equals(ops)) {
                op = Op.EQ;
            } else if ("!=".equals(ops)) {
                op = Op.NEQ;
            } else if (">=".equals(ops)) {
                op = Op.GEQ;
            } else if (">".equals(ops)) {
                op = Op.GT;
            } else {
                throw new IllegalArgumentException("Bad operator for comparison : " + ops);
            }
            Expression l = ctx.lhs.accept(this);
            Expression r = ctx.rhs.accept(this);
            if (l.getOp() == Op.MINUS) {
                return Expression.op(op, l.childAt(0), Expression.op(Op.ADD, l.childAt(1), r));
            }
            return Expression.op(op, l, r);
        }

        @Override
        public Expression visitCtl(LolaParser.CtlContext ctx) {
            return Expression.op(Op.EF, ctx.pred.accept(this), null);
        }
    }
}

