/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.pnet;

import fr.lip6.mist.io.pnet.PnetBaseListener;
import fr.lip6.mist.io.pnet.PnetLexer;
import fr.lip6.mist.io.pnet.PnetParser;
import fr.lip6.move.gal.structural.SparsePetriNet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class PnetImporter {
    public static SparsePetriNet loadPnet(String path) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        PnetLexer lexer = new PnetLexer(codePointCharStream);
        PnetParser parser = new PnetParser(new CommonTokenStream(lexer));
        final SparsePetriNet pn = new SparsePetriNet();
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        parser.addParseListener(new PnetBaseListener(){
            Map<String, Integer> pmap = new HashMap<String, Integer>();
            Map<String, Integer> tmap = new HashMap<String, Integer>();

            @Override
            public void exitNet(PnetParser.NetContext ctx) {
                pn.setName(ctx.name.getText());
            }

            @Override
            public void exitPlaceDecl(PnetParser.PlaceDeclContext ctx) {
                for (PnetParser.PlaceContext p : ctx.decl.places) {
                    String pname = p.name.getText();
                    int id = pn.addPlace(pname, 0);
                    this.pmap.put(pname, id);
                }
            }

            @Override
            public void exitTransDecl(PnetParser.TransDeclContext ctx) {
                for (PnetParser.TransitionContext t : ctx.transitions) {
                    String tname = t.name.getText();
                    int id = pn.addTransition(tname);
                    this.tmap.put(tname, id);
                }
            }

            @Override
            public void exitArc(PnetParser.ArcContext ctx) {
                int pid;
                String pname;
                String tname = ctx.tref.getText();
                Integer tid = this.tmap.get(tname);
                if (tid == null) {
                    if (ctx.post == null) {
                        if (ctx.pre.places.size() == 1) {
                            tname = ctx.pre.places.get((int)0).name.getText();
                            tid = this.tmap.get(tname);
                            String pname2 = ctx.tref.getText();
                            int pid2 = this.pmap.get(pname2);
                            pn.addPostArc(pid2, tid, 1);
                            return;
                        }
                    } else {
                        throw new IllegalArgumentException("Bad format");
                    }
                }
                if (ctx.pre != null) {
                    for (PnetParser.PlaceContext p : ctx.pre.places) {
                        pname = p.name.getText();
                        pid = this.pmap.get(pname);
                        pn.addPreArc(pid, tid, 1);
                    }
                }
                if (ctx.post != null) {
                    for (PnetParser.PlaceContext p : ctx.post.places) {
                        pname = p.name.getText();
                        pid = this.pmap.get(pname);
                        pn.addPostArc(pid, tid, 1);
                    }
                }
            }

            @Override
            public void exitInitDecl(PnetParser.InitDeclContext ctx) {
                for (PnetParser.PlaceContext p : ctx.init.places) {
                    String pname = p.name.getText();
                    int pid = this.pmap.get(pname);
                    pn.getMarks().set(pid, 1);
                }
            }
        });
        parser.net();
        System.out.println("Parsed Pnet format file at " + path + " to a net with " + pn.getPlaceCount() + " places " + pn.getTransitionCount() + " transitions and " + pn.getArcCount() + " arcs in " + (System.currentTimeMillis() - time) + " ms.");
        return pn;
    }
}

