/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.properties;

import fr.lip6.mist.io.properties.PropertiesToPNML;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.ArrayVarRef;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.BoolConstant;
import fr.lip6.move.gal.structural.expr.Constant;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.ParamRef;
import fr.lip6.move.gal.structural.expr.TransRef;
import fr.lip6.move.gal.structural.expr.VarRef;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PrintVisitor
implements ExprVisitor<Void> {
    private PrintWriter pw;
    private PropertyType type;
    private Map<Integer, String> vars = new HashMap<Integer, String>();

    public PrintVisitor(PrintWriter pw, PropertyType type, Map<String, Integer> vars) {
        this.pw = pw;
        this.type = type;
        for (Map.Entry<String, Integer> entry : vars.entrySet()) {
            this.vars.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Void visit(VarRef varRef) {
        if (this.type == PropertyType.BOUNDS) {
            this.pw.append("<place-bound>").append("<place>" + this.vars.get(varRef.index) + "</place>").append("</place-bound>\n");
        } else {
            this.pw.append("<tokens-count>").append("<place>" + this.vars.get(varRef.index) + "</place>").append("</tokens-count>\n");
        }
        return null;
    }

    @Override
    public Void visit(Constant constant) {
        this.pw.append("<integer-constant>" + constant.value + "</integer-constant>\n");
        return null;
    }

    @Override
    public Void visit(BinOp binOp) {
        switch (binOp.getOp()) {
            case AF: {
                this.pw.append("<all-paths><finally>\n");
                binOp.left.accept(this);
                this.pw.append("</finally></all-paths>\n");
                break;
            }
            case AG: {
                this.pw.append("<all-paths><globally>\n");
                binOp.left.accept(this);
                this.pw.append("</globally></all-paths>\n");
                break;
            }
            case EF: {
                this.pw.append("<exists-path><finally>\n");
                binOp.left.accept(this);
                this.pw.append("</finally></exists-path>\n");
                break;
            }
            case EG: {
                this.pw.append("<exists-path><globally>\n");
                binOp.left.accept(this);
                this.pw.append("</globally></exists-path>\n");
                break;
            }
            case AU: {
                this.pw.append("<all-paths><until><before>\n");
                binOp.left.accept(this);
                this.pw.append("</before><reach>");
                binOp.right.accept(this);
                this.pw.append("</reach></until></all-paths>");
                break;
            }
            case EU: {
                this.pw.append("<exists-path><until><before>\n");
                binOp.left.accept(this);
                this.pw.append("</before><reach>");
                binOp.right.accept(this);
                this.pw.append("</reach></until></exists-path>");
                break;
            }
            case AX: {
                this.pw.append("<all-paths><next>");
                binOp.left.accept(this);
                this.pw.append("</next></all-paths>");
                break;
            }
            case EX: {
                this.pw.append("<exists-path><next>");
                binOp.left.accept(this);
                this.pw.append("</next></exists-path>");
                break;
            }
            case F: {
                this.pw.append("<finally>\n");
                binOp.left.accept(this);
                this.pw.append("</finally>\n");
                break;
            }
            case G: {
                this.pw.append("<globally>\n");
                binOp.left.accept(this);
                this.pw.append("</globally>\n");
                break;
            }
            case X: {
                this.pw.append("<next>\n");
                binOp.left.accept(this);
                this.pw.append("</next>\n");
                break;
            }
            case NOT: {
                this.pw.append("<negation>\n");
                binOp.left.accept(this);
                this.pw.append("</negation>\n");
                break;
            }
            case U: {
                this.pw.append("<until><before>\n");
                binOp.left.accept(this);
                this.pw.append("</before><reach>");
                binOp.right.accept(this);
                this.pw.append("</reach></until>");
                break;
            }
            case LEQ: {
                this.pw.append("<integer-le>\n");
                binOp.left.accept(this);
                binOp.right.accept(this);
                this.pw.append("</integer-le>\n");
                break;
            }
            case GT: {
                this.pw.append("<negation><integer-le>\n");
                binOp.left.accept(this);
                binOp.right.accept(this);
                this.pw.append("</integer-le></negation>\n");
                break;
            }
            case GEQ: {
                this.pw.append("<integer-le>\n");
                binOp.right.accept(this);
                binOp.left.accept(this);
                this.pw.append("</integer-le>\n");
                break;
            }
            case EQ: {
                this.pw.append("<conjunction>\n");
                this.pw.append("<integer-le>\n");
                binOp.left.accept(this);
                binOp.right.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("<integer-le>\n");
                binOp.right.accept(this);
                binOp.left.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("</conjunction>\n");
                break;
            }
            case NEQ: {
                this.pw.append("<negation>");
                this.pw.append("<conjunction>\n");
                this.pw.append("<integer-le>\n");
                binOp.left.accept(this);
                binOp.right.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("<integer-le>\n");
                binOp.right.accept(this);
                binOp.left.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("</conjunction>\n");
                this.pw.append("</negation>\n");
                break;
            }
            case LT: {
                if (binOp.right.getOp() == Op.CONST) {
                    this.pw.append("<integer-le>\n");
                    binOp.left.accept(this);
                    this.pw.append("<integer-constant>" + (binOp.right.getValue() - 1) + "</integer-constant>\n");
                    this.pw.append("</integer-le>\n");
                    break;
                }
                this.pw.append("<conjunction>\n");
                this.pw.append("<integer-le>\n");
                binOp.left.accept(this);
                binOp.right.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("<negation>");
                this.pw.append("<integer-le>\n");
                binOp.right.accept(this);
                binOp.left.accept(this);
                this.pw.append("</integer-le>\n");
                this.pw.append("</negation>\n");
                this.pw.append("</conjunction>\n");
                break;
            }
            default: {
                PropertiesToPNML.log.warning("Unexpected operator in binary formula :" + String.valueOf(binOp));
            }
        }
        return null;
    }

    @Override
    public Void visitBool(BoolConstant boolConstant) {
        if (boolConstant.value) {
            this.pw.append("<integer-le><integer-constant>0</integer-constant><integer-constant>0</integer-constant></integer-le>\n");
        } else {
            this.pw.append("<integer-le><integer-constant>1</integer-constant><integer-constant>0</integer-constant></integer-le>\n");
        }
        return null;
    }

    @Override
    public Void visit(ParamRef paramRef) {
        PropertiesToPNML.log.warning("Unexpected parameter in formula :" + String.valueOf(paramRef));
        return null;
    }

    @Override
    public Void visit(ArrayVarRef arrayVarRef) {
        PropertiesToPNML.log.warning("Unexpected array occurrence in formula :" + String.valueOf(arrayVarRef));
        return null;
    }

    @Override
    public Void visit(TransRef transRef) {
        PropertiesToPNML.log.warning("Unexpected transition occurrence in formula :" + String.valueOf(transRef));
        return null;
    }

    public void combine(String operator, List<Expression> operands) {
        int sz = operands.size();
        if (sz == 0) {
            return;
        }
        if (sz == 1) {
            operands.get(0).accept(this);
        } else {
            int mid = sz / 2;
            this.pw.append("<" + operator + ">\n");
            this.combine(operator, operands.subList(0, mid));
            this.combine(operator, operands.subList(mid, sz));
            this.pw.append("</" + operator + ">\n");
        }
    }

    @Override
    public Void visit(NaryOp naryOp) {
        switch (naryOp.getOp()) {
            case AND: {
                this.combine("conjunction", naryOp.getChildren());
                break;
            }
            case OR: {
                this.combine("disjunction", naryOp.getChildren());
                break;
            }
            case ADD: {
                if (this.type == PropertyType.BOUNDS) {
                    this.pw.append("<place-bound>");
                } else {
                    this.pw.append("<tokens-count>");
                }
                for (Expression child : naryOp.getChildren()) {
                    if (child.getOp() == Op.PLACEREF) {
                        this.pw.append("<place>p" + child.getValue() + "</place>");
                        continue;
                    }
                    if (child.getOp() != Op.CONST) continue;
                    throw new IllegalArgumentException("Unexpected constant in sum formula : cannot mix place references and integer constants while translating : " + String.valueOf(naryOp));
                }
                if (this.type == PropertyType.BOUNDS) {
                    this.pw.append("</place-bound>\n");
                    break;
                }
                this.pw.append("</tokens-count>\n");
                break;
            }
            case ENABLED: {
                this.pw.append("<is-fireable>");
                for (Expression child : naryOp.getChildren()) {
                    if (child.getOp() == Op.TRANSREF) {
                        this.pw.append("<transition>t" + child.getValue() + "</transition>");
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected child of enabled should be a transition.");
                }
                this.pw.append("</is-fireable>\n");
                break;
            }
            case CARD: {
                this.pw.append("<tokens-count>");
                for (Expression child : naryOp.getChildren()) {
                    if (child.getOp() == Op.PLACEREF) {
                        this.pw.append("<place>" + this.vars.get(child.getValue()) + "</place>");
                        continue;
                    }
                    if (child.getOp() != Op.CONST) continue;
                    throw new IllegalArgumentException("Unexpected constant in sum formula : cannot mix place references and integer constants. ");
                }
                this.pw.append("</tokens-count>\n");
            }
            default: {
                PropertiesToPNML.log.warning("Unexpected operator in formula :" + String.valueOf(naryOp));
            }
        }
        return null;
    }

    @Override
    public Void visit(AtomicPropRef apRef) {
        return apRef.getAp().getExpression().accept(this);
    }
}

