/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.properties;

import fr.lip6.mist.io.properties.PropertiesBaseVisitor;
import fr.lip6.mist.io.properties.PropertiesLexer;
import fr.lip6.mist.io.properties.PropertiesParser;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class PropertiesImporter {
    public List<Property> parseFile(String path, Map<String, Integer> vars) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        PropertiesLexer lexer = new PropertiesLexer(codePointCharStream);
        PropertiesParser parser = new PropertiesParser(new CommonTokenStream(lexer));
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        ArrayList<Property> list = new ArrayList<Property>();
        PropertiesVisitor ev = new PropertiesVisitor(list, vars);
        parser.properties().accept(ev);
        System.out.println("Parsed propertie file at " + path + " to " + list.size() + " properties in " + (System.currentTimeMillis() - time) + " ms.");
        return list;
    }

    private static class PropertiesVisitor
    extends PropertiesBaseVisitor<Expression> {
        private List<Property> list;
        private Map<String, Expression> atoms = new HashMap<String, Expression>();
        private Map<String, Property> propMap = new HashMap<String, Property>();
        private Map<String, Integer> variables;
        private ContextType context;

        public PropertiesVisitor(List<Property> list, Map<String, Integer> vars) {
            this.list = list;
            this.variables = vars;
        }

        @Override
        public Expression visitProperties(PropertiesParser.PropertiesContext ctx) {
            for (PropertiesParser.PropertyContext prop : ctx.property()) {
                PropertiesParser.LogicPropContext logic;
                PropertyType type = PropertyType.UNKNOWN;
                Expression expr = null;
                String name = prop.name.getText();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                if ((logic = prop.logicProp()).boundsProp() != null) {
                    type = PropertyType.BOUNDS;
                    this.context = ContextType.BOUNDS;
                    expr = logic.boundsProp().target.accept(this);
                } else {
                    PropertiesParser.BoolPropContext boolProp = logic.boolProp();
                    if (boolProp.reachableProp() != null) {
                        type = PropertyType.INVARIANT;
                        this.context = ContextType.INVARIANT;
                        PropertiesParser.ReachablePropContext rp = boolProp.reachableProp();
                        expr = "EF".equals(rp.op.getText()) ? Expression.nop(Op.EF, rp.predicate.accept(this)) : Expression.nop(Op.AG, rp.predicate.accept(this));
                    } else if (boolProp.ctlProp() != null) {
                        type = PropertyType.CTL;
                        this.context = ContextType.CTL;
                        expr = boolProp.ctlProp().predicate.accept(this);
                    } else if (boolProp.ltlProp() != null) {
                        type = PropertyType.LTL;
                        this.context = ContextType.LTL;
                        expr = boolProp.ltlProp().predicate.accept(this);
                    } else {
                        if (boolProp.atomicProp() != null) {
                            this.context = ContextType.INVARIANT;
                            expr = boolProp.atomicProp().predicate.accept(this);
                            this.atoms.put(name, expr);
                            continue;
                        }
                        throw new IllegalArgumentException("Unknown property type " + boolProp.getText());
                    }
                }
                Property newprop = new Property(expr, type, name);
                this.list.add(newprop);
                this.propMap.put(name, newprop);
            }
            return (Expression)super.visitProperties(ctx);
        }

        @Override
        public Expression visitCtlPrimaryBool(PropertiesParser.CtlPrimaryBoolContext ctx) {
            if (ctx.nested != null) {
                return ctx.nested.accept(this);
            }
            return (Expression)super.visitCtlPrimaryBool(ctx);
        }

        @Override
        public Expression visitLtlPrimaryBool(PropertiesParser.LtlPrimaryBoolContext ctx) {
            if (ctx.nested != null) {
                return ctx.nested.accept(this);
            }
            return (Expression)super.visitLtlPrimaryBool(ctx);
        }

        @Override
        public Expression visitBoundsPredicate(PropertiesParser.BoundsPredicateContext ctx) {
            ArrayList<Expression> bounds = new ArrayList<Expression>();
            for (PropertiesParser.BpPrimaryContext primary : ctx.bpPrimary()) {
                bounds.add(primary.accept(this));
            }
            return Expression.nop(Op.ADD, bounds);
        }

        @Override
        public Expression visitConstant(PropertiesParser.ConstantContext ctx) {
            return Expression.constant(Integer.parseInt(ctx.getText()));
        }

        @Override
        public Expression visitPAddition(PropertiesParser.PAdditionContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.pPrimary()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.ADD, children);
        }

        @Override
        public Expression visitReference(PropertiesParser.ReferenceContext ctx) {
            Integer index;
            String name = ctx.name.getText();
            if (name.startsWith("\"")) {
                name = name.substring(1, name.length() - 1);
            }
            if ((index = this.variables.get(name)) == null) {
                index = this.variables.size();
                this.variables.put(name, index);
            }
            return Expression.var(index);
        }

        @Override
        public Expression visitAtomReference(PropertiesParser.AtomReferenceContext ctx) {
            String name = ctx.name.getText();
            Expression expr = this.atoms.get(name);
            if (expr == null) {
                Property refd = this.propMap.get(name);
                if (refd != null) {
                    if (refd.getType() == PropertyType.LTL && this.context == ContextType.LTL) {
                        return refd.getBody();
                    }
                    if ((refd.getType() == PropertyType.CTL || refd.getType() == PropertyType.INVARIANT) && this.context == ContextType.CTL) {
                        return refd.getBody();
                    }
                    throw new IllegalArgumentException("Cannot refer to property " + name + " with type " + String.valueOf((Object)refd.getType()) + " from the context of " + String.valueOf((Object)this.context));
                }
                throw new IllegalArgumentException("Unknown property reference @" + name);
            }
            return expr;
        }

        @Override
        public Expression visitTTrue(PropertiesParser.TTrueContext ctx) {
            return Expression.constant(true);
        }

        @Override
        public Expression visitFFalse(PropertiesParser.FFalseContext ctx) {
            return Expression.constant(false);
        }

        @Override
        public Expression visitPOr(PropertiesParser.POrContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.pAnd()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.OR, children);
        }

        @Override
        public Expression visitCtlOr(PropertiesParser.CtlOrContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.ctlAnd()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.OR, children);
        }

        @Override
        public Expression visitLtlOr(PropertiesParser.LtlOrContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.ltlAnd()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.OR, children);
        }

        @Override
        public Expression visitPAnd(PropertiesParser.PAndContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.pNot()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.AND, children);
        }

        @Override
        public Expression visitCtlAnd(PropertiesParser.CtlAndContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.ctlTemporal()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.AND, children);
        }

        @Override
        public Expression visitLtlAnd(PropertiesParser.LtlAndContext ctx) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            for (ParserRuleContext parserRuleContext : ctx.ltlUntil()) {
                children.add(parserRuleContext.accept(this));
            }
            return Expression.nop(Op.AND, children);
        }

        @Override
        public Expression visitPNot(PropertiesParser.PNotContext ctx) {
            if (ctx.isNeg != null) {
                return Expression.nop(Op.NOT, ctx.pPrimaryBool().accept(this));
            }
            return ctx.pPrimaryBool().accept(this);
        }

        @Override
        public Expression visitCtlNot(PropertiesParser.CtlNotContext ctx) {
            if (ctx.isNeg != null) {
                return Expression.nop(Op.NOT, ctx.left.accept(this));
            }
            return ctx.left.accept(this);
        }

        @Override
        public Expression visitLtlNot(PropertiesParser.LtlNotContext ctx) {
            if (ctx.isNeg != null) {
                return Expression.nop(Op.NOT, ctx.ltlPrimaryBool().accept(this));
            }
            return ctx.ltlPrimaryBool().accept(this);
        }

        private Op readOp(String op) {
            switch (op) {
                case "&&": {
                    return Op.AND;
                }
                case "||": {
                    return Op.OR;
                }
                case "!": {
                    return Op.NOT;
                }
                case "F": {
                    return Op.F;
                }
                case "G": {
                    return Op.G;
                }
                case "X": {
                    return Op.X;
                }
                case "U": {
                    return Op.U;
                }
                case "AG": {
                    return Op.AG;
                }
                case "AF": {
                    return Op.AF;
                }
                case "AX": {
                    return Op.AX;
                }
                case "EG": {
                    return Op.EG;
                }
                case "EF": {
                    return Op.EF;
                }
                case "EX": {
                    return Op.EX;
                }
                case "<": {
                    return Op.LT;
                }
                case "<=": {
                    return Op.LEQ;
                }
                case "==": {
                    return Op.EQ;
                }
                case "!=": {
                    return Op.NEQ;
                }
                case ">": {
                    return Op.GT;
                }
                case ">=": {
                    return Op.GEQ;
                }
            }
            throw new IllegalArgumentException("Unknown operator " + op);
        }

        @Override
        public Expression visitPPrimaryBool(PropertiesParser.PPrimaryBoolContext ctx) {
            if (ctx.nested != null) {
                return ctx.nested.accept(this);
            }
            return (Expression)super.visitPPrimaryBool(ctx);
        }

        @Override
        public Expression visitPComparison(PropertiesParser.PComparisonContext ctx) {
            Op op = this.readOp(ctx.operator.getText());
            Expression left = ctx.left.accept(this);
            Expression right = ctx.right.accept(this);
            return Expression.nop(op, left, right);
        }

        @Override
        public Expression visitCtlUntil(PropertiesParser.CtlUntilContext ctx) {
            if (ctx.q == null) {
                return ctx.left.accept(this);
            }
            if (ctx.q.getText().equals("A")) {
                return Expression.nop(Op.AU, ctx.left.accept(this), ctx.right.accept(this));
            }
            return Expression.nop(Op.EU, ctx.left.accept(this), ctx.right.accept(this));
        }

        @Override
        public Expression visitCtlTemporal(PropertiesParser.CtlTemporalContext ctx) {
            if (ctx.op == null) {
                return ctx.left.accept(this);
            }
            Op op = this.readOp(ctx.op.getText());
            Expression child = ctx.left.accept(this);
            return Expression.nop(op, child);
        }

        @Override
        public Expression visitLtlImply(PropertiesParser.LtlImplyContext ctx) {
            if (ctx.right == null) {
                return ctx.left.accept(this);
            }
            Expression left = ctx.left.accept(this);
            Expression right = ctx.right.accept(this);
            return Expression.nop(Op.OR, Expression.nop(Op.NOT, left), right);
        }

        @Override
        public Expression visitCtlImply(PropertiesParser.CtlImplyContext ctx) {
            if (ctx.right == null) {
                return ctx.left.accept(this);
            }
            Expression left = ctx.left.accept(this);
            Expression right = ctx.right.accept(this);
            return Expression.nop(Op.OR, Expression.nop(Op.NOT, left), right);
        }

        @Override
        public Expression visitLtlNext(PropertiesParser.LtlNextContext ctx) {
            if (ctx.op == null) {
                return ctx.left.accept(this);
            }
            return Expression.nop(Op.X, ctx.left.accept(this));
        }

        @Override
        public Expression visitLtlFutGen(PropertiesParser.LtlFutGenContext ctx) {
            if (ctx.op == null) {
                return (Expression)super.visitLtlFutGen(ctx);
            }
            Op op = this.readOp(ctx.op.getText());
            return Expression.nop(op, ctx.left.accept(this));
        }

        @Override
        public Expression visitLtlUntil(PropertiesParser.LtlUntilContext ctx) {
            if (ctx.right == null) {
                return ctx.left.accept(this);
            }
            return Expression.nop(Op.U, ctx.left.accept(this), ctx.right.accept(this));
        }

        private static enum ContextType {
            CTL,
            LTL,
            BOUNDS,
            INVARIANT;

        }
    }
}

