/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.properties;

import fr.lip6.mist.io.properties.PrintVisitor;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PropertiesToPNML {
    static Logger log = Logger.getLogger("fr.lip6.move.gal");

    private static Logger getLog() {
        return log;
    }

    public static void transform(List<Property> properties, Map<String, Integer> vars, String path) throws IOException {
        long time = System.currentTimeMillis();
        PrintWriter pw = new PrintWriter(new File(path));
        pw.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        pw.append("<property-set xmlns=\"http://mcc.lip6.fr/\">\n");
        int exported = 0;
        for (Property prop : properties) {
            pw.append("<property>\n<id>" + prop.getName() + "</id>\n<description>Automatically generated</description>\n<formula>\n");
            PropertiesToPNML.exportProperty(pw, prop.getBody(), prop.getType(), vars);
            pw.append("</formula>\n</property>\n");
            ++exported;
        }
        pw.append("</property-set>\n");
        pw.close();
        PropertiesToPNML.getLog().info("Export to MCC of " + exported + " properties in file " + path + " took " + (System.currentTimeMillis() - time) + " ms.");
    }

    private static void exportProperty(PrintWriter pw, Expression body, PropertyType type, Map<String, Integer> vars) {
        if (body == null) {
            return;
        }
        if (type == PropertyType.DEADLOCK) {
            pw.append("<exists-path><finally><deadlock/></finally></exists-path>\n");
            return;
        }
        if (type == PropertyType.LTL) {
            pw.append("<all-paths>");
            PrintVisitor v = new PrintVisitor(pw, type, vars);
            body.accept(v);
            pw.append("</all-paths>");
            return;
        }
        if (type == PropertyType.BOUNDS && body.getOp() == Op.CONST) {
            pw.append("<place-bound>");
            pw.append("<integer-constant>" + body.getValue() + "</integer-constant>\n");
            pw.append("</place-bound>\n");
            return;
        }
        if (type == PropertyType.INVARIANT && body.getOp() == Op.BOOLCONST) {
            if (body.getValue() == 1) {
                pw.append("<exists-path><finally><integer-le><integer-constant>0</integer-constant><integer-constant>0</integer-constant></integer-le></finally></exists-path>");
            } else {
                pw.append("<all-paths><globally><integer-le><integer-constant>1</integer-constant><integer-constant>0</integer-constant></integer-le></globally></all-paths> ");
            }
            return;
        }
        PrintVisitor v = new PrintVisitor(pw, type, vars);
        body.accept(v);
    }
}

