/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.selt;

import fr.lip6.mist.io.selt.SeltBaseVisitor;
import fr.lip6.mist.io.selt.SeltLexer;
import fr.lip6.mist.io.selt.SeltParser;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ParseTree;

public class SeltTaskImporter {
    Map<String, Integer> pmap = new HashMap<String, Integer>();

    public static String normalizeName(String text) {
        String res = text.replace(' ', '_');
        res = res.replace('-', '_');
        res = res.replace('/', '_');
        res = res.replace('*', 'x');
        res = res.replace('=', '_');
        return res;
    }

    public boolean loadSeltTask(String path, SparsePetriNet pn) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        SeltLexer lexer = new SeltLexer(codePointCharStream);
        SeltParser parser = new SeltParser(new CommonTokenStream(lexer));
        Property prop = new Property(null, PropertyType.INVARIANT, path.replaceAll(".*/", ""));
        pn.getProperties().add(prop);
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        int pid = 0;
        int pide = pn.getPlaceCount();
        while (pid < pide) {
            this.pmap.put(pn.getPnames().get(pid), pid);
            ++pid;
        }
        ExprVisitor ev = new ExprVisitor();
        prop.setBody(parser.ctl().accept(ev));
        System.out.println("Parsed Selt task file at " + path + " to a property in " + (System.currentTimeMillis() - time) + " ms.");
        return true;
    }

    private class ExprVisitor
    extends SeltBaseVisitor<Expression> {
        private ExprVisitor() {
        }

        @Override
        public Expression visitPlaceref(SeltParser.PlacerefContext ctx) {
            Integer ppid;
            String pname = ctx.name.getText();
            if (pname.startsWith("{") && pname.endsWith("}")) {
                pname = pname.substring(1, pname.length() - 1);
                pname = SeltTaskImporter.normalizeName(pname);
            }
            if ((ppid = SeltTaskImporter.this.pmap.get(pname)) == null) {
                System.err.println("Could not find a place named :'" + pname + "' in net.");
                System.err.println("Known place names :" + String.valueOf(SeltTaskImporter.this.pmap.keySet()));
            }
            int pid = ppid;
            return Expression.var(pid);
        }

        @Override
        public Expression visitBoolPred(SeltParser.BoolPredContext ctx) {
            Op op;
            if (ctx.sub != null) {
                return ctx.sub.accept(this);
            }
            if (ctx.nested != null) {
                return ctx.nested.accept(this);
            }
            if (ctx.tt != null) {
                if ("T".equals(ctx.tt.getText())) {
                    return Expression.constant(true);
                }
                return Expression.constant(false);
            }
            String sop = ctx.op.getText();
            if ("/\\".equals(sop)) {
                op = Op.AND;
            } else if ("\\/".equals(sop)) {
                op = Op.OR;
            } else if ("-".equals(sop)) {
                op = Op.NOT;
            } else {
                throw new IllegalArgumentException("The operator whould be boolean, was :" + sop);
            }
            if (op == Op.NOT) {
                Expression res = ctx.left.accept(this);
                return Expression.not(res);
            }
            return Expression.op(op, ctx.left.accept(this), ctx.right.accept(this));
        }

        @Override
        public Expression visitExpr(SeltParser.ExprContext ctx) {
            if (ctx.nested2 != null) {
                return ctx.nested2.accept(this);
            }
            if (ctx.op != null) {
                Op op;
                String sop = ctx.op.getText();
                if ("+".equals(sop)) {
                    op = Op.ADD;
                } else if ("-".equals(sop)) {
                    op = Op.MINUS;
                } else {
                    if ("*".equals(sop)) {
                        Op op2 = Op.MULT;
                        Expression l = ctx.l.accept(this);
                        Expression r = ctx.r.accept(this);
                        int mult = 0;
                        Expression rep = null;
                        if (l.getOp() == Op.CONST) {
                            mult = l.getValue();
                            rep = r;
                        } else if (r.getOp() == Op.CONST) {
                            mult = r.getValue();
                            rep = l;
                        } else {
                            throw new IllegalArgumentException("Only in fine linear constraints supported, one operand of multiplication should be a constant.");
                        }
                        ArrayList<Expression> toadd = new ArrayList<Expression>();
                        int i = 0;
                        while (i < mult) {
                            toadd.add(rep);
                            ++i;
                        }
                        return Expression.nop(Op.ADD, toadd);
                    }
                    throw new IllegalArgumentException("The operator should be arithmetic, was :" + sop);
                }
                Expression l = ctx.l.accept(this);
                Expression r = ctx.r.accept(this);
                return Expression.op(op, l, r);
            }
            return ((ParseTree)ctx.children.get(0)).accept(this);
        }

        @Override
        public Expression visitConstant(SeltParser.ConstantContext ctx) {
            int val = Integer.parseInt(ctx.val.getText());
            return Expression.constant(val);
        }

        @Override
        public Expression visitComparison(SeltParser.ComparisonContext ctx) {
            Op op;
            String ops = ctx.op.getText();
            if ("<".equals(ops)) {
                op = Op.LT;
            } else if ("<=".equals(ops)) {
                op = Op.LEQ;
            } else if ("=".equals(ops)) {
                op = Op.EQ;
            } else if ("!=".equals(ops)) {
                op = Op.NEQ;
            } else if (">=".equals(ops)) {
                op = Op.GEQ;
            } else if (">".equals(ops)) {
                op = Op.GT;
            } else {
                throw new IllegalArgumentException("Bad operator for comparison : " + ops);
            }
            Expression l = ctx.lhs.accept(this);
            Expression r = ctx.rhs.accept(this);
            if (l.getOp() == Op.MINUS) {
                return Expression.op(op, l.childAt(0), Expression.op(Op.ADD, l.childAt(1), r));
            }
            return Expression.op(op, l, r);
        }

        @Override
        public Expression visitCtl(SeltParser.CtlContext ctx) {
            String ops = ctx.op.getText();
            if ("[]".equals(ops)) {
                return Expression.op(Op.AG, ctx.pred.accept(this), null);
            }
            if ("<>".equals(ops)) {
                return Expression.op(Op.EF, ctx.pred.accept(this), null);
            }
            throw new IllegalArgumentException("Bad temporal operator at head of formula : " + ops);
        }
    }
}

