/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.spec;

import android.util.SparseIntArray;
import fr.lip6.mist.io.spec.SpecBaseListener;
import fr.lip6.mist.io.spec.SpecLexer;
import fr.lip6.mist.io.spec.SpecParser;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class SpecImporter {
    public static SparsePetriNet loadSpec(String path) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        SpecLexer lexer = new SpecLexer(codePointCharStream);
        SpecParser parser = new SpecParser(new CommonTokenStream(lexer));
        final SparsePetriNet pn = new SparsePetriNet();
        pn.setName("MistSpecification");
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        parser.addParseListener(new SpecBaseListener(){
            int curtrans;
            Map<String, Integer> pmap = new HashMap<String, Integer>();
            SparseIntArray guard;
            SparseIntArray effect;
            List<Expression> targets;

            @Override
            public void exitPlace(SpecParser.PlaceContext ctx) {
                String pname = ctx.name.getText();
                int id = pn.addPlace(pname, 0);
                this.pmap.put(pname, id);
            }

            @Override
            public void exitMark(SpecParser.MarkContext ctx) {
                String pname = ctx.pref.getText();
                int id = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                pn.getMarks().set(id, val);
            }

            @Override
            public void exitMark2(SpecParser.Mark2Context ctx) {
                String pname = ctx.pref.getText();
                int id = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                pn.getMarks().set(id, val);
                System.out.println("Constrained initial marking is not supported. Approximating initial constraint : " + pname + ">=" + val + " by " + pname + "=" + val);
            }

            @Override
            public void enterTransDecl(SpecParser.TransDeclContext ctx) {
                String tname = "t" + pn.getTransitionCount();
                this.curtrans = pn.addTransition(tname);
                this.guard = new SparseIntArray();
                this.effect = new SparseIntArray();
            }

            @Override
            public void exitPrevalue(SpecParser.PrevalueContext ctx) {
                String pname = ctx.prefl.getText();
                if (!(pname = pname.substring(0, pname.length() - 1)).equals(ctx.prefr.getText())) {
                    throw new IllegalArgumentException("Syntax error spec does not seem to be a Petri net.");
                }
                int pid = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                this.effect.put(pid, -val);
            }

            @Override
            public void exitPostvalue(SpecParser.PostvalueContext ctx) {
                String pname = ctx.prefl.getText();
                if (!(pname = pname.substring(0, pname.length() - 1)).equals(ctx.prefr.getText())) {
                    throw new IllegalArgumentException("Syntax error spec does not seem to be a Petri net.");
                }
                int pid = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                this.effect.put(pid, val);
            }

            @Override
            public void exitPrecond(SpecParser.PrecondContext ctx) {
                String pname = ctx.pref.getText();
                int pid = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                this.guard.put(pid, val);
            }

            @Override
            public void exitTransDecl(SpecParser.TransDeclContext ctx) {
                int i = 0;
                int ie = this.guard.size();
                while (i < ie) {
                    int pid = this.guard.keyAt(i);
                    int val = this.guard.valueAt(i);
                    pn.addPreArc(pid, this.curtrans, val);
                    ++i;
                }
                SparseIntArray post = SparseIntArray.sumProd(1, this.guard, 1, this.effect);
                int i2 = 0;
                int ie2 = post.size();
                while (i2 < ie2) {
                    int pid = post.keyAt(i2);
                    int val = post.valueAt(i2);
                    pn.addPostArc(pid, this.curtrans, val);
                    ++i2;
                }
                this.guard = null;
                this.effect = null;
            }

            @Override
            public void enterTargetDecl(SpecParser.TargetDeclContext ctx) {
                this.targets = new ArrayList<Expression>();
            }

            @Override
            public void exitGeqVar(SpecParser.GeqVarContext ctx) {
                String pname = ctx.pref.getText();
                int pid = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                this.targets.add(Expression.op(Op.GEQ, Expression.var(pid), Expression.constant(val)));
            }

            @Override
            public void exitEqVar(SpecParser.EqVarContext ctx) {
                String pname = ctx.pref.getText();
                int pid = this.pmap.get(pname);
                int val = Integer.parseInt(ctx.val.getText());
                this.targets.add(Expression.op(Op.EQ, Expression.var(pid), Expression.constant(val)));
            }

            @Override
            public void exitTargetDecl(SpecParser.TargetDeclContext ctx) {
                Property prop = new Property(Expression.op(Op.EF, Expression.nop(Op.AND, this.targets), null), PropertyType.INVARIANT, "target");
                pn.getProperties().add(prop);
                this.targets = null;
            }
        });
        parser.spec();
        System.out.println("Parsed Spec format file at " + path + " to a net with " + pn.getPlaceCount() + " places " + pn.getTransitionCount() + " transitions and " + pn.getArcCount() + " arcs in " + (System.currentTimeMillis() - time) + " ms.");
        return pn;
    }
}

