/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.mist.io.tpn;

import fr.lip6.mist.io.tpn.TpnBaseListener;
import fr.lip6.mist.io.tpn.TpnLexer;
import fr.lip6.mist.io.tpn.TpnParser;
import fr.lip6.move.gal.structural.SparsePetriNet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class TpnImporter {
    public static SparsePetriNet loadSpec(String path) throws IOException {
        long time = System.currentTimeMillis();
        CharStream codePointCharStream = CharStreams.fromFileName(path);
        TpnLexer lexer = new TpnLexer(codePointCharStream);
        TpnParser parser = new TpnParser(new CommonTokenStream(lexer));
        final SparsePetriNet pn = new SparsePetriNet();
        pn.setName(path);
        parser.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        parser.addParseListener(new TpnBaseListener(){
            int curtrans;
            Map<String, Integer> pmap = new HashMap<String, Integer>();

            @Override
            public void exitPlace(TpnParser.PlaceContext ctx) {
                String pname = ctx.name.getText();
                int val = 0;
                if (ctx.val != null) {
                    val = Integer.parseInt(ctx.val.getText());
                }
                int id = pn.addPlace("p" + pn.getPlaceCount(), val);
                this.pmap.put(pname, id);
            }

            @Override
            public void enterTransition(TpnParser.TransitionContext ctx) {
                String tname = "t" + pn.getTransitionCount();
                this.curtrans = pn.addTransition(tname);
            }

            @Override
            public void exitPrePlace(TpnParser.PrePlaceContext ctx) {
                String pname = ctx.pref.getText();
                int pid = this.pmap.get(pname);
                pn.addPreArc(pid, this.curtrans, 1);
            }

            @Override
            public void exitPostPlace(TpnParser.PostPlaceContext ctx) {
                String pname = ctx.pref.getText();
                int pid = this.pmap.get(pname);
                pn.addPostArc(pid, this.curtrans, 1);
            }
        });
        parser.spec();
        System.out.println("Parsed Tpn format file at " + path + " to a net with " + pn.getPlaceCount() + " places " + pn.getTransitionCount() + " transitions and " + pn.getArcCount() + " arcs in " + (System.currentTimeMillis() - time) + " ms.");
        return pn;
    }
}

