/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.graph;

import android.util.SparseIntArray;
import fr.lip6.move.gal.mcc.properties.DoneProperties;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.StructuralReduction;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;

public class GraphSuffix {
    public static boolean[] computeNonStablePlaces(SparsePetriNet spn, DoneProperties doneProps) {
        int reduced = 0;
        long time = System.currentTimeMillis();
        reduced = GraphSuffix.reduceTrivialScc(spn, doneProps);
        boolean[] nonstable = new boolean[spn.getPlaceCount()];
        IntMatrixCol graph = GraphSuffix.buildFreeTokenGraph(spn);
        reduced += GraphSuffix.reduceMarkedSuffix(spn, graph, nonstable, doneProps);
        if ((reduced += GraphSuffix.reduceUnmarkedSuffix(spn, graph, nonstable, doneProps)) > 0) {
            System.out.println("Structural test allowed to assert that " + reduced + " places are NOT stable. Took " + (System.currentTimeMillis() - time) + " ms.");
        }
        return nonstable;
    }

    private static int reduceUnmarkedSuffix(SparsePetriNet spn, IntMatrixCol graph, boolean[] nonstable, DoneProperties doneProps) {
        int reduced = 0;
        IntMatrixCol tgraph = graph.transpose();
        HashSet<Integer> heads = new HashSet<Integer>();
        int pid = 0;
        while (pid < tgraph.getColumnCount()) {
            if (tgraph.getColumn(pid).size() == 0 && spn.getMarks().get(pid) == 0 && !nonstable[pid]) {
                heads.add(pid);
            }
            ++pid;
        }
        HashSet<Integer> unStableSuffix = new HashSet<Integer>(heads);
        StructuralReduction.collectPrefix(unStableSuffix, tgraph, false);
        unStableSuffix.removeAll(heads);
        Iterator iterator = unStableSuffix.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            nonstable[i] = true;
            ++reduced;
        }
        if (!unStableSuffix.isEmpty()) {
            doneProps.put("unMarkedSuffixTest", false, "UNMARKED_SUFFIX_TEST");
        }
        return reduced;
    }

    private static int reduceMarkedSuffix(SparsePetriNet spn, IntMatrixCol graph, boolean[] nonstable, DoneProperties doneProps) {
        int reduced = 0;
        HashSet<Integer> safeNodes = new HashSet<Integer>();
        int pid = 0;
        while (pid < spn.getPlaceCount()) {
            if (spn.getMarks().get(pid) > 0 && graph.getColumn(pid).size() > 0) {
                safeNodes.add(pid);
            }
            ++pid;
        }
        StructuralReduction.collectPrefix(safeNodes, graph, false);
        Iterator iterator = safeNodes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            nonstable[i] = true;
            ++reduced;
        }
        if (!safeNodes.isEmpty()) {
            doneProps.put("markedSuffixTest", false, "MARKED_SUFFIX_TEST");
        }
        return reduced;
    }

    private static IntMatrixCol buildFreeTokenGraph(SparsePetriNet spn) {
        int nbP = spn.getPlaceCount();
        IntMatrixCol graph = new IntMatrixCol(nbP, nbP);
        IntMatrixCol flowPT = spn.getFlowPT();
        IntMatrixCol flowTP = spn.getFlowTP();
        int tid = 0;
        while (tid < flowPT.getColumnCount()) {
            SparseIntArray hPT = flowPT.getColumn(tid);
            SparseIntArray hTP = flowTP.getColumn(tid);
            if (hPT.size() == 1 && hPT.valueAt(0) == 1 && hTP.get(hPT.keyAt(0)) == 0) {
                int pid = 0;
                while (pid < hTP.size()) {
                    graph.set(hTP.keyAt(pid), hPT.keyAt(0), 1);
                    ++pid;
                }
            }
            ++tid;
        }
        return graph;
    }

    private static int reduceTrivialScc(SparsePetriNet spn, DoneProperties doneProps) {
        int reduced = 0;
        StructuralReduction sr = new StructuralReduction(spn);
        BitSet bs = new BitSet();
        int pid = 0;
        while (pid < spn.getPlaceCount()) {
            if (spn.getMarks().get(pid) > 0) {
                bs.set(pid);
            }
            ++pid;
        }
        sr.setProtected(bs);
        if (sr.findFreeSCC(StructuralReduction.ReductionType.REACHABILITY)) {
            doneProps.put("unMarkedSccTest", false, "TRIVIAL_UNMARKED_SCC_TEST");
            reduced += spn.getPlaceCount() - sr.getPlaceCount();
            spn.readFrom(sr);
        }
        return reduced;
    }
}

