/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.graph;

import android.util.SparseIntArray;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Kosaraju {
    public static List<List<Integer>> searchForSCC(IntMatrixCol graph) {
        Stack<Integer> stack = new Stack<Integer>();
        HashSet<Integer> visited = new HashSet<Integer>();
        Stack<Integer> todo = new Stack<Integer>();
        int p = 0;
        while (p < graph.getColumnCount()) {
            todo.add(p);
            ++p;
        }
        while (!todo.isEmpty()) {
            p = (Integer)todo.pop();
            if (p == -1) {
                stack.push((Integer)todo.pop());
                continue;
            }
            SparseIntArray col = graph.getColumn(p);
            if (col.size() <= 0 || !visited.add(p)) continue;
            todo.push(p);
            todo.push(-1);
            int i = 0;
            while (i < col.size()) {
                todo.push(col.keyAt(i));
                ++i;
            }
        }
        ArrayList<List<Integer>> sccs = new ArrayList<List<Integer>>();
        ArrayList<Integer> curScc = new ArrayList<Integer>();
        visited.clear();
        graph = graph.transpose();
        while (!stack.isEmpty()) {
            int cur = (Integer)stack.pop();
            Kosaraju.visitNode(graph, curScc, cur, visited);
            if (curScc.isEmpty()) continue;
            sccs.add(curScc);
            curScc = new ArrayList();
        }
        return sccs;
    }

    private static void visitNode(IntMatrixCol graph, List<Integer> curScc, int cur, Set<Integer> visited) {
        if (visited.add(cur)) {
            curScc.add(cur);
            SparseIntArray col = graph.getColumn(cur);
            int i = 0;
            while (i < col.size()) {
                Kosaraju.visitNode(graph, curScc, col.keyAt(i), visited);
                ++i;
            }
        }
    }
}

