/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.graph;

import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Stack;
import java.util.stream.IntStream;

public class Tarjan {
    public static List<List<Integer>> searchForSCC(IntMatrixCol graph) {
        ArrayList<List<Integer>> stronglyConnectedComponents = new ArrayList<List<Integer>>();
        int preCount = 0;
        int[] low = new int[graph.getColumnCount()];
        boolean[] visited = new boolean[graph.getColumnCount()];
        Stack<Integer> stack = new Stack<Integer>();
        Stack<Integer> minStack = new Stack<Integer>();
        Stack<Integer> vStack = new Stack<Integer>();
        Stack<PrimitiveIterator.OfInt> enumeratorStack = new Stack<PrimitiveIterator.OfInt>();
        Iterator<Integer> enumerator = IntStream.range(0, graph.getColumnCount()).iterator();
        while (true) {
            int min;
            int v;
            if (enumerator.hasNext()) {
                v = (Integer)enumerator.next();
                if (!visited[v]) {
                    low[v] = preCount++;
                    visited[v] = true;
                    stack.push(v);
                    min = low[v];
                    minStack.push(min);
                    vStack.push(v);
                    enumeratorStack.push((PrimitiveIterator.OfInt)enumerator);
                    enumerator = Arrays.stream(graph.getColumn(v).copyKeys()).iterator();
                    continue;
                }
                if (minStack.size() <= 0) continue;
                min = (Integer)minStack.pop();
                if (low[v] < min) {
                    min = low[v];
                }
                minStack.push(min);
                continue;
            }
            if (enumeratorStack.size() == 0) break;
            enumerator = (Iterator)enumeratorStack.pop();
            v = (Integer)vStack.pop();
            min = (Integer)minStack.pop();
            if (min < low[v]) {
                low[v] = min;
            } else {
                int w;
                ArrayList<Integer> component = new ArrayList<Integer>();
                do {
                    w = (Integer)stack.pop();
                    component.add(w);
                    low[w] = graph.getColumnCount();
                } while (w != v);
                stronglyConnectedComponents.add(component);
            }
            if (minStack.size() <= 0) continue;
            min = (Integer)minStack.pop();
            if (low[v] < min) {
                min = low[v];
            }
            minStack.push(min);
        }
        return stronglyConnectedComponents;
    }
}

