/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.mcc.properties.ConcurrentHashDoneProperties;
import fr.lip6.move.gal.mcc.properties.PropertiesToPNML;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.StructuralToPNML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MCCExporter {
    public static void exportToMCCFormat(String pnmlpath, String proppath, SparsePetriNet spn) {
        try {
            List<Object> usedConstants = new ArrayList();
            if (!spn.getProperties().isEmpty()) {
                usedConstants = PropertiesToPNML.transform(spn, proppath, new ConcurrentHashDoneProperties());
            }
            if (!usedConstants.isEmpty()) {
                System.out.println("Added places for constants to the net.");
                Iterator<Object> iterator = usedConstants.iterator();
                while (iterator.hasNext()) {
                    int cst = (Integer)iterator.next();
                    spn.addPlace("constant" + cst, cst);
                }
            }
            StructuralToPNML.transform(spn, pnmlpath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

