/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.PetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PropHandler
extends DefaultHandler {
    private Stack<Object> stack = new Stack();
    private boolean dotext = false;
    private boolean isLTL = false;
    private StringBuilder textBuffer = new StringBuilder();
    private PetriNet spec;
    private Map<String, Integer> pcache = null;
    private Map<String, Integer> tcache = null;

    public PropHandler(PetriNet spn, boolean isLTL) {
        this.spec = spn;
        this.isLTL = isLTL;
    }

    @Override
    public final void startElement(String uri, String localName, String baliseName, Attributes attributes) throws SAXException {
        if ("property".equals(baliseName)) {
            Property pdesc = new Property();
            this.stack.push(pdesc);
        } else if (!"formula".equals(baliseName)) {
            if ("tokens-count".equals(baliseName)) {
                this.stack.push(Expression.nop(Op.CARD));
            } else if ("place-bound".equals(baliseName)) {
                this.stack.push(Expression.nop(Op.BOUND));
            } else if ("is-fireable".equals(baliseName)) {
                this.stack.push(Expression.nop(Op.ENABLED));
            } else if (!("property-set".equals(baliseName) || "integer-le".equals(baliseName) || "integer-lt".equals(baliseName) || "integer-eq".equals(baliseName) || "integer-neq".equals(baliseName) || "integer-ge".equals(baliseName) || "integer-gt".equals(baliseName) || "all-paths".equals(baliseName) || "finally".equals(baliseName) || "exists-path".equals(baliseName) || "negation".equals(baliseName))) {
                if ("disjunction".equals(baliseName)) {
                    this.stack.push((Object)Op.OR);
                } else if ("conjunction".equals(baliseName)) {
                    this.stack.push((Object)Op.AND);
                } else if ("product".equals(baliseName)) {
                    this.stack.push((Object)Op.MULT);
                } else if ("sum".equals(baliseName)) {
                    this.stack.push((Object)Op.ADD);
                } else if (!("until".equals(baliseName) || "before".equals(baliseName) || "reach".equals(baliseName) || "deadlock".equals(baliseName) || "next".equals(baliseName))) {
                    if ("description".equals(baliseName) || "place".equals(baliseName) || "integer-constant".equals(baliseName) || "id".equals(baliseName) || "transition".equals(baliseName)) {
                        this.dotext = true;
                        this.textBuffer.setLength(0);
                    } else if (!"globally".equals(baliseName)) {
                        this.getLog().warning("Unexpected XML tag in property file :" + baliseName);
                    }
                }
            }
        }
    }

    @Override
    public void characters(char[] chars, int beg, int length) throws SAXException {
        if (this.dotext) {
            this.textBuffer.append(chars, beg, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String baliseName) throws SAXException {
        if ("property".equals(baliseName)) {
            this.spec.getProperties().add((Property)this.stack.pop());
        } else if ("formula".equals(baliseName)) {
            Expression child = (Expression)this.stack.pop();
            Property pdesc = (Property)this.stack.peek();
            pdesc.setBody(child);
        } else if ("integer-le".equals(baliseName)) {
            this.popBinary(Op.LEQ);
        } else if ("integer-lt".equals(baliseName)) {
            this.popBinary(Op.LT);
        } else if ("integer-eq".equals(baliseName)) {
            this.popBinary(Op.EQ);
        } else if ("integer-neq".equals(baliseName)) {
            this.popBinary(Op.NEQ);
        } else if ("integer-ge".equals(baliseName)) {
            this.popBinary(Op.GEQ);
        } else if ("integer-gt".equals(baliseName)) {
            this.popBinary(Op.GT);
        } else if ("negation".equals(baliseName)) {
            this.stack.push(Expression.not((Expression)this.stack.pop()));
        } else if (!"is-fireable".equals(baliseName) && !"tokens-count".equals(baliseName)) {
            if ("deadlock".equals(baliseName)) {
                this.stack.push(Expression.op(Op.DEAD, null, null));
            } else if ("description".equals(baliseName)) {
                this.textBuffer.toString().trim();
                Property cfr_ignored_0 = (Property)this.stack.peek();
                this.dotext = false;
                this.textBuffer.setLength(0);
            } else if ("place".equals(baliseName)) {
                String name = this.textBuffer.toString().trim();
                NaryOp context = (NaryOp)this.stack.peek();
                context.addChild(Expression.var(this.findPlace(name)));
                this.dotext = false;
                this.textBuffer.setLength(0);
            } else if ("integer-constant".equals(baliseName)) {
                String name = this.textBuffer.toString().trim();
                this.stack.push(Expression.constant(Integer.parseInt(name)));
                this.dotext = false;
                this.textBuffer.setLength(0);
            } else if ("id".equals(baliseName)) {
                String name = this.textBuffer.toString().trim();
                Property prop = (Property)this.stack.peek();
                prop.setName(name);
                this.dotext = false;
                this.textBuffer.setLength(0);
            } else if ("disjunction".equals(baliseName)) {
                this.popNary(Op.OR);
            } else if ("conjunction".equals(baliseName)) {
                this.popNary(Op.AND);
            } else if ("product".equals(baliseName)) {
                this.popNary(Op.MULT);
            } else if ("sum".equals(baliseName)) {
                this.popNary(Op.ADD);
            } else if ("transition".equals(baliseName)) {
                String name = this.textBuffer.toString().trim();
                NaryOp enab = (NaryOp)this.stack.peek();
                enab.addChild(Expression.trans(this.findTransition(name)));
                this.dotext = false;
                this.textBuffer.setLength(0);
            } else if (!"before".equals(baliseName) && !"reach".equals(baliseName)) {
                if (!this.isLTL) {
                    if ("globally".equals(baliseName) || "finally".equals(baliseName) || "next".equals(baliseName) || "until".equals(baliseName)) {
                        this.stack.push(baliseName);
                    } else if ("all-paths".equals(baliseName)) {
                        String childbalise = (String)this.stack.pop();
                        if (childbalise.equals("globally")) {
                            this.stack.push(Expression.op(Op.AG, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("finally")) {
                            this.stack.push(Expression.op(Op.AF, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("next")) {
                            this.stack.push(Expression.op(Op.AX, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("until")) {
                            this.popBinary(Op.AU);
                        }
                    } else if ("exists-path".equals(baliseName)) {
                        String childbalise = (String)this.stack.pop();
                        if (childbalise.equals("globally")) {
                            this.stack.push(Expression.op(Op.EG, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("finally")) {
                            this.stack.push(Expression.op(Op.EF, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("next")) {
                            this.stack.push(Expression.op(Op.EX, (Expression)this.stack.pop(), null));
                        } else if (childbalise.equals("until")) {
                            this.popBinary(Op.EU);
                        }
                    }
                } else if (!"all-paths".equals(baliseName)) {
                    if ("globally".equals(baliseName)) {
                        this.stack.push(Expression.op(Op.G, (Expression)this.stack.pop(), null));
                    } else if ("finally".equals(baliseName)) {
                        this.stack.push(Expression.op(Op.F, (Expression)this.stack.pop(), null));
                    } else if ("next".equals(baliseName)) {
                        this.stack.push(Expression.op(Op.X, (Expression)this.stack.pop(), null));
                    } else if ("until".equals(baliseName)) {
                        this.popBinary(Op.U);
                    }
                }
            }
        }
    }

    private int findPlace(String name) {
        Integer index;
        PetriNet petriNet = this.spec;
        if (petriNet instanceof ISparsePetriNet) {
            ISparsePetriNet spn = (ISparsePetriNet)((Object)petriNet);
            if (this.pcache == null) {
                this.pcache = new HashMap<String, Integer>((spn.getPnames().size() * 4 + 2) / 3);
                int i = 0;
                for (String pl : spn.getPnames()) {
                    this.pcache.put(pl, i++);
                }
            }
        }
        if ((index = Integer.valueOf(this.pcache == null ? this.spec.getPlaceIndex(PropHandler.normalizeName(name)) : this.pcache.get(PropHandler.normalizeName(name)).intValue())) == null || index < 0) {
            System.out.println("Unknown place :\"" + name + "\" in property !");
            throw new IllegalArgumentException("Unknown place :\"" + name + "\" in property !");
        }
        return index;
    }

    public void popNary(Op op) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        while (this.stack.peek() instanceof Expression) {
            Expression r = (Expression)this.stack.pop();
            operands.add(r);
        }
        this.stack.pop();
        this.stack.push(Expression.nop(op, operands));
    }

    public void popBinary(Op op) {
        Expression r = (Expression)this.stack.pop();
        Expression l = (Expression)this.stack.pop();
        this.stack.push(Expression.op(op, l, r));
    }

    private int findTransition(String name) {
        int index;
        PetriNet petriNet = this.spec;
        if (petriNet instanceof ISparsePetriNet) {
            ISparsePetriNet spn = (ISparsePetriNet)((Object)petriNet);
            if (this.tcache == null) {
                this.tcache = new HashMap<String, Integer>((spn.getTnames().size() * 4 + 2) / 3);
                int i = 0;
                for (String tr : spn.getTnames()) {
                    this.tcache.put(tr, i++);
                }
            }
        }
        if ((index = this.tcache == null ? this.spec.getTransitionIndex(PropHandler.normalizeName(name)) : this.tcache.get(PropHandler.normalizeName(name)).intValue()) < 0) {
            System.out.println("Unknown transition named :\"" + name + "\" in property.");
            throw new IllegalArgumentException("Unknown transition named :\"" + name + "\" in property.");
        }
        return index;
    }

    public static String normalizeName(String text) {
        String res = text.replace(' ', '_');
        res = res.replace('-', '_');
        res = res.replace('/', '_');
        res = res.replace('*', 'x');
        res = res.replace('=', '_');
        return res;
    }

    private Logger getLog() {
        return Logger.getLogger("fr.lip6.move.gal");
    }
}

