/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.mcc.properties.PropHandler;
import fr.lip6.move.gal.structural.PetriNet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PropReader {
    private static final Logger LOGGER = Logger.getLogger("fr.lip6.move.gal");

    public static void readXMLPropertiesIntoProps(File fileProp, PetriNet ptnet, boolean isLTL) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        Exception error = null;
        try {
            FileInputStream in = new FileInputStream(fileProp);
            SAXParser saxParser = factory.newSAXParser();
            PropHandler handler = new PropHandler(ptnet, isLTL);
            System.currentTimeMillis();
            saxParser.parse((InputStream)in, (DefaultHandler)handler);
        }
        catch (IOException e) {
            LOGGER.warning("IO exception : " + e.getMessage());
            error = e;
        }
        catch (ParserConfigurationException e) {
            LOGGER.warning("Error at ToolSpecific Xml parser creation. " + e.getMessage());
            error = e;
        }
        catch (SAXException e) {
            LOGGER.warning("Parse error while parsing toolspecific elements in xml.\n details:" + e.getMessage());
            e.printStackTrace();
            error = e;
        }
        if (error != null) {
            throw new IOException("Parse error while treating translation of formula, possibly this examination is not supported yet.", error);
        }
    }
}

