/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.mcc.properties.DoneProperties;
import fr.lip6.move.gal.mcc.properties.PrintVisitor;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class PropertiesToPNML {
    static Logger log = Logger.getLogger("fr.lip6.move.gal");

    private static Logger getLog() {
        return log;
    }

    public static List<Integer> transform(SparsePetriNet spn, String path, DoneProperties doneProps) throws IOException {
        long time = System.currentTimeMillis();
        PrintWriter pw = new PrintWriter(new File(path));
        pw.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        pw.append("<property-set xmlns=\"http://mcc.lip6.fr/\">\n");
        ArrayList<Integer> usedConstants = new ArrayList<Integer>();
        int exported = 0;
        for (Property prop : spn.getProperties()) {
            if (doneProps.containsKey(prop.getName())) continue;
            pw.append("<property>\n<id>" + prop.getName() + "</id>\n<description>Automatically generated</description>\n<formula>\n");
            PropertiesToPNML.exportProperty(pw, prop.getBody(), prop.getType(), spn, usedConstants);
            pw.append("</formula>\n</property>\n");
            ++exported;
        }
        pw.append("</property-set>\n");
        pw.close();
        PropertiesToPNML.getLog().info("Export to MCC of " + exported + " properties in file " + path + " took " + (System.currentTimeMillis() - time) + " ms.");
        return usedConstants;
    }

    private static void exportProperty(PrintWriter pw, Expression body, PropertyType type, ISparsePetriNet spn, List<Integer> usedConstants) {
        if (body == null) {
            return;
        }
        if (type == PropertyType.DEADLOCK) {
            pw.append("<exists-path><finally><deadlock/></finally></exists-path>\n");
            return;
        }
        if (type == PropertyType.LTL) {
            pw.append("<all-paths>");
            PrintVisitor v = new PrintVisitor(pw, type, spn.getPlaceCount(), usedConstants);
            body.accept(v);
            pw.append("</all-paths>");
            return;
        }
        if (type == PropertyType.BOUNDS && body.getOp() == Op.CONST) {
            pw.append("<place-bound>");
            int i = 0;
            while (i < body.getValue()) {
                pw.append("<place>p" + spn.getPlaceCount() + "</place>");
                ++i;
            }
            pw.append("</place-bound>\n");
            return;
        }
        if (type == PropertyType.INVARIANT && body.getOp() == Op.BOOLCONST) {
            if (body.getValue() == 1) {
                pw.append("<exists-path><finally><integer-le><integer-constant>0</integer-constant><integer-constant>0</integer-constant></integer-le></finally></exists-path>");
            } else {
                pw.append("<all-paths><globally><integer-le><integer-constant>1</integer-constant><integer-constant>0</integer-constant></integer-le></globally></all-paths> ");
            }
            return;
        }
        PrintVisitor v = new PrintVisitor(pw, type, spn.getPlaceCount(), usedConstants);
        body.accept(v);
    }
}

