/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.mcc.properties.PropReader;
import fr.lip6.move.gal.structural.PetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.io.File;
import java.io.IOException;

public class PropertyParser {
    public static int fileToProperties(String path, PetriNet ptnet, PropertyType propertyType) throws IOException {
        File ff = new File(path);
        if (ff.exists()) {
            PropReader.readXMLPropertiesIntoProps(ff, ptnet, propertyType == PropertyType.LTL);
            for (Property prop : ptnet.getProperties()) {
                prop.setType(propertyType);
            }
        } else if (propertyType == PropertyType.DEADLOCK) {
            Property deadlockProp = new Property(Expression.op(Op.EF, Expression.op(Op.DEAD, null, null), null), propertyType, "ReachabilityDeadlock");
            ptnet.getProperties().add(deadlockProp);
        } else {
            System.out.println("No " + path + " examination file found. Proceeding without properties.");
        }
        return ptnet.getProperties().size();
    }
}

