/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.CExpressionPrinter;
import java.io.PrintWriter;

public class PropertyPrinter
extends CExpressionPrinter {
    private boolean forSpot;

    public PropertyPrinter(PrintWriter pw, String prefix, boolean forSpot) {
        super(pw, prefix);
        this.forSpot = forSpot;
    }

    @Override
    public Void visit(BinOp binOp) {
        switch (binOp.getOp()) {
            case F: {
                this.pw.print("<>(");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case G: {
                this.pw.print("[](");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case X: {
                this.pw.print("X(");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case U: {
                this.infix(binOp, " U ");
                break;
            }
            default: {
                super.visit(binOp);
            }
        }
        return null;
    }

    @Override
    public Void visit(AtomicPropRef apRef) {
        if (this.forSpot) {
            this.pw.print("LTLAP" + apRef.getAp().getName());
        } else {
            this.pw.print("(LTLAP" + apRef.getAp().getName() + "==true)");
        }
        return null;
    }
}

