/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.mcc.properties;

import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.CExpressionPrinter;
import fr.lip6.move.gal.structural.expr.VarRef;
import java.io.PrintWriter;
import java.util.List;

public class SpotPropertyPrinter
extends CExpressionPrinter {
    private List<String> pnames;

    public SpotPropertyPrinter(PrintWriter pw, String prefix, List<String> pnames) {
        super(pw, prefix);
        this.pnames = pnames;
    }

    @Override
    public Void visit(VarRef varRef) {
        this.pw.append(this.pnames.get(varRef.getValue()));
        return null;
    }

    @Override
    public Void visit(BinOp binOp) {
        switch (binOp.getOp()) {
            case F: {
                this.pw.print("F(");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case G: {
                this.pw.print("G(");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case X: {
                this.pw.print("X(");
                binOp.left.accept(this);
                this.pw.print(")");
                break;
            }
            case U: {
                this.infix(binOp, " U ");
                break;
            }
            case EQ: {
                this.quoteInfix(binOp, "==");
                break;
            }
            case NEQ: {
                this.quoteInfix(binOp, "!=");
                break;
            }
            case LT: {
                this.quoteInfix(binOp, "<");
                break;
            }
            case LEQ: {
                this.quoteInfix(binOp, "<=");
                break;
            }
            case GEQ: {
                this.quoteInfix(binOp, ">=");
                break;
            }
            case GT: {
                this.quoteInfix(binOp, ">");
                break;
            }
            default: {
                super.visit(binOp);
            }
        }
        return null;
    }

    private void quoteInfix(BinOp binOp, String op) {
        this.pw.append("\"");
        binOp.left.accept(this);
        this.pw.append(op);
        binOp.right.accept(this);
        this.pw.append("\"");
    }
}

