/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.util.IntMatrixCol;

public class CoverWalkUtils {
    private IntMatrixCol combFlow;
    private ISparsePetriNet net;
    private IntMatrixCol tFlowPT;
    private int[] initialEnabling;
    private static final int omega = Integer.MAX_VALUE;

    public CoverWalkUtils(ISparsePetriNet sr) {
        this.net = sr;
        this.combFlow = new IntMatrixCol(this.net.getPlaceCount(), 0);
        int i = 0;
        while (i < this.net.getFlowPT().getColumnCount()) {
            SparseIntArray col = SparseIntArray.sumProd(-1, this.net.getFlowPT().getColumn(i), 1, this.net.getFlowTP().getColumn(i));
            this.combFlow.appendColumn(col);
            ++i;
        }
        this.tFlowPT = this.net.getFlowPT().transpose();
    }

    public int[] computeEnabled(SparseIntArray state) {
        int[] list = new int[this.net.getTransitionCount() + 1];
        int li = 1;
        int t = 0;
        int e = this.net.getTransitionCount();
        while (t < e) {
            if (SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t))) {
                list[li++] = t;
            }
            ++t;
        }
        list[0] = li - 1;
        return list;
    }

    public boolean canStutter(int[] enabled, SparseIntArray omegas) {
        int i = enabled[0];
        while (i >= 1) {
            int transition = enabled[i];
            SparseIntArray transitionEffects = this.combFlow.getColumn(transition);
            if (SparseIntArray.containsAllKeys(omegas, transitionEffects)) {
                return true;
            }
            --i;
        }
        return false;
    }

    void dropEmpty(int[] enabled, SparseIntArray omegas) {
        int i = enabled[0];
        while (i >= 1) {
            int transition = enabled[i];
            SparseIntArray transitionEffects = this.combFlow.getColumn(transition);
            if (SparseIntArray.containsAllKeys(omegas, transitionEffects)) {
                CoverWalkUtils.dropAt(enabled, i);
            }
            --i;
        }
    }

    void dropUnavailable(int[] enabled, SparseIntArray parikh) {
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (parikh.get(t) <= 0) {
                CoverWalkUtils.dropAt(enabled, i);
            }
            --i;
        }
    }

    public SparseIntArray fire(int t, SparseIntArray state) {
        return SparseIntArray.sumProdOmega(1, state, 1, this.combFlow.getColumn(t));
    }

    public IntMatrixCol getCombFlow() {
        return this.combFlow;
    }

    public IntMatrixCol getFlowPT() {
        return this.net.getFlowPT();
    }

    public IntMatrixCol getFlowTP() {
        return this.net.getFlowTP();
    }

    public SparseIntArray getInitial() {
        return new SparseIntArray(this.net.getMarks());
    }

    public void updateEnabled(SparseIntArray state, int[] enabled, int tfired) {
        this.updateEnabled(state, enabled, tfired, true);
    }

    public void updateEnabled(SparseIntArray state, int[] enabled, int tfired, boolean dropEmptyEffects) {
        if (this.combFlow.getColumn(tfired).size() == 0) {
            return;
        }
        SparseIntArray omegas = this.extractOmegas(state);
        boolean[] seen = new boolean[this.net.getTransitionCount()];
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (seen[t]) {
                CoverWalkUtils.dropAt(enabled, i);
            } else if (SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t))) {
                seen[t] = true;
            } else {
                CoverWalkUtils.dropAt(enabled, i);
            }
            --i;
        }
        SparseIntArray tp = this.combFlow.getColumn(tfired);
        int pi = 0;
        int pie = tp.size();
        while (pi < pie) {
            int p = tp.keyAt(pi);
            if (tp.valueAt(pi) > 0) {
                SparseIntArray col = this.tFlowPT.getColumn(p);
                int i2 = 0;
                while (i2 < col.size()) {
                    int t = col.keyAt(i2);
                    if (!(seen[t] || dropEmptyEffects && SparseIntArray.containsAllKeys(omegas, this.combFlow.getColumn(t)) || !SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t)))) {
                        CoverWalkUtils.add(enabled, t);
                        seen[t] = true;
                    }
                    ++i2;
                }
            }
            ++pi;
        }
    }

    private SparseIntArray extractOmegas(SparseIntArray state) {
        SparseIntArray omegas = new SparseIntArray();
        int i = 0;
        while (i < state.size()) {
            if (state.valueAt(i) == Integer.MAX_VALUE) {
                omegas.append(state.keyAt(i), Integer.MAX_VALUE);
            }
            ++i;
        }
        return omegas;
    }

    public static void add(int[] enabled, int value) {
        enabled[enabled[0] + 1] = value;
        enabled[0] = enabled[0] + 1;
    }

    public static void dropAt(int[] enabled, int index) {
        if (index < enabled[0]) {
            enabled[index] = enabled[enabled[0]];
        }
        enabled[0] = enabled[0] - 1;
    }

    public ISparsePetriNet getNet() {
        return this.net;
    }

    public int[] getInitialEnabling() {
        if (this.initialEnabling == null) {
            this.initialEnabling = this.computeEnabled(this.getInitial());
        }
        return this.initialEnabling;
    }
}

