/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.CoverWalkUtils;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class CoverWalker {
    private static final int DEBUG = 0;
    private CoverWalkUtils wu;
    private static final int omega = Integer.MAX_VALUE;

    public CoverWalker(ISparsePetriNet sr) {
        this.wu = new CoverWalkUtils(sr);
    }

    private void updateMaxVerdicts(List<Expression> exprs, SparseIntArray state, int[] verdicts) {
        int v = 0;
        while (v < verdicts.length) {
            if (verdicts[v] != Integer.MAX_VALUE) {
                if (exprs.get(v).getOp() == Op.ADD) {
                    Expression dad = exprs.get(v);
                    int sum = 0;
                    int cid = 0;
                    while (cid < dad.nbChildren()) {
                        Expression c = dad.childAt(cid);
                        if (c.getOp() == Op.CONST) {
                            sum += c.getValue();
                        } else if (c.getOp() == Op.PLACEREF) {
                            int val = state.get(c.getValue());
                            if (val == Integer.MAX_VALUE) {
                                sum = Integer.MAX_VALUE;
                                break;
                            }
                            sum += val;
                        } else {
                            throw new RuntimeException("Unexpected child in bounds query.");
                        }
                        ++cid;
                    }
                    verdicts[v] = Math.max(sum, verdicts[v]);
                } else {
                    verdicts[v] = Math.max(exprs.get(v).eval(state), verdicts[v]);
                }
            }
            ++v;
        }
    }

    public int[] runRandomReachabilityDetection(long nbSteps, List<Expression> exprs, int timeout, int bestFirst, boolean max, SparseIntArray maxReached) {
        long dur;
        int initialTotalTokens;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        long time = System.currentTimeMillis();
        SparseIntArray state = this.wu.getInitial();
        int[] list = (int[])this.wu.getInitialEnabling().clone();
        this.wu.dropEmpty(list, new SparseIntArray());
        SparseIntArray initstate = state.clone();
        int[] initlist = (int[])list.clone();
        int last = -1;
        long nbresets = 0L;
        int[] verdicts = new int[exprs.size()];
        int STACKLIMIT = 20;
        int totalTokens = initialTotalTokens = initstate.sumValues();
        LinkedHashSet<SparseIntArray> stack = new LinkedHashSet<SparseIntArray>();
        int i = 0;
        while ((long)i < nbSteps) {
            dur = System.currentTimeMillis() - time + 1L;
            if (dur > (long)(1000 * timeout)) {
                this.updateMaxVerdicts(exprs, state, verdicts);
                System.out.println("Interrupted " + (bestFirst >= 0 ? "Best-First " : "") + "random walk after " + i + "  steps, including " + nbresets + " resets, run timeout after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen " + Arrays.toString(verdicts) + "");
                return verdicts;
            }
            int newTotalTokens = state.sumValuesOmega();
            if (newTotalTokens > totalTokens) {
                int addedOmega = this.addOmega(state, stack);
                if (addedOmega > 0) {
                    totalTokens = state.sumValuesOmega();
                    stack.clear();
                    maxReached.move(state.clone());
                } else {
                    totalTokens = newTotalTokens;
                }
            }
            if (stack.size() == STACKLIMIT) {
                Iterator it = stack.iterator();
                it.next();
                it.remove();
            }
            stack.add(state);
            this.updateMaxVerdicts(exprs, state, verdicts);
            if (list[0] == 0 || (long)i >= nbSteps / 3L && nbresets == 0L || (long)i >= 2L * nbSteps / 3L && nbresets <= 1L) {
                ++nbresets;
                last = -1;
                state = initstate.clone();
                list = (int[])initlist.clone();
                totalTokens = initialTotalTokens;
                stack.clear();
            } else if (bestFirst == -1 || list[0] <= 1) {
                int r = rand.nextInt(list[0]) + 1;
                int tfired = list[r];
                SparseIntArray newstate = this.wu.fire(tfired, state);
                this.wu.updateEnabled(newstate, list, tfired);
                last = tfired;
                state = newstate;
            } else {
                int minDist = max ? 0 : Integer.MAX_VALUE;
                ArrayList<Integer> mini = new ArrayList<Integer>();
                ArrayList<SparseIntArray> bestSucc = new ArrayList<SparseIntArray>();
                int ti = 1;
                while (ti - 1 < list[0] && (long)i < nbSteps) {
                    SparseIntArray succ = this.wu.fire(list[ti], state);
                    int distance = exprs.get(bestFirst).evalDistance(succ, false);
                    if (!max && distance < minDist || max && distance > minDist) {
                        mini.clear();
                        bestSucc.clear();
                        minDist = distance;
                    }
                    if (!max && distance <= minDist || max && distance >= minDist) {
                        mini.add(list[ti]);
                        bestSucc.add(succ);
                    }
                    ++i;
                    if (list[0] > 1000 && ti % 1000 == 0 && (dur = System.currentTimeMillis() - time + 1L) > (long)(1000 * timeout)) break;
                    ++ti;
                }
                int chosen = rand.nextInt(bestSucc.size());
                state = (SparseIntArray)bestSucc.get(chosen);
                last = (Integer)mini.get(chosen);
                this.wu.updateEnabled(state, list, last);
            }
            ++i;
        }
        dur = System.currentTimeMillis() - time + 1L;
        if (nbSteps > 50L) {
            System.out.println("Incomplete " + (bestFirst >= 0 ? "Best-First " : "") + "random walk after " + i + "  steps, including " + nbresets + " resets, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties (out of " + exprs.size() + ") seen :" + Arrays.toString(verdicts) + "");
        }
        return verdicts;
    }

    private int addOmega(SparseIntArray state, LinkedHashSet<SparseIntArray> stack) {
        int added = 0;
        boolean repeat = false;
        block0: do {
            repeat = false;
            Iterator it = stack.iterator();
            while (it.hasNext()) {
                SparseIntArray old = (SparseIntArray)it.next();
                if (!SparseIntArray.coversStrictly(state, old)) continue;
                int localAdded = 0;
                int i = 0;
                int ie = state.size();
                while (i < ie) {
                    if (state.valueAt(i) != Integer.MAX_VALUE && old.get(state.keyAt(i)) < state.valueAt(i)) {
                        state.setValueAt(i, Integer.MAX_VALUE);
                        ++added;
                        ++localAdded;
                        repeat = true;
                    }
                    ++i;
                }
                if (localAdded <= 0) continue;
                it.remove();
                continue block0;
            }
        } while (repeat);
        return added;
    }

    public static boolean compareAndUpdateIfDominates(SparseIntArray cur, SparseIntArray past) {
        int ss1 = cur.size();
        int ss2 = past.size();
        if (!SparseIntArray.coversStrictly(cur, past)) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < ss1 && j < ss2) {
            int sk2;
            int sk1 = cur.keyAt(i);
            if (sk1 == (sk2 = past.keyAt(j))) {
                if (cur.valueAt(i) > past.valueAt(j)) {
                    cur.setValueAt(i, Integer.MAX_VALUE);
                }
                ++i;
                ++j;
                continue;
            }
            if (sk1 > sk2) {
                throw new RuntimeException("current should dominate past !");
            }
            cur.setValueAt(i, Integer.MAX_VALUE);
            ++i;
        }
        if (i < ss1 && j >= ss2) {
            while (i < ss1) {
                cur.setValueAt(i, Integer.MAX_VALUE);
                ++i;
            }
        }
        return true;
    }
}

