/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.StructuralReduction;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class FlowDimacsPrinter {
    public static String drawNet(StructuralReduction sr) {
        return FlowDimacsPrinter.drawNet(sr.getFlowPT(), sr.getFlowTP(), sr.getMarks(), sr.getPnames(), sr.getTnames());
    }

    public static String drawNet(IntMatrixCol flowPT, IntMatrixCol flowTP, List<Integer> marks, List<String> pnames, List<String> tnames) {
        try {
            int i2;
            long time = System.currentTimeMillis();
            Path out = Files.createTempFile("petri", ".sym", new FileAttribute[0]);
            PrintWriter pw = new PrintWriter(out.toFile());
            String outff = out.toAbsolutePath().toString();
            long nontrivialarc = FlowDimacsPrinter.countNonTrivial(flowPT);
            long markedPlaces = marks.stream().filter(i -> i > 0).count();
            long nbnode = (long)(pnames.size() + tnames.size()) + markedPlaces + (nontrivialarc += FlowDimacsPrinter.countNonTrivial(flowTP));
            long totalArcs = flowPT.getColumns().stream().map(col -> col.size()).reduce(0, Integer::sum).intValue();
            long nbedge = (totalArcs += (long)flowTP.getColumns().stream().map(col -> col.size()).reduce(0, Integer::sum).intValue()) + markedPlaces + nontrivialarc;
            pw.println("c from net with " + pnames.size() + " places and " + tnames.size() + " transitions.");
            pw.println("p edge " + nbnode + " " + nbedge);
            int tstart = pnames.size() + 1;
            int vstart = tstart + tnames.size();
            int pindex = 0;
            while (pindex < pnames.size()) {
                pw.println("n " + (pindex + 1) + " 1");
                ++pindex;
            }
            int extra = vstart;
            for (Integer m : marks) {
                if (m <= 0) continue;
                pw.println("n " + extra + " " + String.valueOf(m));
                ++extra;
            }
            int t = 0;
            while (t < tnames.size()) {
                SparseIntArray sa = flowPT.getColumn(t);
                i2 = 0;
                while (i2 < sa.size()) {
                    if (sa.valueAt(i2) > 1) {
                        pw.println("n " + extra + " " + sa.valueAt(i2));
                        ++extra;
                    }
                    ++i2;
                }
                sa = flowTP.getColumn(t);
                i2 = 0;
                while (i2 < sa.size()) {
                    if (sa.valueAt(i2) > 1) {
                        pw.println("n " + extra + " " + sa.valueAt(i2));
                        ++extra;
                    }
                    ++i2;
                }
                ++t;
            }
            extra = vstart;
            int p = 0;
            while (p < pnames.size()) {
                int m = marks.get(p);
                if (m > 0) {
                    pw.println("e " + (p + 1) + " " + extra);
                    ++extra;
                }
                ++p;
            }
            t = 0;
            while (t < tnames.size()) {
                SparseIntArray sa = flowPT.getColumn(t);
                i2 = 0;
                while (i2 < sa.size()) {
                    if (sa.valueAt(i2) == 1) {
                        pw.println("e " + (sa.keyAt(i2) + 1) + " " + (t + tstart));
                    } else {
                        pw.println("e " + (sa.keyAt(i2) + 1) + " " + extra);
                        pw.println("e " + extra + " " + (t + tstart));
                        ++extra;
                    }
                    ++i2;
                }
                sa = flowTP.getColumn(t);
                i2 = 0;
                while (i2 < sa.size()) {
                    if (sa.valueAt(i2) == 1) {
                        pw.println("e " + (t + tstart) + " " + (sa.keyAt(i2) + 1));
                    } else {
                        pw.println("e " + (t + tstart) + " " + extra);
                        pw.println("e " + extra + " " + (sa.keyAt(i2) + 1));
                        ++extra;
                    }
                    ++i2;
                }
                ++t;
            }
            pw.close();
            System.out.println("Successfully produced net in file " + outff + " in " + (System.currentTimeMillis() - time) + " ms");
            return outff;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static long countNonTrivial(IntMatrixCol flowPT) {
        long nontrivialedge = 0L;
        for (SparseIntArray sa : flowPT.getColumns()) {
            int i = 0;
            while (i < sa.size()) {
                if (sa.valueAt(i) > 1) {
                    ++nontrivialedge;
                }
                ++i;
            }
        }
        return nontrivialedge;
    }
}

