/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.util.IntMatrixCol;

public class FlowMatrix {
    private IntMatrixCol flow;
    private IntMatrixCol read;
    private IntMatrixCol flowPT;
    private IntMatrixCol flowTP;

    public FlowMatrix(int nbvar, int nbtrans) {
        this.flow = new IntMatrixCol(nbvar, nbtrans);
        this.flowPT = new IntMatrixCol(nbvar, nbtrans);
        this.flowTP = new IntMatrixCol(nbvar, nbtrans);
        this.read = new IntMatrixCol(nbvar, nbtrans);
    }

    public void addWriteEffect(int tindex, int vindex, int val) {
        if (val == 0) {
            return;
        }
        this.addToColumn(this.flow.getColumn(tindex), vindex, val);
        if (val < 0) {
            this.addToColumn(this.flowPT.getColumn(tindex), vindex, -val);
        } else {
            this.addToColumn(this.flowTP.getColumn(tindex), vindex, val);
        }
    }

    private void addToColumn(SparseIntArray column, int vindex, int val) {
        int cur = column.get(vindex);
        column.put(vindex, cur += val);
    }

    public void addReadEffect(int tindex, int vindex, int val) {
        SparseIntArray line = this.flowPT.getColumn(tindex);
        int cur = line.get(vindex);
        int max = Math.max(cur, val);
        if (max != cur) {
            line.put(vindex, max);
            this.addToColumn(this.flowTP.getColumn(tindex), vindex, max - cur);
        }
        this.read.getColumn(tindex).put(vindex, max);
    }

    public IntMatrixCol getIncidenceMatrix() {
        return this.flow;
    }

    public IntMatrixCol getRead() {
        return this.read;
    }

    public IntMatrixCol getFlowPT() {
        return this.flowPT;
    }

    public IntMatrixCol getFlowTP() {
        return this.flowTP;
    }
}

