/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FlowPrinter {
    static int nbWritten = 1000;

    public static String drawNet(ISparsePetriNet sr, String title) {
        return FlowPrinter.drawNet(sr, title, Collections.emptySet(), Collections.emptySet(), 150);
    }

    public static String drawNet(ISparsePetriNet sr, String title, int maxShown) {
        return FlowPrinter.drawNet(sr, title, Collections.emptySet(), Collections.emptySet(), maxShown);
    }

    public static String drawNet(ISparsePetriNet sr, String title, Set<Integer> hlPlaces, Set<Integer> hlTrans) {
        return FlowPrinter.drawNet(sr, title, hlPlaces, hlTrans, 150);
    }

    public static String drawNet(ISparsePetriNet sr, String title, Set<Integer> hlPlaces, Set<Integer> hlTrans, int maxShown) {
        return FlowPrinter.drawNet(sr.getFlowPT(), sr.getFlowTP(), sr.getMarks(), sr.getPnames(), sr.getTnames(), sr.computeSupport(), "places: " + sr.getPnames().size() + " trans:" + sr.getTnames().size() + " " + title, hlPlaces, hlTrans, maxShown);
    }

    public static String drawNet(IntMatrixCol flowPT, IntMatrixCol flowTP, List<Integer> marks, List<String> pnames, List<String> tnames, BitSet untouchable, String title, Set<Integer> hlPlaces, Set<Integer> hlTrans, int maxShown) {
        try {
            int i;
            SparseIntArray col;
            boolean incomplete;
            Object color;
            int ti;
            int pi;
            Path out = Files.createTempFile("petri" + nbWritten++ + "_", ".dot", new FileAttribute[0]);
            PrintWriter pw = new PrintWriter(out.toFile());
            pw.println("digraph {");
            pw.println("  overlap=\"false\";");
            pw.println("  labelloc=\"t\";");
            boolean isLarge = false;
            HashSet<Integer> torep = new HashSet<Integer>();
            HashSet<Integer> toret = new HashSet<Integer>();
            IntMatrixCol tflowPT = null;
            IntMatrixCol tflowTP = null;
            if (pnames.size() + tnames.size() > 2 * maxShown) {
                isLarge = true;
                title = (String)title + "(Net is too large representing up to roughly " + maxShown + " objects)";
                Iterator<Integer> it = hlTrans.iterator();
                int ite = 0;
                while (it.hasNext() && ite < maxShown / 2) {
                    int ti2 = it.next();
                    FlowPrinter.addNeighborhood(ti2, flowPT, flowTP, torep, toret);
                    ++ite;
                }
                it = hlPlaces.iterator();
                int i2 = 0;
                while (it.hasNext() && i2 < maxShown / 2) {
                    torep.add(it.next());
                    ++i2;
                }
                tflowPT = flowPT.transpose();
                tflowTP = flowTP.transpose();
                Iterator ti2 = torep.iterator();
                while (ti2.hasNext()) {
                    pi = (Integer)ti2.next();
                    FlowPrinter.addNeighborhood(pi, tflowPT, tflowTP, toret, torep);
                }
                ti2 = toret.iterator();
                while (ti2.hasNext()) {
                    ti = (Integer)ti2.next();
                    FlowPrinter.addNeighborhood(ti, flowPT, flowTP, torep, toret);
                }
                if (hlTrans.isEmpty() && hlPlaces.isEmpty()) {
                    pi = untouchable.nextSetBit(0);
                    while (torep.size() + toret.size() < 3 * maxShown / 2 && pi >= 0) {
                        FlowPrinter.addNeighborhood(pi, tflowPT, tflowTP, toret, torep);
                        if (pi == Integer.MAX_VALUE) break;
                        pi = untouchable.nextSetBit(pi + 1);
                    }
                }
                if (toret.isEmpty() && torep.isEmpty()) {
                    torep.add(0);
                }
                int sz = 0;
                while (torep.size() + toret.size() < maxShown && torep.size() + toret.size() > sz) {
                    sz = torep.size() + toret.size();
                    it = torep.iterator();
                    while (torep.size() + toret.size() < maxShown && it.hasNext()) {
                        FlowPrinter.addNeighborhood(it.next(), tflowPT, tflowTP, toret, torep);
                    }
                    it = toret.iterator();
                    while (torep.size() + toret.size() < maxShown && it.hasNext()) {
                        FlowPrinter.addNeighborhood(it.next(), flowPT, flowTP, torep, toret);
                    }
                }
            }
            pw.println("label=\"" + (String)title + "\";");
            int totalArcs = 0;
            ti = 0;
            while (ti < tnames.size()) {
                if (!isLarge || toret.contains(ti)) {
                    color = "";
                    if (hlTrans.contains(ti)) {
                        color = ",color=\"blue\",peripheries=2";
                    }
                    incomplete = false;
                    col = flowPT.getColumn(ti);
                    if (totalArcs < maxShown * 4) {
                        i = 0;
                        while (i < col.size()) {
                            if (!isLarge || torep.contains(col.keyAt(i))) {
                                pw.print(" p" + col.keyAt(i) + " -> t" + ti);
                                if (col.valueAt(i) != 1) {
                                    pw.print(" [label=\"" + col.valueAt(i) + "\"]");
                                }
                                pw.println(";");
                                ++totalArcs;
                            } else {
                                incomplete = true;
                            }
                            ++i;
                        }
                    } else {
                        incomplete = true;
                    }
                    col = flowTP.getColumn(ti);
                    if (totalArcs < maxShown * 4) {
                        i = 0;
                        while (i < col.size()) {
                            if (!isLarge || torep.contains(col.keyAt(i))) {
                                pw.print("  t" + ti + " -> p" + col.keyAt(i));
                                if (col.valueAt(i) != 1) {
                                    pw.print(" [label=\"" + col.valueAt(i) + "\"]");
                                }
                                pw.println(";");
                                ++totalArcs;
                            } else {
                                incomplete = true;
                            }
                            ++i;
                        }
                    } else {
                        incomplete = true;
                    }
                    if (incomplete) {
                        color = (String)color + ",style=\"dashed\"";
                    }
                    pw.println("  t" + ti + " [shape=\"rectangle\",label=\"" + tnames.get(ti) + "\"" + (String)color + "];");
                }
                ++ti;
            }
            pi = 0;
            while (pi < pnames.size()) {
                if (!isLarge || torep.contains(pi)) {
                    color = "";
                    if (untouchable.get(pi) && hlPlaces.contains(pi)) {
                        color = ",color=\"violet\",style=\"filled\",peripheries=2";
                    } else if (untouchable.get(pi)) {
                        color = ",color=\"red\",style=\"filled\"";
                    } else if (hlPlaces.contains(pi)) {
                        color = ",color=\"blue\",peripheries=2";
                    }
                    if (isLarge) {
                        incomplete = false;
                        col = tflowPT.getColumn(pi);
                        i = 0;
                        while (i < col.size()) {
                            if (!toret.contains(col.keyAt(i))) {
                                incomplete = true;
                                break;
                            }
                            ++i;
                        }
                        if (!incomplete) {
                            col = tflowTP.getColumn(pi);
                            i = 0;
                            while (i < col.size()) {
                                if (!toret.contains(col.keyAt(i))) {
                                    incomplete = true;
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (incomplete) {
                            color = (String)color + ",style=\"dashed\"";
                        }
                    }
                    pw.println("  p" + pi + " [shape=\"oval\",label=\"" + pnames.get(pi) + (String)(marks.get(pi) != 0 ? "(" + String.valueOf(marks.get(pi)) + ")" : "") + "\"" + (String)color + "];");
                }
                ++pi;
            }
            pw.println("}");
            pw.close();
            System.out.println("Successfully produced net in file " + out.toAbsolutePath().toString());
            return out.toAbsolutePath().toString();
        }
        catch (IOException e) {
            System.err.println("Unable to produce dot representation in file :" + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static void addNeighborhood(int ti, IntMatrixCol flowPT, IntMatrixCol flowTP, Set<Integer> torep, Set<Integer> toret) {
        toret.add(ti);
        SparseIntArray col = flowPT.getColumn(ti);
        int i = 0;
        while (i < col.size()) {
            torep.add(col.keyAt(i));
            ++i;
        }
        col = flowTP.getColumn(ti);
        i = 0;
        while (i < col.size()) {
            torep.add(col.keyAt(i));
            ++i;
        }
    }
}

