/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public interface ISparsePetriNet {
    public List<Integer> getMarks();

    public IntMatrixCol getFlowTP();

    public IntMatrixCol getFlowPT();

    public int getPlaceCount();

    public int getTransitionCount();

    public List<String> getTnames();

    public List<String> getPnames();

    public int getMaxArcValue();

    public BitSet computeSupport();

    public boolean isSafe();

    public void setSafe(boolean var1);

    default public void toPredicates(List<Property> properties) {
        for (Property prop : properties) {
            prop.setBody(this.replacePredicates(prop.getBody()));
        }
    }

    default public Expression replacePredicates(Expression expr) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            if (bin.getOp() == Op.DEAD) {
                return Expression.not(Expression.op(Op.EX, Expression.constant(true), null));
            }
            Expression l = this.replacePredicates(bin.left);
            Expression r = this.replacePredicates(bin.right);
            if (l == bin.left && r == bin.right) {
                return expr;
            }
            return Expression.op(bin.op, l, r);
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>();
            if (expr.getOp() == Op.CARD || expr.getOp() == Op.BOUND) {
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() == Op.PLACEREF) {
                        resc.add(Expression.var(child.getValue()));
                        continue;
                    }
                    resc.add(child);
                }
                return Expression.nop(Op.ADD, resc);
            }
            if (expr.getOp() == Op.ENABLED) {
                HashSet<SparseIntArray> pres = new HashSet<SparseIntArray>();
                int skipped = 0;
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.TRANSREF) continue;
                    int tid = child.getValue();
                    if (pres.add(this.getFlowPT().getColumn(tid))) continue;
                    ++skipped;
                }
                if (skipped > 0) {
                    Logger.getLogger("fr.lip6.move.gal").info("Reduced " + skipped + " identical enabling conditions.");
                }
                for (SparseIntArray pre : pres) {
                    ArrayList<Expression> conds = new ArrayList<Expression>();
                    int i = 0;
                    int ie = pre.size();
                    while (i < ie) {
                        conds.add(Expression.op(Op.GEQ, Expression.var(pre.keyAt(i)), Expression.constant(pre.valueAt(i))));
                        ++i;
                    }
                    resc.add(Expression.nop(Op.AND, conds));
                }
                return Expression.nop(Op.OR, resc);
            }
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression nc = this.replacePredicates(child);
                resc.add(nc);
                if (nc == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        return expr;
    }
}

