/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.FlowMatrix;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import uniol.apt.analysis.invariants.InvariantCalculator;

public class InvariantCalculator {
    static final int DEBUG = 0;
    private static IntMatrixCol last = null;
    private static Object lock = new Object();
    private static Set<SparseIntArray> lastInv = null;

    public static Set<SparseIntArray> computePInvariants(FlowMatrix pn) {
        Set<SparseIntArray> invar;
        long time = System.currentTimeMillis();
        try {
            invar = uniol.apt.analysis.invariants.InvariantCalculator.calcSInvariants(pn, InvariantCalculator.InvariantAlgorithm.PIPE, false);
            Logger.getLogger("fr.lip6.move.gal").info("Computed " + invar.size() + " place invariants in " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (ArithmeticException arithmeticException) {
            invar = new HashSet<SparseIntArray>();
            Logger.getLogger("fr.lip6.move.gal").info("Invariants computation overflowed in " + (System.currentTimeMillis() - time) + " ms");
        }
        return invar;
    }

    public static void printInvariant(Collection<SparseIntArray> invariants, List<String> pnames, List<Integer> initial, PrintStream out) {
        for (SparseIntArray rv : invariants) {
            StringBuilder sb = new StringBuilder();
            try {
                long sum = InvariantCalculator.printEquation(rv, initial, pnames, sb);
                out.println("inv : " + sb.toString() + " = " + sum);
            }
            catch (ArithmeticException arithmeticException) {
                System.err.println("Overflow of 'long' when computing constant for invariant.");
            }
        }
        out.println("Total of " + invariants.size() + " invariants.");
    }

    public static void printInvariant(Collection<SparseIntArray> invariants, List<String> pnames, List<Integer> initial) {
        InvariantCalculator.printInvariant(invariants, pnames, initial, System.out);
    }

    public static long printEquation(SparseIntArray inv, List<Integer> initial, List<String> pnames, StringBuilder sb) {
        boolean first = true;
        long sum = 0L;
        int i = 0;
        while (i < inv.size()) {
            int k = inv.keyAt(i);
            int v = inv.valueAt(i);
            if (v != 0) {
                if (first) {
                    if (v < 0) {
                        sb.append("-");
                        v = -v;
                    }
                    first = false;
                } else if (v < 0) {
                    sb.append(" - ");
                    v = -v;
                } else {
                    sb.append(" + ");
                }
                if (v != 1) {
                    sb.append(v + "*" + pnames.get(k));
                } else {
                    sb.append(pnames.get(k));
                }
                if (initial != null) {
                    sum = Math.addExact(sum, Math.multiplyExact((long)v, (int)initial.get(k)));
                }
            }
            ++i;
        }
        return sum;
    }

    public static Set<SparseIntArray> computePInvariants(IntMatrixCol pn) {
        return InvariantCalculator.computePInvariants(pn, false, 120);
    }

    public static Set<SparseIntArray> computePInvariants(IntMatrixCol pn, boolean onlyPositive, int timeout) {
        ExecutorService pool = Executors.newCachedThreadPool();
        FutureTask<Set> task = new FutureTask<Set>(() -> InvariantCalculator.computePInvariants(pn, onlyPositive));
        pool.execute(task);
        try {
            return task.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            task.cancel(true);
            Logger.getLogger("fr.lip6.move.gal").warning("Invariant computation timed out after " + timeout + " seconds.");
            return new HashSet<SparseIntArray>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cache(IntMatrixCol pn, Set<SparseIntArray> inv) {
        Object object = lock;
        synchronized (object) {
            last = new IntMatrixCol(pn);
            lastInv = new HashSet<SparseIntArray>(inv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<SparseIntArray> checkCache(IntMatrixCol pn) {
        Object object = lock;
        synchronized (object) {
            if (pn.equals(last)) {
                Logger.getLogger("fr.lip6.move.gal").info("Invariant cache hit.");
                return lastInv;
            }
            return null;
        }
    }

    public static Set<SparseIntArray> computeTinvariants(ISparsePetriNet sr, IntMatrixCol sumMatrix, List<Integer> repr, boolean onlyPositive) {
        Map<Integer, List<Integer>> repSet = InvariantCalculator.computeMap(repr);
        Set<SparseIntArray> invarT = InvariantCalculator.computePInvariants(sumMatrix.transpose(), onlyPositive);
        HashSet reindexT = new HashSet();
        for (SparseIntArray inv : invarT) {
            ArrayList<SparseIntArray> toadd = new ArrayList<SparseIntArray>();
            toadd.add(new SparseIntArray());
            int i = 0;
            int ie = inv.size();
            while (i < ie) {
                int t = inv.keyAt(i);
                int val = inv.valueAt(i);
                List<Integer> images = repSet.get(t);
                if (images.size() > 1) {
                    for (Integer img : images) {
                        ArrayList<SparseIntArray> toadd2 = new ArrayList<SparseIntArray>();
                        for (SparseIntArray b : toadd) {
                            SparseIntArray mod = b.clone();
                            mod.put(img, val);
                            toadd2.add(mod);
                        }
                        toadd = toadd2;
                    }
                } else {
                    for (SparseIntArray b : toadd) {
                        b.put(images.get(0), val);
                    }
                }
                ++i;
            }
            reindexT.addAll(toadd);
        }
        return invarT;
    }

    public static Set<SparseIntArray> computeTinvariants(ISparsePetriNet sr, IntMatrixCol sumMatrix, List<Integer> repr) {
        return InvariantCalculator.computeTinvariants(sr, sumMatrix, repr, true);
    }

    public static Set<SparseIntArray> computePInvariants(IntMatrixCol pn, boolean onlyPositive) {
        Set<SparseIntArray> invar = InvariantCalculator.checkCache(pn);
        if (invar != null) {
            return invar;
        }
        long time = System.currentTimeMillis();
        try {
            invar = uniol.apt.analysis.invariants.InvariantCalculator.calcInvariantsPIPE(pn.transpose(), onlyPositive);
            InvariantCalculator.cache(pn, invar);
            Logger.getLogger("fr.lip6.move.gal").info("Computed " + invar.size() + " invariants in " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (ArithmeticException arithmeticException) {
            invar = new HashSet<SparseIntArray>();
            Logger.getLogger("fr.lip6.move.gal").info("Invariants computation overflowed in " + (System.currentTimeMillis() - time) + " ms");
        }
        return invar;
    }

    public static Set<SparseIntArray> computePSemiFlows(FlowMatrix pn) {
        return uniol.apt.analysis.invariants.InvariantCalculator.calcSInvariants(pn, InvariantCalculator.InvariantAlgorithm.PIPE, true);
    }

    public static IntMatrixCol computeReducedFlow(ISparsePetriNet sr, List<Integer> representative) {
        IntMatrixCol sumMatrix = new IntMatrixCol(sr.getPlaceCount(), 0);
        int discarded = 0;
        int cur = 0;
        HashMap<SparseIntArray, Integer> seen = new HashMap<SparseIntArray, Integer>();
        int i = 0;
        while (i < sr.getFlowPT().getColumnCount()) {
            SparseIntArray combined = SparseIntArray.sumProd(-1, sr.getFlowPT().getColumn(i), 1, sr.getFlowTP().getColumn(i));
            Integer repr = seen.putIfAbsent(combined, cur);
            if (repr == null) {
                sumMatrix.appendColumn(combined);
                representative.add(cur);
                ++cur;
            } else {
                representative.add(repr);
                ++discarded;
            }
            ++i;
        }
        if (discarded > 0) {
            Logger.getLogger("fr.lip6.move.gal").info("Flow matrix only has " + sumMatrix.getColumnCount() + " transitions (discarded " + discarded + " similar events)");
        }
        return sumMatrix;
    }

    public static SparseIntArray transformParikh(SparseIntArray parikhori, Map<Integer, List<Integer>> repr) {
        SparseIntArray parikh = new SparseIntArray();
        int i = 0;
        int e = parikhori.size();
        while (i < e) {
            int t = parikhori.keyAt(i);
            int k = parikhori.valueAt(i);
            for (int tr : repr.get(t)) {
                parikh.put(tr, k);
            }
            ++i;
        }
        return parikh;
    }

    public static Map<Integer, List<Integer>> computeMap(List<Integer> repr) {
        HashMap<Integer, List<Integer>> repSet = new HashMap<Integer, List<Integer>>();
        int i = 0;
        int e = repr.size();
        while (i < e) {
            int t = i++;
            repSet.compute(repr.get(t), (k, v) -> {
                if (v == null) {
                    ArrayList<Integer> l = new ArrayList<Integer>();
                    l.add(t);
                    return l;
                }
                v.add(t);
                return v;
            });
        }
        return repSet;
    }
}

