/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.AtomicPropManager;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Simplifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class LogicSimplifier {
    /*
     * Unable to fully structure code
     */
    public static int simplifyWithDead(List<Property> properties) {
        simplified = 0;
        block4: for (Property prop : properties) {
            switch (LogicSimplifier.$SWITCH_TABLE$fr$lip6$move$gal$structural$PropertyType()[prop.getType().ordinal()]) {
                case 1: {
                    body = prop.getBody();
                    if (body.getOp() == Op.BOOLCONST) continue block4;
                    eval = LogicSimplifier.evalInDeadlock(body.childAt(0));
                    if (eval != -1 || body.getOp() != Op.AG) ** GOTO lbl12
                    prop.setBody(Expression.constant(false));
                    ++simplified;
                    ** GOTO lbl15
lbl12:
                    // 1 sources

                    if (eval == 1 && body.getOp() == Op.EF) {
                        prop.setBody(Expression.constant(true));
                        ++simplified;
                    }
                }
lbl15:
                // 5 sources

                case 2: {
                    prop.setBody(Simplifier.pushNegation(prop.getBody()));
                    withDead = LogicSimplifier.evalWithAFdead(prop.getBody());
                    if (withDead == prop.getBody()) break;
                    prop.setBody(withDead);
                    ++simplified;
                }
            }
        }
        if (simplified != 0) {
            System.out.println("AF dead knowledge conclusive for " + simplified + " formulas.");
        }
        return simplified;
    }

    private static Expression evalWithAFdead(Expression expr) {
        if (expr == null) {
            return expr;
        }
        switch (expr.getOp()) {
            case EF: 
            case AF: {
                Expression son = expr.childAt(0);
                if (son.getOp() == Op.AX) {
                    return Expression.constant(true);
                }
                if (!AtomicPropManager.isPureBool(son) || LogicSimplifier.evalInDeadlock(son) != 1) break;
                return Expression.constant(true);
            }
            case EG: 
            case AG: {
                Expression son = expr.childAt(0);
                if (son.getOp() == Op.EX) {
                    return Expression.constant(false);
                }
                if (!AtomicPropManager.isPureBool(son) || LogicSimplifier.evalInDeadlock(son) != -1) break;
                return Expression.constant(false);
            }
        }
        if (Op.isComparison(expr.getOp())) {
            return expr;
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int cid = 0;
        int cide = expr.nbChildren();
        while (cid < cide) {
            Expression child = expr.childAt(cid);
            Expression e = LogicSimplifier.evalWithAFdead(child);
            resc.add(e);
            if (e != child) {
                changed = true;
            }
            ++cid;
        }
        if (!changed) {
            return expr;
        }
        return Expression.nop(expr.getOp(), resc);
    }

    private static int evalInDeadlock(Expression body) {
        if (body.getOp() == Op.ENABLED) {
            return -1;
        }
        if (body.getOp() == Op.OR) {
            int i = 0;
            int ie = body.nbChildren();
            while (i < ie) {
                Expression c = body.childAt(i);
                int v = LogicSimplifier.evalInDeadlock(c);
                if (v == 0) {
                    return 0;
                }
                if (v == 1) {
                    return 1;
                }
                ++i;
            }
            return -1;
        }
        if (body.getOp() == Op.AND) {
            int i = 0;
            int ie = body.nbChildren();
            while (i < ie) {
                Expression c = body.childAt(i);
                int v = LogicSimplifier.evalInDeadlock(c);
                if (v == 0) {
                    return 0;
                }
                if (v == -1) {
                    return -1;
                }
                ++i;
            }
            return 1;
        }
        if (body.getOp() == Op.NOT) {
            return -LogicSimplifier.evalInDeadlock(body.childAt(0));
        }
        return 0;
    }

    public static int simplifyWithInitial(List<Property> properties, SparseIntArray spinit, SparsePetriNet spn) {
        int simplified = 0;
        block3: for (Property prop : properties) {
            switch (prop.getType()) {
                case INVARIANT: 
                case CTL: 
                case LTL: {
                    Expression body = prop.getBody();
                    if (body.getOp() == Op.BOOLCONST) continue block3;
                    int eval = LogicSimplifier.evalInInitial(body, spinit, spn);
                    if (eval == 1) {
                        prop.setBody(Expression.constant(true));
                    } else if (eval == -1) {
                        prop.setBody(Expression.constant(false));
                    }
                    if (eval == 0) break;
                    ++simplified;
                }
            }
        }
        if (simplified != 0) {
            System.out.println("Initial state reduction rules removed " + simplified + " formulas.");
        }
        return simplified;
    }

    private static int evalInInitial(Expression predicate, SparseIntArray init, SparsePetriNet spn) {
        switch (predicate.getOp()) {
            case BOOLCONST: {
                if (predicate.getValue() == 1) {
                    return 1;
                }
                return -1;
            }
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: {
                if (predicate.eval(init) == 1) {
                    return 1;
                }
                return -1;
            }
            case ENABLED: {
                int i = 0;
                while (i < predicate.nbChildren()) {
                    Expression e = predicate.childAt(i);
                    if (e.getOp() != Op.TRANSREF) {
                        System.out.println("Unexpected child of enabling was not a transitions reference.");
                        return 0;
                    }
                    int tid = e.getValue();
                    if (SparseIntArray.greaterOrEqual(init, spn.getFlowPT().getColumn(tid))) {
                        if (spn.isSkeleton()) {
                            return 0;
                        }
                        return 1;
                    }
                    ++i;
                }
                return -1;
            }
            case NOT: {
                return -LogicSimplifier.evalInInitial(predicate.childAt(0), init, spn);
            }
            case AND: {
                boolean found0 = false;
                int i = 0;
                while (i < predicate.nbChildren()) {
                    Expression c = predicate.childAt(i);
                    int value = LogicSimplifier.evalInInitial(c, init, spn);
                    if (value == -1) {
                        return -1;
                    }
                    if (value == 0) {
                        found0 = true;
                    }
                    ++i;
                }
                if (found0) {
                    return 0;
                }
                return 1;
            }
            case OR: {
                boolean found0 = false;
                int i = 0;
                while (i < predicate.nbChildren()) {
                    Expression c = predicate.childAt(i);
                    int value = LogicSimplifier.evalInInitial(c, init, spn);
                    if (value == 1) {
                        return 1;
                    }
                    if (value == 0) {
                        found0 = true;
                    }
                    ++i;
                }
                if (found0) {
                    return 0;
                }
                return -1;
            }
            case EX: 
            case AX: 
            case X: {
                return 0;
            }
            case EG: 
            case AG: 
            case G: {
                if (LogicSimplifier.evalInInitial(predicate.childAt(0), init, spn) == -1) {
                    return -1;
                }
                return 0;
            }
            case EF: 
            case AF: 
            case F: {
                if (LogicSimplifier.evalInInitial(predicate.childAt(0), init, spn) == 1) {
                    return 1;
                }
                return 0;
            }
            case EU: 
            case AU: 
            case U: {
                int evalr = LogicSimplifier.evalInInitial(predicate.childAt(1), init, spn);
                if (evalr == 1) {
                    return 1;
                }
                if (evalr == -1 && LogicSimplifier.evalInInitial(predicate.childAt(0), init, spn) == -1) {
                    return -1;
                }
                return 0;
            }
        }
        Logger.getLogger("fr.lip6.move.gal").warning("When simplifiying with initial state, unexpected operator in formula :" + String.valueOf((Object)predicate.getOp()));
        return 0;
    }
}

