/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import fr.lip6.move.gal.mcc.properties.DoneProperties;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.VarRef;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class PetriNet {
    private String name = "Petri";
    private List<Property> properties = new ArrayList<Property>();

    public abstract int getPlaceCount();

    public abstract int getTransitionCount();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public abstract int getTransitionIndex(String var1);

    public abstract int getPlaceIndex(String var1);

    public BitSet computeSupport() {
        BitSet supp = new BitSet();
        for (Property p : this.getProperties()) {
            PetriNet.addSupport(p.getBody(), supp);
        }
        return supp;
    }

    public static Void addSupport(Expression expr, BitSet supp) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            bin.forEachChild(c -> PetriNet.addSupport(c, supp));
        } else if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            nop.forEachChild(c -> PetriNet.addSupport(c, supp));
        } else if (expr instanceof VarRef) {
            supp.set(expr.getValue());
        } else if (expr instanceof AtomicPropRef) {
            PetriNet.addSupport(((AtomicPropRef)expr).getAp().getExpression(), supp);
        }
        return null;
    }

    public void testAliasing(DoneProperties doneProps) {
        int init = this.getProperties().size();
        HashMap<Expression, String> alias = new HashMap<Expression, String>();
        Iterator<Property> it = this.getProperties().iterator();
        while (it.hasNext()) {
            Property prop = it.next();
            String aka = (String)alias.get(prop.getBody());
            if (aka == null) {
                alias.put(prop.getBody(), prop.getName());
                continue;
            }
            doneProps.addAlias(aka, prop.getName());
            it.remove();
        }
        if (init != this.getProperties().size()) {
            System.out.println("Reduction of identical properties reduced properties to check from " + init + " to " + this.getProperties().size());
        }
    }
}

