/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import com.github.lovasoa.bloomfilter.BloomFilter;
import fr.lip6.move.gal.structural.DeadlockFound;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.InvariantCalculator;
import fr.lip6.move.gal.structural.WalkUtils;
import fr.lip6.move.gal.structural.expr.Expression;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;

public class RandomExplorer {
    private static final int DEBUG = 0;
    private WalkUtils wu;

    public RandomExplorer(ISparsePetriNet sr) {
        this.wu = new WalkUtils(sr);
    }

    private int[] computeEnabled(SparseIntArray state) {
        return this.wu.computeEnabled(state);
    }

    public ISparsePetriNet getNet() {
        return this.wu.getNet();
    }

    /*
     * Unable to fully structure code
     */
    public int[] runGuidedReachabilityDetection(long nbSteps, SparseIntArray parikhori, SparseIntArray porori, List<Expression> exprs, List<Integer> repr, int timeout, boolean max) {
        rand = ThreadLocalRandom.current();
        repSet = InvariantCalculator.computeMap(repr);
        parikh = InvariantCalculator.transformParikh(parikhori, repSet);
        parikhori = parikh.clone();
        por = null;
        if (porori != null) {
            por = InvariantCalculator.transformParikh(porori, repSet).toArray(this.wu.getNet().getTransitionCount());
        }
        time = System.currentTimeMillis();
        state = this.wu.getInitial();
        list = (int[])this.wu.getInitialEnabling().clone();
        this.wu.dropEmpty(list);
        this.wu.dropUnavailable(list, parikh);
        initstate = state.clone();
        initlist = (int[])list.clone();
        nbresets = 0L;
        verdicts = new int[exprs.size()];
        i = 0;
        mode = 0;
        if (porori == null) {
            mode = 1;
        }
        if (list[0] != 0) ** GOTO lbl72
        return verdicts;
lbl-1000:
        // 1 sources

        {
            dur = System.currentTimeMillis() - time + 1L;
            if (dur > (long)(1000 * timeout)) {
                return verdicts;
            }
            if (!max) {
                if (!this.updateVerdicts(exprs, state, verdicts)) {
                    System.out.println("Finished Parikh walk after " + i + "  steps, including " + nbresets + " resets, run visited all " + exprs.size() + " properties in " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                    return verdicts;
                }
            } else {
                this.updateMaxVerdicts(exprs, state, verdicts);
            }
            if (list[0] == 0) {
                ++nbresets;
                state = initstate.clone();
                list = (int[])initlist.clone();
                parikh = parikhori.clone();
                mode = (mode + 1) % 4;
                if (porori == null && mode == 0) {
                    ++mode;
                }
            } else {
                if (mode == 0) {
                    minV = 0x7FFFFFFF;
                    minList = new int[list[0]];
                    minsz = 0;
                    j = 1;
                    je = list[0] + 1;
                    while (j < je) {
                        tid = list[j];
                        vt = por[tid];
                        if (vt < minV) {
                            minsz = 0;
                            minList[minsz++] = j;
                            minV = vt;
                        } else if (vt == minV) {
                            minList[minsz++] = j;
                        }
                        ++j;
                    }
                    r = minList[rand.nextInt(minsz)];
                } else {
                    r = mode == 1 ? rand.nextInt(list[0]) + 1 : (mode == 2 ? list[0] : 1);
                }
                tfired = list[r];
                newstate = this.wu.fire(tfired, state);
                this.wu.updateEnabled(newstate, list, tfired);
                for (int tr : repSet.get(repr.get(tfired))) {
                    parikh.put(tr, parikh.get(tr) - 1);
                }
                if (rand.nextDouble() < 1.0 - (double)nbresets * 0.001) {
                    this.wu.dropUnavailable(list, parikh);
                }
                state = newstate;
            }
            ++i;
lbl72:
            // 2 sources

            ** while ((long)i < nbSteps)
        }
lbl73:
        // 1 sources

        dur = System.currentTimeMillis() - time + 1L;
        return verdicts;
    }

    public int[] runProbabilisticReachabilityDetection(long nbSteps, List<Expression> exprs, int timeout, int bestFirst, boolean exhaustive, WasExhaustive wex) {
        long time = System.currentTimeMillis();
        SparseIntArray istate = this.wu.getInitial();
        int[] verdicts = new int[exprs.size()];
        int i = 0;
        long seen = 1L;
        try {
            long dur;
            ArrayList<SparseIntArray> todo = new ArrayList<SparseIntArray>();
            todo.add(istate);
            BloomFilter bloom = null;
            HashSet<SparseIntArray> real = null;
            if (!exhaustive) {
                bloom = new BloomFilter(10000000, 0x8000000);
                bloom.add(istate);
            } else {
                real = new HashSet<SparseIntArray>();
                real.add(istate);
            }
            if (!this.updateVerdicts(exprs, istate, verdicts)) {
                System.out.println("Finished probabilistic random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in 0 ms. (steps per millisecond=0 )" + "");
                return verdicts;
            }
            int shuffled = 0;
            while ((long)i < nbSteps && !todo.isEmpty() && (long)todo.size() < nbSteps) {
                dur = System.currentTimeMillis() - time + 1L;
                if (dur > (long)(1000 * timeout)) {
                    System.out.println("Interrupted probabilistic random walk after " + i + "  steps, run timeout after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count() + " out of " + exprs.size());
                    break;
                }
                SparseIntArray state = (SparseIntArray)todo.remove(todo.size() - 1);
                int[] list = this.computeEnabled(state);
                if (list[0] != 0) {
                    boolean dobreak = false;
                    int ti = 1;
                    while (ti - 1 < list[0] && (long)i < nbSteps && (long)todo.size() < nbSteps) {
                        SparseIntArray succ = this.wu.fire(list[ti], state);
                        if (!exhaustive) {
                            if (!bloom.contains(succ)) {
                                todo.add(succ);
                                bloom.add(succ);
                                ++seen;
                                if (!this.updateVerdicts(exprs, succ, verdicts)) {
                                    System.out.println("Finished probabilistic random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                                    dobreak = true;
                                    break;
                                }
                            }
                        } else if (!real.contains(succ)) {
                            todo.add(succ);
                            real.add(succ);
                            ++seen;
                            if (!this.updateVerdicts(exprs, succ, verdicts)) {
                                System.out.println("Finished exhaustive random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                                dobreak = true;
                                break;
                            }
                        }
                        if (list[0] > 1000 && ti % 1000 == 0 && (dur = System.currentTimeMillis() - time + 1L) > (long)(1000 * timeout)) {
                            dobreak = true;
                            break;
                        }
                        ++ti;
                        ++i;
                    }
                    if (dobreak) break;
                    if (i / 10000 > shuffled) {
                        shuffled = i / 1000;
                        Collections.reverse(todo);
                    }
                }
                ++i;
            }
            if (todo.isEmpty()) {
                wex.wasExhaustive = true;
                if (!exhaustive) {
                    System.out.println("Probably explored full state space saw : " + seen + "  states, properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
                } else {
                    System.out.println("Explored full state space saw : " + seen + "  states, properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
                }
            }
            dur = System.currentTimeMillis() - time + 1L;
            if (!exhaustive) {
                System.out.println("Probabilistic random walk after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
            } else {
                System.out.println("Exhaustive walk after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            long dur = System.currentTimeMillis() - time + 1L;
            System.out.println("Probabilistic random walk exhausted memory after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
        }
        return verdicts;
    }

    public int[] runRandomReachabilityDetection(long nbSteps, List<Expression> exprs, int timeout, int bestFirst) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] threads = nArray;
        int[][] verdicts = new int[4][];
        WalkStats ws = new WalkStats(bestFirst < 0 ? WalkType.RANDOM : WalkType.BEST_FIRST);
        ((IntStream)Arrays.stream(threads).unordered()).parallel().forEach(id -> {
            int[] nArray2 = this.runRandomReachabilityDetection(nbSteps, exprs, timeout, bestFirst, false, ws);
        });
        int[] finalverdict = new int[exprs.size()];
        int[][] nArrayArray = verdicts;
        int n = verdicts.length;
        int n2 = 0;
        while (n2 < n) {
            int[] v = nArrayArray[n2];
            int i2 = 0;
            while (i2 < v.length) {
                finalverdict[i2] = Math.max(finalverdict[i2], v[i2]);
                ++i2;
            }
            ++n2;
        }
        long remaining = Arrays.stream(finalverdict).filter(i -> i == 0).count();
        System.out.println(String.valueOf(ws) + " remains " + remaining + "/" + exprs.size() + " properties");
        return finalverdict;
    }

    public int[] runRandomReachabilityDetection(long nbSteps, List<Expression> exprs, int timeout, int bestFirst, boolean max, WalkStats stats) {
        long dur;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        long time = System.currentTimeMillis();
        SparseIntArray state = this.wu.getInitial();
        int[] list = (int[])this.wu.getInitialEnabling().clone();
        this.wu.dropEmpty(list);
        SparseIntArray initstate = state.clone();
        int[] initlist = (int[])list.clone();
        int last = -1;
        long nbresets = 0L;
        int[] verdicts = new int[exprs.size()];
        int i = 0;
        while ((long)i < nbSteps) {
            dur = System.currentTimeMillis() - time + 1L;
            if (dur > (long)(1000 * timeout)) {
                if (!this.updateVerdicts(exprs, state, verdicts)) {
                    stats.addStats(i, nbresets, dur);
                    return verdicts;
                }
                stats.addStats(i, nbresets, dur);
                return verdicts;
            }
            boolean skipVerdict = false;
            if (!max) {
                if (exprs.size() >= 10000 && (long)i / dur <= 5L) {
                    boolean bl = skipVerdict = i % 100 != 0;
                }
                if (!skipVerdict && !this.updateVerdicts(exprs, state, verdicts)) {
                    stats.addStats(i, nbresets, dur);
                    return verdicts;
                }
            } else {
                this.updateMaxVerdicts(exprs, state, verdicts);
            }
            if (list[0] == 0 || (long)i >= nbSteps / 3L && nbresets == 0L || (long)i >= 2L * nbSteps / 3L && nbresets <= 1L) {
                if (skipVerdict && !this.updateVerdicts(exprs, state, verdicts)) {
                    stats.addStats(i, nbresets, dur);
                    return verdicts;
                }
                ++nbresets;
                last = -1;
                state = initstate.clone();
                list = (int[])initlist.clone();
            } else if (bestFirst == -1 || list[0] <= 1) {
                int r = rand.nextInt(list[0]) + 1;
                int tfired = list[r];
                boolean repeat = this.shouldRepeatLast(last, state, rand);
                if (repeat) {
                    tfired = last;
                    do {
                        state = this.wu.fire(tfired, state);
                        ++i;
                    } while (SparseIntArray.greaterOrEqual(state, this.wu.getFlowPT().getColumn(tfired)));
                    this.wu.updateEnabled(state, list, tfired);
                    last = -1;
                } else {
                    SparseIntArray newstate = this.wu.fire(tfired, state);
                    this.wu.updateEnabled(newstate, list, tfired);
                    last = tfired;
                    state = newstate;
                }
            } else {
                int minDist = max ? 0 : Integer.MAX_VALUE;
                ArrayList<Integer> mini = new ArrayList<Integer>();
                ArrayList<SparseIntArray> bestSucc = new ArrayList<SparseIntArray>();
                int ti = 1;
                while (ti - 1 < list[0] && (long)i < nbSteps) {
                    SparseIntArray succ = this.wu.fire(list[ti], state);
                    int distance = exprs.get(bestFirst).evalDistance(succ, false);
                    if (!max && distance < minDist || max && distance > minDist) {
                        mini.clear();
                        bestSucc.clear();
                        minDist = distance;
                    }
                    if (!max && distance <= minDist || max && distance >= minDist) {
                        mini.add(list[ti]);
                        bestSucc.add(succ);
                    }
                    ++i;
                    if (list[0] > 1000 && ti % 1000 == 0 && (dur = System.currentTimeMillis() - time + 1L) > (long)(1000 * timeout)) break;
                    ++ti;
                }
                int chosen = rand.nextInt(bestSucc.size());
                state = (SparseIntArray)bestSucc.get(chosen);
                last = (Integer)mini.get(chosen);
                this.wu.updateEnabled(state, list, last);
            }
            ++i;
        }
        dur = System.currentTimeMillis() - time + 1L;
        stats.addStats(i, nbresets, dur);
        return verdicts;
    }

    private boolean updateVerdicts(List<Expression> exprs, SparseIntArray state, int[] verdicts) {
        int cnt = 0;
        int[] nArray = verdicts;
        int n = verdicts.length;
        int n2 = 0;
        while (n2 < n) {
            int v2 = nArray[n2];
            if (v2 == 0) {
                ++cnt;
            }
            ++n2;
        }
        if (cnt == 0) {
            return false;
        }
        int[] todo = new int[cnt];
        int cur = 0;
        int i = 0;
        int ie = verdicts.length;
        while (i < ie) {
            if (verdicts[i] == 0) {
                todo[cur++] = i;
            }
            ++i;
        }
        AtomicBoolean remains = new AtomicBoolean(false);
        ((IntStream)Arrays.stream(todo).unordered()).parallel().forEach(v -> {
            if (((Expression)exprs.get(v)).eval(state) == 1) {
                nArray[v] = 1;
            } else {
                remains.set(true);
            }
        });
        return remains.get();
    }

    private void updateMaxVerdicts(List<Expression> exprs, SparseIntArray state, int[] verdicts) {
        int v = 0;
        while (v < verdicts.length) {
            verdicts[v] = Math.max(exprs.get(v).eval(state), verdicts[v]);
            ++v;
        }
    }

    public void runGuidedDeadlockDetection(long nbSteps, SparseIntArray parikhori, List<Integer> repr, int timeout) throws DeadlockFound {
        long dur;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        long time = System.currentTimeMillis();
        Map<Integer, List<Integer>> repSet = InvariantCalculator.computeMap(repr);
        SparseIntArray parikh = InvariantCalculator.transformParikh(parikhori, repSet);
        parikhori = parikh.clone();
        SparseIntArray state = this.wu.getInitial();
        int[] list = (int[])this.wu.getInitialEnabling().clone();
        this.wu.dropEmpty(list);
        this.wu.dropUnavailable(list, parikh);
        SparseIntArray initstate = state.clone();
        int[] initlist = (int[])list.clone();
        long nbresets = 0L;
        int i = 0;
        while ((long)i < nbSteps) {
            dur = System.currentTimeMillis() - time + 1L;
            if (dur > (long)(1000 * timeout)) {
                System.out.println("Interrupted Parikh directed walk after " + i + "  steps, including " + nbresets + " resets, run timeout after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                break;
            }
            if (list[0] == 0) {
                list = this.computeEnabled(state);
                if (list[0] == 0) {
                    System.out.println("Interrupted Parikh directed walk after " + i + "  steps, including " + nbresets + " resets, run found a deadlock after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                    throw new DeadlockFound();
                }
                ++nbresets;
                state = initstate.clone();
                list = (int[])initlist.clone();
                parikh = parikhori.clone();
            } else {
                int r = rand.nextInt(list[0]) + 1;
                int tfired = list[r];
                SparseIntArray newstate = this.wu.fire(tfired, state);
                this.wu.updateEnabled(newstate, list, tfired);
                for (int tr : repSet.get(repr.get(tfired))) {
                    parikh.put(tr, parikh.get(tr) - 1);
                }
                if (rand.nextDouble() < 1.0 - (double)nbresets * 0.001) {
                    this.wu.dropUnavailable(list, parikh);
                }
                state = newstate;
            }
            ++i;
        }
        dur = System.currentTimeMillis() - time + 1L;
        System.out.println("Parikh directed walk for " + i + "  steps, including " + nbresets + " resets, run took " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
    }

    public void runDeadlockDetection(long nbSteps, boolean fullRand, int timeout) throws DeadlockFound {
        long dur;
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        long time = System.currentTimeMillis();
        SparseIntArray state = this.wu.getInitial();
        int[] list = (int[])this.wu.getInitialEnabling().clone();
        this.wu.dropEmpty(list);
        SparseIntArray initstate = state.clone();
        int[] initlist = (int[])list.clone();
        int last = -1;
        long nbresets = 0L;
        int i = 0;
        while ((long)i < nbSteps) {
            dur = System.currentTimeMillis() - time + 1L;
            if (dur > (long)(1000 * timeout)) {
                System.out.println("Interrupted Random " + (fullRand ? "" : "directed ") + " walk after " + i + "  steps, including " + nbresets + " resets, run timeout after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                return;
            }
            if (list[0] == 0) {
                list = this.computeEnabled(state);
                if (list[0] == 0) {
                    System.out.println("Finished random " + (fullRand ? "" : "directed ") + " walk after " + i + "  steps, including " + nbresets + " resets, run found a deadlock after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                    throw new DeadlockFound();
                }
                ++nbresets;
                last = -1;
                state = initstate.clone();
                list = (int[])initlist.clone();
            } else {
                int r = rand.nextInt(list[0]) + 1;
                int tfired = list[r];
                boolean repeat = this.shouldRepeatLast(last, state, rand);
                if (repeat) {
                    tfired = last;
                    do {
                        state = this.wu.fire(tfired, state);
                        ++i;
                    } while (SparseIntArray.greaterOrEqual(state, this.wu.getFlowPT().getColumn(tfired)));
                    this.wu.updateEnabled(state, list, tfired);
                    last = -1;
                } else if (list[0] == 1 || fullRand || rand.nextDouble() >= 0.6) {
                    SparseIntArray newstate = this.wu.fire(tfired, state);
                    this.wu.updateEnabled(newstate, list, tfired);
                    last = tfired;
                    state = newstate;
                } else {
                    SparseIntArray[] succ = new SparseIntArray[list[0]];
                    int ti = 1;
                    while (ti - 1 < list[0]) {
                        succ[ti - 1] = this.wu.fire(list[ti], state);
                        ++i;
                        ++ti;
                    }
                    int minSucc = this.wu.getFlowPT().getColumnCount() + 1;
                    int mini = -1;
                    int[] minList = null;
                    int ti2 = 0;
                    while (ti2 < succ.length) {
                        int[] listC = Arrays.copyOf(list, list.length);
                        this.wu.updateEnabled(succ[ti2], listC, list[ti2 + 1]);
                        if (listC[0] < minSucc || listC[0] == minSucc && rand.nextDouble() >= 0.5) {
                            minSucc = listC[0];
                            mini = ti2;
                            minList = listC;
                        }
                        ++ti2;
                    }
                    state = succ[mini];
                    last = list[mini + 1];
                    list = minList;
                }
            }
            ++i;
        }
        dur = System.currentTimeMillis() - time + 1L;
        System.out.println("Random " + (fullRand ? "" : "directed ") + "walk for " + i + "  steps, including " + nbresets + " resets, run took " + dur + " ms (no deadlock found). (steps per millisecond=" + (long)i / dur + " )" + "");
    }

    public boolean shouldRepeatLast(int last, SparseIntArray state, ThreadLocalRandom rand) {
        boolean repeat = false;
        if (last != -1 && this.wu.getFlowPT().getColumn(last).size() > 0 && rand.nextDouble() < 0.98 && SparseIntArray.greaterOrEqual(state, this.wu.getFlowPT().getColumn(last))) {
            SparseIntArray combb = this.wu.getCombFlow().getColumn(last);
            int j = 0;
            int je = combb.size();
            while (j < je) {
                if (combb.valueAt(j) < 0) {
                    repeat = true;
                    break;
                }
                ++j;
            }
        }
        return repeat;
    }

    public int[] runProbabilisticReachabilityDetectionWithEnabled(long nbSteps, List<Expression> exprs, int timeout, int bestFirst, boolean exhaustive, WasExhaustive wex) {
        long time = System.currentTimeMillis();
        boolean isLifo = false;
        SparseIntArray istate = this.wu.getInitial();
        int[] verdicts = new int[exprs.size()];
        int i = 0;
        long seen = 1L;
        try {
            long dur;
            ArrayDeque<SparseIntArray> todo = new ArrayDeque<SparseIntArray>();
            todo.add(istate);
            ArrayDeque<int[]> todoEnabled = new ArrayDeque<int[]>();
            todoEnabled.add((int[])this.wu.getInitialEnabling().clone());
            BloomFilter bloom = null;
            HashSet<SparseIntArray> real = null;
            if (!exhaustive) {
                bloom = new BloomFilter(10000000, 0x8000000);
                bloom.add(istate);
            } else {
                real = new HashSet<SparseIntArray>();
                real.add(istate);
            }
            if (!this.updateVerdicts(exprs, istate, verdicts)) {
                System.out.println("Finished probabilistic random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in 0 ms. (steps per millisecond=0 )" + "");
                return verdicts;
            }
            int shuffled = 0;
            while ((long)i < nbSteps && !todo.isEmpty() && (long)todo.size() < nbSteps) {
                int[] list;
                SparseIntArray state;
                dur = System.currentTimeMillis() - time + 1L;
                if (dur > (long)(1000 * timeout)) {
                    System.out.println("Interrupted probabilistic random walk after " + i + "  steps, run timeout after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count() + " out of " + exprs.size());
                    break;
                }
                if (isLifo) {
                    state = (SparseIntArray)todo.pollLast();
                    list = (int[])todoEnabled.pollLast();
                } else {
                    state = (SparseIntArray)todo.pollFirst();
                    list = (int[])todoEnabled.pollFirst();
                }
                if (list[0] != 0) {
                    boolean dobreak = false;
                    int ti = 1;
                    while (ti - 1 < list[0] && (long)i < nbSteps && (long)todo.size() < nbSteps) {
                        SparseIntArray succ = this.wu.fire(list[ti], state);
                        if (!exhaustive) {
                            if (!bloom.contains(succ)) {
                                todo.add(succ);
                                en = (int[])list.clone();
                                this.wu.updateEnabled(succ, en, list[ti]);
                                todoEnabled.add(en);
                                bloom.add(succ);
                                ++seen;
                                if (!this.updateVerdicts(exprs, succ, verdicts)) {
                                    System.out.println("Finished probabilistic random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                                    dobreak = true;
                                    break;
                                }
                            }
                        } else if (!real.contains(succ)) {
                            todo.add(succ);
                            en = (int[])list.clone();
                            this.wu.updateEnabled(succ, en, list[ti]);
                            todoEnabled.add(en);
                            real.add(succ);
                            ++seen;
                            if (!this.updateVerdicts(exprs, succ, verdicts)) {
                                System.out.println("Finished exhaustive random walk after " + i + "  steps, run visited all " + exprs.size() + " properties in " + dur + " ms. (steps per millisecond=" + (long)i / dur + " )" + "");
                                dobreak = true;
                                break;
                            }
                        }
                        if (list[0] > 1000 && ti % 1000 == 0 && (dur = System.currentTimeMillis() - time + 1L) > (long)(1000 * timeout)) {
                            dobreak = true;
                            break;
                        }
                        ++ti;
                        ++i;
                    }
                    if (dobreak) break;
                    if (i / 10000 > shuffled) {
                        shuffled = i / 1000;
                        isLifo = !isLifo;
                    }
                }
                ++i;
            }
            if (todo.isEmpty()) {
                wex.wasExhaustive = true;
                if (!exhaustive) {
                    System.out.println("Probably explored full state space saw : " + seen + "  states, properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
                } else {
                    System.out.println("Explored full state space saw : " + seen + "  states, properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
                }
            }
            dur = System.currentTimeMillis() - time + 1L;
            if (!exhaustive) {
                System.out.println("Probabilistic random walk after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
            } else {
                System.out.println("Exhaustive walk after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            long dur = System.currentTimeMillis() - time + 1L;
            System.out.println("Probabilistic random walk exhausted memory after " + i + "  steps, saw " + seen + " distinct states, run finished after " + dur + " ms. (steps per millisecond=" + (long)i / dur + " ) properties seen :" + Arrays.stream(verdicts).filter(x -> x > 0).count());
        }
        return verdicts;
    }

    public static class WalkStats {
        WalkType type;
        int steps;
        long resets;
        long duration;
        int states = -1;

        public WalkStats(WalkType wt) {
            this.type = wt;
        }

        public synchronized void addStats(int steps, long resets, long duration) {
            this.steps += steps;
            this.resets += resets;
            this.duration += duration;
        }

        public synchronized void setStates(int states) {
            this.states = states;
        }

        public String toString() {
            return String.valueOf((Object)this.type) + " walk for " + this.steps + " steps (" + this.resets + " resets) in " + this.duration + " ms. (" + (long)this.steps / (this.duration + 1L) + " steps per ms)" + (String)(this.states > 0 ? " saw " + this.states + " states" : "");
        }
    }

    public static enum WalkType {
        RANDOM,
        BEST_FIRST,
        PARIKH,
        MAX,
        PROBABILISTIC,
        EXHAUSTIVE;

    }

    public static class WasExhaustive {
        public boolean wasExhaustive = false;
    }
}

