/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SiphonComputer {
    public static Set<Integer> computeEmptySyphon(IntMatrixCol flowPT, IntMatrixCol flowTP, List<Integer> marks) {
        long time = System.currentTimeMillis();
        HashSet<Integer> keepP = new HashSet<Integer>();
        HashSet<Integer> keepT = new HashSet<Integer>();
        int i = 0;
        int ie = marks.size();
        while (i < ie) {
            if (marks.get(i) == 0) {
                keepP.add(i);
            }
            ++i;
        }
        i = 0;
        ie = flowTP.getColumnCount();
        while (i < ie) {
            if (flowTP.getColumn(i).size() > 0) {
                keepT.add(i);
            }
            ++i;
        }
        int doneIter = 0;
        do {
            doneIter = 0;
            int tid = flowPT.getColumnCount();
            while (tid >= 0) {
                if (keepT.contains(tid)) {
                    boolean feeds = false;
                    SparseIntArray tp = flowTP.getColumn(tid);
                    int i2 = 0;
                    int ie2 = tp.size();
                    while (i2 < ie2) {
                        if (keepP.contains(tp.keyAt(i2))) {
                            feeds = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!feeds) {
                        keepT.remove(tid);
                        ++doneIter;
                    } else {
                        SparseIntArray pt = flowPT.getColumn(tid);
                        boolean eats = false;
                        int i3 = 0;
                        int ie3 = pt.size();
                        while (i3 < ie3) {
                            if (keepP.contains(pt.keyAt(i3))) {
                                eats = true;
                                break;
                            }
                            ++i3;
                        }
                        if (!eats) {
                            SparseIntArray tp2 = flowTP.getColumn(tid);
                            int i4 = 0;
                            int e = tp2.size();
                            while (i4 < e) {
                                keepP.remove(tp2.keyAt(i4));
                                ++i4;
                            }
                            ++doneIter;
                            keepT.remove(tid);
                        }
                    }
                }
                --tid;
            }
        } while (doneIter > 0);
        if (keepP.isEmpty()) {
            return new HashSet<Integer>();
        }
        System.out.println("Deduced a syphon composed of " + keepP.size() + " places in " + (System.currentTimeMillis() - time) + " ms");
        return keepP;
    }
}

