/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.LogicSimplifier;
import fr.lip6.move.gal.structural.PetriNet;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.SiphonComputer;
import fr.lip6.move.gal.structural.StructuralReduction;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Simplifier;
import fr.lip6.move.gal.structural.expr.VarRef;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SparsePetriNet
extends PetriNet
implements ISparsePetriNet {
    private List<Integer> marks = new ArrayList<Integer>();
    private IntMatrixCol flowPT = new IntMatrixCol(0, 0);
    private IntMatrixCol flowTP = new IntMatrixCol(0, 0);
    private List<String> tnames = new ArrayList<String>();
    private List<String> pnames = new ArrayList<String>();
    private int maxArcValue = 0;
    private boolean isSafe = false;
    private static final int DEBUG = 0;
    private boolean isSkeleton = false;

    public SparsePetriNet() {
    }

    public SparsePetriNet(SparsePetriNet spn) {
        for (Property p : spn.getProperties()) {
            super.getProperties().add(p.copy());
        }
        this.marks = new ArrayList<Integer>(spn.marks);
        this.flowPT = new IntMatrixCol(spn.flowPT);
        this.flowTP = new IntMatrixCol(spn.flowTP);
        this.tnames = new ArrayList<String>(spn.tnames);
        this.pnames = new ArrayList<String>(spn.pnames);
        this.maxArcValue = spn.maxArcValue;
        this.isSafe = spn.isSafe;
        this.isSkeleton = spn.isSkeleton;
    }

    public void setSkeleton(boolean isSkeleton) {
        this.isSkeleton = isSkeleton;
    }

    public boolean isSkeleton() {
        return this.isSkeleton;
    }

    @Override
    public void setSafe(boolean isSafe) {
        this.isSafe = isSafe;
    }

    @Override
    public boolean isSafe() {
        return this.isSafe;
    }

    public int addTransition(String tname) {
        this.flowPT.appendColumn(new SparseIntArray());
        this.flowTP.appendColumn(new SparseIntArray());
        this.tnames.add(tname);
        return this.tnames.size() - 1;
    }

    public int addPlace(String pname, int init) {
        this.flowPT.addRow();
        this.flowTP.addRow();
        this.pnames.add(pname);
        this.marks.add(init);
        return this.pnames.size() - 1;
    }

    public void addPreArc(int p, int t, int val) {
        this.flowPT.getColumn(t).put(p, val);
        this.maxArcValue = Math.max(this.maxArcValue, val);
    }

    public void addPostArc(int p, int t, int val) {
        this.flowTP.getColumn(t).put(p, val);
        this.maxArcValue = Math.max(this.maxArcValue, val);
    }

    @Override
    public int getTransitionCount() {
        return this.tnames.size();
    }

    @Override
    public int getPlaceCount() {
        return this.pnames.size();
    }

    @Override
    public List<String> getTnames() {
        return this.tnames;
    }

    @Override
    public List<String> getPnames() {
        return this.pnames;
    }

    @Override
    public int getTransitionIndex(String name) {
        return this.tnames.indexOf(name);
    }

    @Override
    public IntMatrixCol getFlowPT() {
        return this.flowPT;
    }

    @Override
    public IntMatrixCol getFlowTP() {
        return this.flowTP;
    }

    @Override
    public int getMaxArcValue() {
        return this.maxArcValue;
    }

    @Override
    public List<Integer> getMarks() {
        return this.marks;
    }

    @Override
    public int getPlaceIndex(String name) {
        return this.pnames.indexOf(name);
    }

    public void toPredicates() {
        this.toPredicates(this.getProperties());
    }

    public int testInInitial() {
        SparseIntArray spinit = new SparseIntArray(this.marks);
        return LogicSimplifier.simplifyWithInitial(this.getProperties(), spinit, this);
    }

    public int testInDeadlock() {
        return LogicSimplifier.simplifyWithDead(this.getProperties());
    }

    private Expression simplifyConstants(Expression expr, int[] perm) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = this.simplifyConstants(bin.left, perm);
            Expression r = this.simplifyConstants(bin.right, perm);
            if (l != bin.left || r != bin.right) {
                return Expression.op(bin.op, l, r);
            }
            return expr;
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>(nop.getChildren().size());
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression e = this.simplifyConstants(child, perm);
                resc.add(e);
                if (e == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        if (expr instanceof VarRef) {
            VarRef vref = (VarRef)expr;
            int img = perm[vref.getValue()];
            if (img == -1) {
                return Expression.constant(this.marks.get(vref.getValue()));
            }
            if (img == vref.getValue()) {
                return expr;
            }
            return Expression.var(img);
        }
        return expr;
    }

    public void assumeOneSafe() {
        for (Property prop : this.getProperties()) {
            Expression redProp = Simplifier.assumeOnebounded(prop.getBody());
            if (redProp == prop) continue;
            prop.setBody(redProp);
        }
    }

    public int removeConstantPlaces() {
        return this.removeConstantPlaces(Collections.emptyList());
    }

    public int removeConstantPlaces(List<Expression> atomicProps) {
        int totalp = 0;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        TreeSet<Integer> todelTrans = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
        int[] perm = new int[tflowPT.getColumnCount()];
        int index = 0;
        ArrayList prem = new ArrayList();
        ArrayList<String> trem = new ArrayList<String>();
        Set<Integer> syphon = SiphonComputer.computeEmptySyphon(this.flowPT, this.flowTP, this.marks);
        int pid = 0;
        int pe = this.pnames.size();
        while (pid < pe) {
            SparseIntArray from = tflowPT.getColumn(pid);
            SparseIntArray to = tflowTP.getColumn(pid);
            if (syphon.contains(pid) || from.equals(to) || to.size() == 0 && this.marks.get(pid) == 0) {
                int m = this.marks.get(pid);
                int tpos = 0;
                while (tpos < from.size()) {
                    int taken = from.valueAt(tpos);
                    if (taken > m) {
                        todelTrans.add(from.keyAt(tpos));
                    }
                    ++tpos;
                }
                perm[pid] = -1;
                ++totalp;
            } else {
                perm[pid] = index++;
            }
            ++pid;
        }
        int totaltok = 0;
        if (totalp > 0) {
            for (Property prop : this.getProperties()) {
                prop.setBody(this.simplifyConstants(prop.getBody(), perm));
            }
            int i = 0;
            while (i < atomicProps.size()) {
                atomicProps.set(i, this.simplifyConstants(atomicProps.get(i), perm));
                ++i;
            }
            int pid2 = perm.length - 1;
            while (pid2 >= 0) {
                if (perm[pid2] == -1) {
                    tflowPT.deleteColumn(pid2);
                    tflowTP.deleteColumn(pid2);
                    this.pnames.remove(pid2);
                    totaltok += this.marks.remove(pid2).intValue();
                }
                --pid2;
            }
            tflowPT.transposeTo(this.flowPT);
            tflowTP.transposeTo(this.flowTP);
        }
        if (!todelTrans.isEmpty()) {
            Iterator<Property> iterator = todelTrans.iterator();
            while (iterator.hasNext()) {
                int tid = (Integer)((Object)iterator.next());
                this.flowPT.deleteColumn(tid);
                this.flowTP.deleteColumn(tid);
                trem.add(this.tnames.remove(tid));
            }
        }
        if (totalp > 0 || !todelTrans.isEmpty()) {
            System.out.println("Reduce places removed " + totalp + " places and " + todelTrans.size() + " transitions. " + "");
            this.simplifyLogic();
        }
        return totaltok;
    }

    public boolean rewriteConstantSums() {
        HashMap<Set<Integer>, Integer> constantSums = new HashMap<Set<Integer>, Integer>();
        HashSet<Set<Integer>> varSums = new HashSet<Set<Integer>>();
        for (Property p : this.getProperties()) {
            p.setBody(this.findAndTestSums(p.getBody(), constantSums, varSums));
        }
        return !constantSums.isEmpty();
    }

    private Expression findAndTestSums(Expression expr, Map<Set<Integer>, Integer> constantSums, Set<Set<Integer>> varSums) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = this.findAndTestSums(bin.left, constantSums, varSums);
            Expression r = this.findAndTestSums(bin.right, constantSums, varSums);
            if (l != bin.left || r != bin.right) {
                return Expression.op(bin.getOp(), l, r);
            }
            return expr;
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            if (nop.getOp() == Op.ADD) {
                HashSet<Integer> vars = new HashSet<Integer>();
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() != Op.PLACEREF) continue;
                    vars.add(child.getValue());
                }
                Integer val = constantSums.get(vars);
                if (val == null && varSums.contains(vars)) {
                    return expr;
                }
                if (val == null) {
                    boolean isCst = this.testIsConstantSum(vars);
                    if (isCst) {
                        int sumVal = 0;
                        for (Integer n : vars) {
                            sumVal += this.marks.get(n).intValue();
                        }
                        constantSums.put(vars, sumVal);
                        val = sumVal;
                    } else {
                        varSums.add(vars);
                    }
                }
                if (val != null) {
                    ArrayList<Expression> resc = new ArrayList<Expression>();
                    for (Expression child : nop.getChildren()) {
                        if (child.getOp() == Op.PLACEREF) continue;
                        resc.add(child);
                    }
                    resc.add(Expression.constant(val));
                    return Expression.nop(nop.getOp(), resc);
                }
            } else {
                ArrayList<Expression> resc = new ArrayList<Expression>();
                boolean changed = false;
                for (Expression child : nop.getChildren()) {
                    Expression expression = this.findAndTestSums(child, constantSums, varSums);
                    resc.add(expression);
                    if (expression == child) continue;
                    changed = true;
                }
                if (!changed) {
                    return expr;
                }
                return Expression.nop(nop.getOp(), resc);
            }
        }
        return expr;
    }

    private boolean testIsConstantSum(Set<Integer> vars) {
        int tid = 0;
        int te = this.tnames.size();
        while (tid < te) {
            int taken = 0;
            SparseIntArray pt = this.flowPT.getColumn(tid);
            int i = 0;
            int ie = pt.size();
            while (i < ie) {
                if (vars.contains(pt.keyAt(i))) {
                    taken += pt.valueAt(i);
                }
                ++i;
            }
            int given = 0;
            SparseIntArray tp = this.flowTP.getColumn(tid);
            int i2 = 0;
            int ie2 = tp.size();
            while (i2 < ie2) {
                if (vars.contains(tp.keyAt(i2))) {
                    given += tp.valueAt(i2);
                }
                ++i2;
            }
            if (taken != given) {
                return false;
            }
            ++tid;
        }
        return true;
    }

    public void simplifyLogic() {
        for (Property prop : this.getProperties()) {
            prop.setBody(Simplifier.pushNegation(prop.getBody()));
            prop.setBody(Simplifier.simplifySumComparisons(prop.getBody()));
            prop.setBody(Simplifier.assumeVarsPositive(prop.getBody()));
            prop.setBody(Simplifier.simplifyBoolean(prop.getBody()));
        }
        this.rewriteConstantSums();
    }

    public void readFrom(StructuralReduction sr) {
        this.readFrom(sr, null);
    }

    public List<Expression> readFrom(StructuralReduction sr, List<Expression> original) {
        this.flowPT = sr.getFlowPT();
        this.flowTP = sr.getFlowTP();
        this.marks = new ArrayList<Integer>(sr.getMarks());
        this.maxArcValue = sr.getMaxArcValue();
        this.tnames = sr.getTnames();
        int[] perm = new int[this.pnames.size()];
        this.isSafe = sr.isSafe();
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        int i = 0;
        int ie = this.pnames.size();
        while (i < ie) {
            indexes.put(this.pnames.get(i), i);
            ++i;
        }
        HashMap<String, Integer> newindexes = new HashMap<String, Integer>();
        int i2 = 0;
        int ie2 = sr.getPnames().size();
        while (i2 < ie2) {
            newindexes.put(sr.getPnames().get(i2), i2);
            ++i2;
        }
        i2 = 0;
        ie2 = this.pnames.size();
        while (i2 < ie2) {
            Integer newind = (Integer)newindexes.get(this.pnames.get(i2));
            perm[i2] = newind == null ? -1 : newind;
            ++i2;
        }
        this.pnames = sr.getPnames();
        for (Property prop : this.getProperties()) {
            prop.setBody(this.simplifyConstants(prop.getBody(), perm));
        }
        if (original == null) {
            return null;
        }
        ArrayList<Expression> mapped = new ArrayList<Expression>(original.size());
        for (Expression e : original) {
            mapped.add(this.simplifyConstants(e, perm));
        }
        return mapped;
    }

    public void removeRedundantTransitions(boolean andEmptyEffects) {
        int reduced = 0;
        if (andEmptyEffects) {
            ArrayList<Integer> todrop = new ArrayList<Integer>();
            int i = this.tnames.size() - 1;
            while (i >= 0) {
                if (this.flowPT.getColumn(i).equals(this.flowTP.getColumn(i))) {
                    todrop.add(i);
                }
                --i;
            }
            if (!todrop.isEmpty()) {
                reduced += todrop.size();
                Iterator iterator = todrop.iterator();
                while (iterator.hasNext()) {
                    int tid = (Integer)iterator.next();
                    this.flowPT.deleteColumn(tid);
                    this.flowTP.deleteColumn(tid);
                    this.tnames.remove(tid);
                }
            }
        }
        if ((reduced += this.ensureUnique(this.flowPT, this.flowTP, this.tnames)) > 0) {
            System.out.println("Reduce redundant transitions removed " + reduced + " transitions.");
        }
    }

    private int ensureUnique(IntMatrixCol mPT, IntMatrixCol mTP, List<String> names) {
        HashMap<SparseIntArray, Map> seen = new HashMap<SparseIntArray, Map>();
        ArrayList<Integer> todel = new ArrayList<Integer>();
        int trid = mPT.getColumnCount() - 1;
        while (trid >= 0) {
            SparseIntArray tcolPT = mPT.getColumn(trid);
            SparseIntArray tcolTP = mTP.getColumn(trid);
            Integer b = seen.computeIfAbsent(tcolPT, k -> new HashMap()).put(tcolTP, trid);
            if (b != null) {
                todel.add(trid);
            }
            --trid;
        }
        ArrayList<String> rem = new ArrayList<String>();
        Iterator iterator = todel.iterator();
        while (iterator.hasNext()) {
            int td = (Integer)iterator.next();
            rem.add(names.remove(td));
            mPT.deleteColumn(td);
            mTP.deleteColumn(td);
        }
        if (!todel.isEmpty()) {
            System.out.println("Ensure Unique test removed " + rem.size() + " transitions" + "");
        }
        return todel.size();
    }

    public int getArcCount() {
        return this.getFlowPT().getColumns().stream().mapToInt(c -> c.size()).sum() + this.getFlowTP().getColumns().stream().mapToInt(c -> c.size()).sum();
    }

    public boolean isConservative() {
        int t = 0;
        int te = this.getTransitionCount();
        while (t < te) {
            if (this.flowPT.getColumn(t).sumValues() != this.flowTP.getColumn(t).sumValues()) {
                return false;
            }
            ++t;
        }
        return true;
    }

    public void setInitial(List<Integer> marks) {
        this.marks = marks;
    }
}

