/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.graph.Tarjan;
import fr.lip6.move.gal.structural.DeadlockFound;
import fr.lip6.move.gal.structural.FlowPrinter;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.structural.NoDeadlockExists;
import fr.lip6.move.gal.structural.SiphonComputer;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class StructuralReduction
implements Cloneable,
ISparsePetriNet {
    private List<Expression> image;
    private List<Integer> marks;
    private IntMatrixCol flowPT;
    private IntMatrixCol flowTP;
    private final List<String> tnames;
    private final List<String> pnames;
    private int maxArcValue;
    private BitSet untouchable;
    private BitSet tokeepImages;
    private boolean keepImage = false;
    private boolean isSafe = false;
    private static final int DEBUG = 0;

    public StructuralReduction(List<Expression> image, List<Integer> marks, IntMatrixCol flowPT, IntMatrixCol flowTP, List<String> tnames, List<String> pnames, int maxArcValue, BitSet untouchable, BitSet tokeepImages, boolean keepImage, boolean isSafe) {
        this.image = image;
        this.marks = marks;
        this.flowPT = flowPT;
        this.flowTP = flowTP;
        this.tnames = tnames;
        this.pnames = pnames;
        this.maxArcValue = maxArcValue;
        this.untouchable = untouchable;
        this.tokeepImages = tokeepImages;
        this.keepImage = keepImage;
        this.isSafe = isSafe;
    }

    private StructuralReduction(IntMatrixCol flowPT, IntMatrixCol flowTP, List<Integer> marks, List<String> tnames, List<String> pnames, int maxArcValue, BitSet untouchable) {
        this.flowPT = new IntMatrixCol(flowPT);
        this.flowTP = new IntMatrixCol(flowTP);
        this.marks = new ArrayList<Integer>(marks);
        this.tnames = new ArrayList<String>(tnames);
        this.pnames = new ArrayList<String>(pnames);
        this.maxArcValue = maxArcValue;
        this.untouchable = (BitSet)untouchable.clone();
        this.tokeepImages = new BitSet();
    }

    public StructuralReduction(ISparsePetriNet spn) {
        this(spn.getFlowPT(), spn.getFlowTP(), spn.getMarks(), spn.getTnames(), spn.getPnames(), spn.getMaxArcValue(), spn.computeSupport());
        if (spn instanceof StructuralReduction) {
            StructuralReduction sr2 = (StructuralReduction)spn;
            this.image = new ArrayList<Expression>(sr2.image);
        } else {
            this.image = new ArrayList<Expression>(this.getPlaceCount());
            int i = 0;
            int ie = this.getPlaceCount();
            while (i < ie) {
                this.image.add(Expression.var(i));
                ++i;
            }
        }
        this.isSafe = spn.isSafe();
    }

    public List<Expression> getImage() {
        return this.image;
    }

    public void setKeepImage(boolean keepImage) {
        this.keepImage = keepImage;
    }

    public BitSet getTokeepImages() {
        return this.tokeepImages;
    }

    public StructuralReduction clone() {
        StructuralReduction clone = new StructuralReduction(this.flowPT, this.flowTP, this.marks, this.tnames, this.pnames, this.maxArcValue, this.untouchable);
        clone.image = new ArrayList<Expression>(this.image);
        clone.keepImage = this.keepImage;
        clone.tokeepImages = (BitSet)this.tokeepImages.clone();
        clone.isSafe = this.isSafe;
        return clone;
    }

    @Override
    public BitSet computeSupport() {
        return this.untouchable;
    }

    @Override
    public int getMaxArcValue() {
        return this.maxArcValue;
    }

    public int reduce(ReductionType rt) throws NoDeadlockExists, DeadlockFound {
        if (rt == ReductionType.NONE) {
            return 0;
        }
        int initP = this.pnames.size();
        int initT = this.tnames.size();
        long time = System.currentTimeMillis();
        int total = 0;
        int totaliter = 0;
        int iter = 0;
        if (rt == ReductionType.STATESPACE) {
            total += this.ruleReducePlaces(rt, false, false);
            total += this.ruleReduceTrans(rt);
            total += this.ruleRedundantCompositions(rt);
            total += this.ruleReducePlaces(rt, false, false);
            return total += this.ruleReduceTrans(rt);
        }
        if (this.findFreeSCC(rt)) {
            ++total;
            totaliter += this.ruleReduceTrans(rt);
        }
        if (this.findAndReduceSCCSuffixes(rt)) {
            ++total;
        }
        if (rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL) {
            totaliter += this.ruleReducePlaces(rt, false, true);
        }
        int deltatpos = 0;
        do {
            int tsz = this.tnames.size();
            do {
                totaliter = 0;
                totaliter += this.ruleReducePlaces(rt, false, false);
                totaliter += this.ruleReduceTrans(rt);
                totaliter += this.findAndReduceSCCSuffixes(rt) ? 1 : 0;
                int implicit = this.ruleImplicitPlace();
                if ((totaliter += implicit) > 0 && this.findFreeSCC(rt)) {
                    ++totaliter;
                }
                int agglo = this.ruleTrivialPostAgglo(rt);
                totaliter += agglo;
                if (agglo == 0) {
                    totaliter += this.rulePostAgglo(false, true, rt);
                }
                total += totaliter;
                if (totaliter <= 0) continue;
                System.out.println("Iterating post reduction " + iter++ + " with " + totaliter + " rules applied. Total rules applied " + total + " place count " + this.pnames.size() + " transition count " + this.tnames.size());
            } while (totaliter > 0);
            totaliter = 0;
            if ((totaliter += this.rulePreAgglo(false, rt)) > 0) {
                System.out.println("Pre-agglomeration after " + iter + " with " + totaliter + " Pre rules applied. Total rules applied " + total + " place count " + this.pnames.size() + " transition count " + this.tnames.size());
            }
            if (this.tnames.stream().anyMatch(s -> s.length() >= 1024)) {
                System.out.println("Renaming transitions due to excessive name length > 1024 char.");
                int i = 0;
                while (i < this.tnames.size()) {
                    this.tnames.set(i, "t" + i);
                    ++i;
                }
            }
            if (totaliter == 0) {
                int sym = this.ruleFusePlaceByFuture(rt);
                total += (totaliter += sym);
                if (sym > 0) {
                    System.out.println("Symmetric choice reduction at " + iter + " with " + sym + " rule applications. Total rules  " + total + " place count " + this.pnames.size() + " transition count " + this.tnames.size());
                }
            }
            if (totaliter == 0) {
                totaliter += this.rulePostAgglo(false, false, rt);
            }
            if (totaliter == 0) {
                totaliter += this.rulePostAgglo(true, false, rt);
            }
            if (totaliter == 0) {
                totaliter += this.rulePreAgglo(true, rt);
            }
            if (totaliter == 0) {
                totaliter += this.findFreeSCC(rt) ? 1 : 0;
            }
            if (totaliter == 0) {
                totaliter += this.findAndReduceSCCSuffixes(rt) ? 1 : 0;
            }
            if ((totaliter += this.ruleReducePlaces(rt, true, false)) == 0) {
                totaliter += this.ruleRedundantCompositions(rt);
            }
            if (totaliter == 0 && rt == ReductionType.REACHABILITY) {
                totaliter += this.ruleFreeAgglo(false);
            }
            if (totaliter == 0 && rt == ReductionType.REACHABILITY) {
                totaliter += this.ruleFreeAgglo(true);
            }
            if (totaliter == 0 && rt == ReductionType.REACHABILITY) {
                totaliter += this.rulePartialFreeAgglo();
            }
            if (!(totaliter != 0 || rt != ReductionType.REACHABILITY && (rt != ReductionType.SI_LTL && rt != ReductionType.LI_LTL && rt != ReductionType.SI_CTL || this.keepImage))) {
                totaliter += this.rulePartialPostAgglo(rt);
            }
            if (totaliter == 0) {
                totaliter += this.ruleReducePlaces(rt, false, true);
            }
            total += totaliter;
            if (totaliter > 0) {
                System.out.println("Iterating global reduction " + iter + " with " + totaliter + " rules applied. Total rules applied " + total + " place count " + this.pnames.size() + " transition count " + this.tnames.size());
            }
            deltatpos = this.tnames.size() > tsz ? ++deltatpos : 0;
            System.out.flush();
        } while (totaliter > 0 && deltatpos <= 3);
        System.out.println("Applied a total of " + total + " rules in " + (System.currentTimeMillis() - time) + " ms. Remains " + this.pnames.size() + " /" + initP + " variables (removed " + (initP - this.pnames.size()) + ") and now considering " + this.flowPT.getColumnCount() + "/" + initT + " (removed " + (initT - this.flowPT.getColumnCount()) + ") transitions.");
        System.out.flush();
        return total;
    }

    public int ruleRedundantCompositionsBounds() {
        if (this.tnames.size() > 20000) {
            return 0;
        }
        HashSet todel = new HashSet();
        HashMap<SparseIntArray, List> effects = new HashMap<SparseIntArray, List>();
        int tid = 0;
        int e = this.tnames.size();
        while (tid < e) {
            int t = tid;
            SparseIntArray effect = SparseIntArray.sumProd(-1, this.flowPT.getColumn(tid), 1, this.flowTP.getColumn(tid));
            SparseIntArray posEffect = new SparseIntArray();
            int i = 0;
            int ie = effect.size();
            while (i < ie) {
                int v2 = effect.valueAt(i);
                if (v2 > 0) {
                    posEffect.append(effect.keyAt(i), v2);
                }
                ++i;
            }
            effects.compute(posEffect, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Integer>();
                    v.add(t);
                } else {
                    Iterator iterator = v.iterator();
                    while (iterator.hasNext()) {
                        HashSet<Integer> tset;
                        int to = (Integer)iterator.next();
                        if (SparseIntArray.greaterOrEqual(this.flowPT.getColumn(t), this.flowPT.getColumn(to))) {
                            todel.add(t);
                            tset = new HashSet<Integer>();
                            tset.add(t);
                            tset.add(to);
                            FlowPrinter.drawNet(this, "Discarding transition " + this.tnames.get(t) + " with rule Dominated (bounds)", new HashSet<Integer>(), tset);
                            continue;
                        }
                        if (!SparseIntArray.greaterOrEqual(this.flowPT.getColumn(to), this.flowPT.getColumn(t))) continue;
                        todel.add(to);
                        tset = new HashSet();
                        tset.add(t);
                        tset.add(to);
                        FlowPrinter.drawNet(this, "Discarding transition " + this.tnames.get(to) + " with rule Dominated (bounds)", new HashSet<Integer>(), tset);
                    }
                    v.add(t);
                    v.removeAll(todel);
                }
                return v;
            });
            ++tid;
        }
        if (!todel.isEmpty()) {
            this.dropTransitions(new ArrayList<Integer>(todel), "Dominated transitions (bounds rule).");
            System.out.println("Dominated transitions for bounds rules discarded " + todel.size() + " transitions");
        }
        return todel.size();
    }

    private int ruleRedundantCompositions(ReductionType rt) {
        if (this.tnames.size() > 20000 || rt == ReductionType.LIVENESS) {
            return 0;
        }
        HashSet todel = new HashSet();
        HashMap<SparseIntArray, List> effects = new HashMap<SparseIntArray, List>();
        ArrayList<Integer> tids = new ArrayList<Integer>();
        int tid = 0;
        int e = this.tnames.size();
        while (tid < e) {
            int t = tid;
            tids.add(t);
            effects.compute(SparseIntArray.sumProd(-1, this.flowPT.getColumn(tid), 1, this.flowTP.getColumn(tid)), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Integer>();
                    v.add(t);
                } else {
                    Iterator iterator = v.iterator();
                    while (iterator.hasNext()) {
                        int to = (Integer)iterator.next();
                        if (SparseIntArray.greaterOrEqual(this.flowPT.getColumn(t), this.flowPT.getColumn(to))) {
                            todel.add(t);
                            continue;
                        }
                        if (!SparseIntArray.greaterOrEqual(this.flowPT.getColumn(to), this.flowPT.getColumn(t))) continue;
                        todel.add(to);
                    }
                    v.add(t);
                    v.removeAll(todel);
                }
                return v;
            });
            ++tid;
        }
        if (rt != ReductionType.LTL && rt != ReductionType.LI_LTL) {
            IntMatrixCol tflowPT = this.flowPT.transpose();
            tids.sort((a, b) -> -Integer.compare(this.flowPT.getColumn((int)a).size() + this.flowTP.getColumn((int)a).size(), this.flowPT.getColumn((int)b).size() + this.flowTP.getColumn((int)b).size()));
            int id = 0;
            int e2 = tids.size();
            while (id < e2) {
                int tid2 = (Integer)tids.get(id);
                if (!todel.contains(tid2)) {
                    SparseIntArray pre = this.flowPT.getColumn(tid2);
                    SparseIntArray init = this.flowTP.getColumn(tid2);
                    SparseIntArray teff = SparseIntArray.sumProd(-1, pre, 1, init);
                    HashSet<Integer> potentialEnable = new HashSet<Integer>();
                    SparseIntArray feedT = this.flowTP.getColumn(tid2);
                    int pi = 0;
                    int ee = feedT.size();
                    while (pi < ee) {
                        int p = feedT.keyAt(pi);
                        SparseIntArray fedByP = tflowPT.getColumn(p);
                        int ti = 0;
                        while (ti < fedByP.size()) {
                            potentialEnable.add(fedByP.keyAt(ti));
                            ++ti;
                        }
                        ++pi;
                    }
                    boolean toucht = this.touches(tid2);
                    Iterator iterator = potentialEnable.iterator();
                    while (iterator.hasNext()) {
                        int ttid = (Integer)iterator.next();
                        if (todel.contains(ttid) || (rt == ReductionType.SI_LTL || rt == ReductionType.SI_CTL) && toucht && this.touches(ttid) || !SparseIntArray.greaterOrEqual(init, this.flowPT.getColumn(ttid))) continue;
                        int t = tid2;
                        int tt = ttid;
                        SparseIntArray tchain = SparseIntArray.sumProd(1, teff, 1, SparseIntArray.sumProd(-1, this.flowPT.getColumn(ttid), 1, this.flowTP.getColumn(ttid)));
                        effects.compute(tchain, (k, v) -> {
                            if (v != null) {
                                Iterator iterator = v.iterator();
                                while (iterator.hasNext()) {
                                    int to = (Integer)iterator.next();
                                    if (to == t || to == tt || !SparseIntArray.greaterOrEqual(this.flowPT.getColumn(to), pre)) continue;
                                    todel.add(to);
                                }
                                v.removeAll(todel);
                            }
                            return v;
                        });
                    }
                }
                ++id;
            }
        }
        if (!todel.isEmpty()) {
            this.dropTransitions(new ArrayList<Integer>(todel), "Redundant composition of simpler transitions.");
            System.out.println("Redundant transition composition rules discarded " + todel.size() + " transitions");
        }
        return todel.size();
    }

    public int rulePartialPostAgglo(ReductionType rt) {
        int tid;
        int ie;
        int i;
        IntMatrixCol tflowTP = null;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        int done = 0;
        HashSet<Integer> toreduce = new HashSet<Integer>();
        int pid = 0;
        int pide = this.getPlaceCount();
        while (pid < pide) {
            if (this.marks.get(pid) == 0 && !this.untouchable.get(pid)) {
                SparseIntArray tpt = tflowPT.getColumn(pid);
                boolean canReduce = true;
                boolean hasStutter = false;
                boolean hasNonStutter = false;
                i = 0;
                ie = tpt.size();
                while (i < ie) {
                    tid = tpt.keyAt(i);
                    SparseIntArray pt = this.flowPT.getColumn(tid);
                    if (pt.size() == 1 && pt.valueAt(0) == 1) {
                        if (this.touches(tid)) {
                            hasNonStutter = true;
                        } else {
                            hasStutter = true;
                        }
                    } else {
                        canReduce = false;
                        break;
                    }
                    ++i;
                }
                if (canReduce && hasNonStutter && hasStutter) {
                    toreduce.add(pid);
                }
            }
            ++pid;
        }
        ArrayList<Integer> todropt = new ArrayList<Integer>();
        if (!toreduce.isEmpty()) {
            Iterator iterator = toreduce.iterator();
            while (iterator.hasNext()) {
                int pid2 = (Integer)iterator.next();
                if (tflowTP == null) {
                    tflowTP = this.flowTP.transpose();
                }
                if (tflowPT == null) {
                    tflowPT = this.flowPT.transpose();
                }
                SparseIntArray ttp = tflowTP.getColumn(pid2);
                SparseIntArray tpt = tflowPT.getColumn(pid2);
                if (rt != ReductionType.DEADLOCK && ttp.size() > 1 || SparseIntArray.keysIntersect(tpt, ttp)) continue;
                boolean ok = true;
                i = 0;
                ie = ttp.size();
                while (i < ie) {
                    if (ttp.valueAt(i) > 1) {
                        ok = false;
                    }
                    ++i;
                }
                if (!ok) continue;
                i = 0;
                ie = tpt.size();
                while (i < ie) {
                    tid = tpt.keyAt(i);
                    if (!this.touches(tid)) {
                        int curt = this.tnames.size();
                        if (this.flowPT.getColumn(tid).size() == 1 && this.flowPT.getColumn(tid).valueAt(0) == 1) {
                            int j = 0;
                            int je = ttp.size();
                            while (j < je) {
                                int hi = ttp.keyAt(j);
                                SparseIntArray resPT = SparseIntArray.sumProd(1, this.flowPT.getColumn(tid), 1, this.flowPT.getColumn(hi), pid2);
                                this.flowPT.appendColumn(resPT);
                                SparseIntArray resTP = SparseIntArray.sumProd(1, this.flowTP.getColumn(tid), 1, this.flowTP.getColumn(hi), pid2);
                                this.flowTP.appendColumn(resTP);
                                String tname = this.tnames.get(hi) + "." + this.tnames.get(tid);
                                this.tnames.add(tname);
                                ++done;
                                ++j;
                            }
                            tflowTP = null;
                            tflowPT = null;
                            todropt.add(tid);
                        }
                    }
                    ++i;
                }
            }
        }
        if (done > 0) {
            System.out.println("Partial Post-agglomeration rule applied " + done + " times.");
            this.dropTransitions(todropt, "Partial Post agglomeration");
        }
        return done;
    }

    public int rulePartialFreeAgglo() {
        IntMatrixCol tflowTP = null;
        IntMatrixCol tflowPT = null;
        int done = 0;
        HashSet<Integer> toreduce = new HashSet<Integer>();
        int tid = 0;
        int te = this.tnames.size();
        while (tid < te) {
            SparseIntArray tp = this.flowTP.getColumn(tid);
            if (tp.size() == 1) {
                int pid = tp.keyAt(0);
                if (tp.valueAt(0) == 1 && this.marks.get(pid) == 0 && !this.untouchable.get(pid) && !this.touches(tid)) {
                    toreduce.add(pid);
                }
            }
            ++tid;
        }
        ArrayList<Integer> todropt = new ArrayList<Integer>();
        if (!toreduce.isEmpty()) {
            Iterator iterator = toreduce.iterator();
            while (iterator.hasNext()) {
                SparseIntArray ttp;
                SparseIntArray tpt;
                int pid = (Integer)iterator.next();
                if (tflowTP == null) {
                    tflowTP = this.flowTP.transpose();
                }
                if (tflowPT == null) {
                    tflowPT = this.flowPT.transpose();
                }
                if ((tpt = tflowPT.getColumn(pid)).size() > 1 || SparseIntArray.keysIntersect(tpt, ttp = tflowTP.getColumn(pid))) continue;
                boolean ok = true;
                int i = 0;
                int ie = tpt.size();
                while (i < ie) {
                    if (tpt.valueAt(i) > 1) {
                        ok = false;
                    }
                    ++i;
                }
                if (!ok) continue;
                i = 0;
                ie = ttp.size();
                while (i < ie) {
                    int tid2 = ttp.keyAt(i);
                    if (!this.touches(tid2)) {
                        int curt = this.tnames.size();
                        if (this.flowTP.getColumn(tid2).size() == 1 && this.flowTP.getColumn(tid2).valueAt(0) == 1) {
                            int j = 0;
                            int je = tpt.size();
                            while (j < je) {
                                int fi = tpt.keyAt(j);
                                SparseIntArray resPT = SparseIntArray.sumProd(1, this.flowPT.getColumn(tid2), 1, this.flowPT.getColumn(fi), pid);
                                this.flowPT.appendColumn(resPT);
                                SparseIntArray resTP = SparseIntArray.sumProd(1, this.flowTP.getColumn(tid2), 1, this.flowTP.getColumn(fi), pid);
                                this.flowTP.appendColumn(resTP);
                                String tname = this.tnames.get(tid2) + "." + this.tnames.get(fi);
                                this.tnames.add(tname);
                                ++done;
                                ++j;
                            }
                            todropt.add(tid2);
                        }
                    }
                    ++i;
                }
            }
        }
        if (done > 0) {
            System.out.println("Partial Free-agglomeration rule applied " + done + " times.");
            this.dropTransitions(todropt, "Partial Free agglomeration");
        }
        return done;
    }

    public int ruleFreeAgglo(boolean doComplex) {
        IntMatrixCol tflowTP = null;
        int done = 0;
        int red = 0;
        int pid = 0;
        while (pid < this.pnames.size()) {
            if (!this.untouchable.get(pid) && this.marks.get(pid) <= 0) {
                SparseIntArray toP;
                if (tflowTP == null) {
                    tflowTP = this.flowTP.transpose();
                }
                if ((toP = tflowTP.getColumn(pid)).size() == 1 && toP.valueAt(0) == 1 || doComplex) {
                    boolean ok = true;
                    ArrayList<Integer> Hids = new ArrayList<Integer>();
                    int i = 0;
                    while (i < toP.size()) {
                        int tid = toP.keyAt(i);
                        if (toP.valueAt(i) != 1) {
                            ok = false;
                            break;
                        }
                        if (this.flowTP.getColumn(tid).size() > 1) {
                            ok = false;
                            break;
                        }
                        if (!doComplex && this.flowPT.getColumn(tid).size() > 1) {
                            ok = false;
                            break;
                        }
                        if (this.touches(tid)) {
                            ok = false;
                            break;
                        }
                        if (this.flowPT.getColumn(tid).get(pid) > 0) {
                            ok = false;
                            break;
                        }
                        Hids.add(tid);
                        ++i;
                    }
                    if (ok) {
                        ArrayList<Integer> Fids = new ArrayList<Integer>();
                        int ttid = 0;
                        while (ttid < this.tnames.size()) {
                            int val = this.flowPT.getColumn(ttid).get(pid);
                            if (val == 1) {
                                if (this.flowTP.getColumn(ttid).get(pid) > 0) {
                                    ok = false;
                                    break;
                                }
                                Fids.add(ttid);
                            } else if (val > 1) {
                                ok = false;
                                break;
                            }
                            ++ttid;
                        }
                        if (ok) {
                            red += this.agglomerateAround(pid, Hids, Fids, "Free", null, tflowTP);
                            ++done;
                        }
                    }
                }
            }
            ++pid;
        }
        if (done > 0) {
            System.out.println("Free-agglomeration rule " + (doComplex ? "(complex) " : " ") + "applied " + done + " times" + (String)(red > 0 ? " with reduction of " + red + " identical transitions." : "."));
        }
        return done;
    }

    public int ruleReduceTrans(ReductionType rt) throws NoDeadlockExists {
        int reduced = 0;
        if (rt == ReductionType.REACHABILITY || rt == ReductionType.STATESPACE) {
            ArrayList<Integer> todrop = new ArrayList<Integer>();
            int i = this.tnames.size() - 1;
            while (i >= 0) {
                if ((rt == ReductionType.REACHABILITY || rt == ReductionType.STATESPACE) && this.flowPT.getColumn(i).equals(this.flowTP.getColumn(i))) {
                    todrop.add(i);
                } else if (rt == ReductionType.REACHABILITY && this.flowTP.getColumn(i).size() == 0 && !this.touches(i)) {
                    todrop.add(i);
                }
                --i;
            }
            if (!todrop.isEmpty()) {
                reduced += todrop.size();
                this.dropTransitions(todrop, "Empty/Sink Transition effects.");
            }
        }
        if ((reduced += this.ensureUnique(this.flowPT, this.flowTP, this.tnames, null, true)) > 0) {
            System.out.println("Reduce isomorphic transitions removed " + reduced + " transitions.");
        }
        if (rt == ReductionType.DEADLOCK) {
            int i = 0;
            while (i < this.flowPT.getColumnCount()) {
                if (this.flowPT.getColumn(i).size() == 0) {
                    System.out.println("Found a source transition so no deadlocks exist. place count " + this.pnames.size() + " transition count " + this.tnames.size());
                    throw new NoDeadlockExists();
                }
                ++i;
            }
        }
        if (this.maxArcValue > 1 && rt != ReductionType.LIVENESS) {
            IntMatrixCol tflowPT = this.flowPT.transpose();
            int modred = 0;
            TreeSet<Integer> todel = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
            int pid = 0;
            while (pid < this.pnames.size()) {
                SparseIntArray line = tflowPT.getColumn(pid);
                int i = 0;
                while (i < line.size()) {
                    if (line.valueAt(i) > 1) {
                        modred += this.testModuloIsomorphism(line, todel);
                        break;
                    }
                    ++i;
                }
                ++pid;
            }
            if (modred > 0) {
                Iterator iterator = todel.iterator();
                while (iterator.hasNext()) {
                    int td = (Integer)iterator.next();
                    this.tnames.remove(td);
                    this.flowPT.deleteColumn(td);
                    this.flowTP.deleteColumn(td);
                }
                System.out.println("Reduce isomorphic (modulo) transitions removed " + modred + " transitions.");
                reduced += modred;
                this.maxArcValue = this.flowPT.findMax();
                this.maxArcValue = Math.max(this.flowTP.findMax(), this.maxArcValue);
            }
        }
        return reduced;
    }

    private int testModuloIsomorphism(SparseIntArray line, Set<Integer> todel) {
        int total = 0;
        int i = 0;
        while (i < line.size()) {
            int ti = line.keyAt(i);
            int vi = line.valueAt(i);
            SparseIntArray coli = this.flowPT.getColumn(ti);
            int j = i + 1;
            while (j < line.size()) {
                int tj = line.keyAt(j);
                int vj = line.valueAt(j);
                if (vi != vj) {
                    if (vi > vj) {
                        int tmp = tj;
                        tj = ti;
                        ti = tmp;
                        tmp = vi;
                        vi = vj;
                        vj = tmp;
                    }
                    if (vj % vi == 0) {
                        int factor = vj / vi;
                        SparseIntArray colj = this.flowPT.getColumn(tj);
                        if (coli.size() == colj.size() && this.flowTP.getColumn(ti).size() == this.flowTP.getColumn(tj).size()) {
                            boolean ok = this.compareModuloFactor(coli, colj, factor);
                            if (ok) {
                                ok = this.compareModuloFactor(this.flowTP.getColumn(ti), this.flowTP.getColumn(tj), factor);
                            }
                            if (ok) {
                                ++total;
                                todel.add(tj);
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return total;
    }

    public boolean compareModuloFactor(SparseIntArray coli, SparseIntArray colj, int factor) {
        boolean ok = true;
        int ii = 0;
        while (ii < coli.size()) {
            if (coli.keyAt(ii) != colj.keyAt(ii)) {
                ok = false;
                break;
            }
            int vvi = coli.valueAt(ii);
            int vvj = colj.valueAt(ii);
            if (vvj % vvi != 0 || vvj / vvi != factor) {
                ok = false;
                break;
            }
            ++ii;
        }
        return ok;
    }

    private int ensureUnique(IntMatrixCol mPT, IntMatrixCol mTP, List<String> names, List<Integer> init, boolean trace) {
        SparseIntArray tcolTP;
        SparseIntArray tcolPT;
        HashMap<SparseIntArray, Map> seen = new HashMap<SparseIntArray, Map>();
        ArrayList<Integer> todel = new ArrayList<Integer>();
        if (init != null) {
            int i = this.untouchable.nextSetBit(0);
            while (i >= 0) {
                tcolPT = mPT.getColumn(i);
                tcolTP = mTP.getColumn(i);
                seen.computeIfAbsent(tcolPT, k -> new HashMap()).put(tcolTP, i);
                i = this.untouchable.nextSetBit(i + 1);
            }
        }
        if (init == null) {
            trid = mPT.getColumnCount() - 1;
            while (trid >= 0) {
                tcolPT = mPT.getColumn(trid);
                tcolTP = mTP.getColumn(trid);
                Integer b2 = seen.computeIfAbsent(tcolPT, k -> new HashMap()).put(tcolTP, trid);
                if (b2 != null) {
                    todel.add(trid);
                }
                --trid;
            }
        } else {
            trid = mPT.getColumnCount() - 1;
            while (trid >= 0) {
                if (!this.untouchable.get(trid)) {
                    tcolPT = mPT.getColumn(trid);
                    tcolTP = mTP.getColumn(trid);
                    Map map = seen.computeIfAbsent(tcolPT, k -> new HashMap());
                    Integer pb = (Integer)map.get(tcolTP);
                    if (pb != null) {
                        if (init.get(trid) >= init.get(pb)) {
                            todel.add(trid);
                        } else if (!this.untouchable.get(pb)) {
                            todel.add(pb);
                            map.put(tcolTP, init.get(pb));
                        }
                    } else {
                        map.put(tcolTP, trid);
                    }
                }
                --trid;
            }
            todel.sort((a, b) -> -a.compareTo((Integer)b));
        }
        ArrayList<String> rem = new ArrayList<String>();
        Iterator iterator = todel.iterator();
        while (iterator.hasNext()) {
            int td = (Integer)iterator.next();
            rem.add(names.remove(td));
            mPT.deleteColumn(td);
            mTP.deleteColumn(td);
            if (init == null) continue;
            init.remove(td);
            this.image.remove(td);
            this.removeAt(td, this.untouchable);
            this.removeAt(td, this.tokeepImages);
        }
        if (trace && !todel.isEmpty()) {
            System.out.println("Ensure Unique test removed " + rem.size() + (init != null ? " places" : " transitions") + "");
        }
        return todel.size();
    }

    private int ruleReducePlaces(ReductionType rt, boolean withSyphon, boolean moveTokens) throws DeadlockFound {
        int totalp = 0;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        TreeSet<Integer> todelTrans = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
        Object sr2 = null;
        Object cstP = null;
        boolean withPreFire = false;
        if (rt != ReductionType.LTL && !this.keepImage && moveTokens && rt != ReductionType.LIVENESS) {
            SparseIntArray to;
            SparseIntArray from;
            int pid;
            if ((rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL) && this.marks.stream().mapToInt(i -> i).sum() == 1) {
                pid = this.marks.indexOf(1);
                from = tflowPT.getColumn(pid);
                to = tflowTP.getColumn(pid);
                if (to.size() == 0 && this.marks.get(pid) != 0 && from.size() == 1 && this.flowPT.getColumn(from.keyAt(0)).size() == 1 && !this.touches(Collections.singletonList(from.keyAt(0)))) {
                    this.emptyPlaceWithTransition(pid, from.keyAt(0));
                    withPreFire = true;
                }
            }
            pid = this.pnames.size() - 1;
            while (pid >= 0) {
                if (!this.untouchable.get(pid)) {
                    from = tflowPT.getColumn(pid);
                    to = tflowTP.getColumn(pid);
                    if (to.size() == 0 && this.marks.get(pid) != 0 && from.size() == 1 && this.flowPT.getColumn(from.keyAt(0)).size() == 1 && !this.touches(Collections.singletonList(from.keyAt(0)))) {
                        int val = from.valueAt(0);
                        int mark = this.marks.get(pid);
                        if (mark % val != 0) {
                            this.marks.set(pid, mark / val * val);
                        }
                        this.emptyPlaceWithTransition(pid, from.keyAt(0));
                        withPreFire = true;
                    }
                }
                --pid;
            }
        }
        ArrayList<String> prem = new ArrayList<String>();
        ArrayList<String> trem = new ArrayList<String>();
        Set<Integer> syphon = withSyphon ? SiphonComputer.computeEmptySyphon(this.flowPT, this.flowTP, this.marks) : Collections.emptySet();
        int pid = this.pnames.size() - 1;
        while (pid >= 0) {
            SparseIntArray to;
            SparseIntArray from = tflowPT.getColumn(pid);
            if (!(!this.isConstantPlace(pid, from, to = tflowTP.getColumn(pid), syphon) || this.keepImage && this.tokeepImages.get(pid))) {
                int m = this.marks.get(pid);
                int tpos = 0;
                while (tpos < from.size()) {
                    int taken = from.valueAt(tpos);
                    if (taken > m) {
                        todelTrans.add(from.keyAt(tpos));
                        if (rt == ReductionType.LIVENESS) {
                            throw new DeadlockFound();
                        }
                    }
                    ++tpos;
                }
                if (m > 0 && rt == ReductionType.STATESPACE || this.untouchable.get(pid)) {
                    from.clear();
                    to.clear();
                } else {
                    prem.add(this.dropPlace(pid, tflowPT, tflowTP));
                    ++totalp;
                }
            } else if (from.size() == 0 && rt != ReductionType.STATESPACE && !this.untouchable.get(pid)) {
                prem.add(this.dropPlace(pid, tflowPT, tflowTP));
                ++totalp;
            }
            --pid;
        }
        if (totalp > 0) {
            tflowPT.transposeTo(this.flowPT);
            tflowTP.transposeTo(this.flowTP);
        }
        int deltap = 0;
        if (rt != ReductionType.STATESPACE) {
            deltap = this.ensureUnique(tflowPT, tflowTP, this.pnames, this.marks, true);
        }
        totalp += deltap;
        if (deltap > 0) {
            tflowPT.transposeTo(this.flowPT);
            tflowTP.transposeTo(this.flowTP);
        }
        HashSet<Integer> toloop = new HashSet<Integer>();
        HashSet moredel = new HashSet();
        int pid2 = 0;
        int e = tflowPT.getColumnCount();
        while (rt == ReductionType.REACHABILITY && pid2 < e) {
            if (this.marks.get(pid2) <= 0 && !this.untouchable.get(pid2) && tflowTP.getColumn(pid2).size() == 1) {
                int feeder = tflowTP.getColumn(pid2).keyAt(0);
                SparseIntArray oriPT = this.flowPT.getColumn(feeder);
                SparseIntArray oriTP = this.flowTP.getColumn(feeder);
                SparseIntArray eaters = tflowPT.getColumn(pid2);
                int i2 = 0;
                int ee = eaters.size();
                while (i2 < ee) {
                    int totry = eaters.keyAt(i2);
                    SparseIntArray ttPT = this.flowPT.getColumn(totry);
                    SparseIntArray ttTP = this.flowTP.getColumn(totry);
                    if (oriPT.equals(ttTP) && oriTP.equals(ttPT)) {
                        try {
                            String tname = this.tnames.get(totry);
                            IntMatrixCol graph = StructuralReduction.buildGraph((ISparsePetriNet)this, rt, totry);
                            Set<Integer> safeNodes = StructuralReduction.computeSafeNodes(this, rt, graph, this.untouchable);
                            if (safeNodes.size() < this.pnames.size()) {
                                StructuralReduction.collectPrefix(safeNodes, graph, true);
                            }
                            boolean doit = true;
                            int j = 0;
                            int end = oriTP.size();
                            while (j < end) {
                                if (safeNodes.contains(oriTP.keyAt(j))) {
                                    doit = false;
                                    break;
                                }
                                ++j;
                            }
                            if (doit) {
                                int dropped = this.dropIrrelevant(safeNodes);
                                System.out.println("Remove reverse transitions (loop back) rule discarded transition " + tname + " and " + dropped + " places that fell out of Prefix Of Interest.");
                                return 1;
                            }
                        }
                        catch (DeadlockFound e1) {
                            e1.printStackTrace();
                        }
                        if (rt != ReductionType.DEADLOCK) break;
                        toloop.add(feeder);
                        break;
                    }
                    ++i2;
                }
            }
            ++pid2;
        }
        if (!moredel.isEmpty()) {
            System.out.println("Remove reverse transitions rule discarded transitions " + String.valueOf(moredel.stream().map(t -> this.tnames.get((int)t)).collect(Collectors.toList())));
            todelTrans.addAll(moredel);
        }
        if (!toloop.isEmpty()) {
            Iterator iterator = toloop.iterator();
            while (iterator.hasNext()) {
                int feeder = (Integer)iterator.next();
                this.flowPT.appendColumn(this.flowPT.getColumn(feeder).clone());
                this.flowTP.appendColumn(this.flowPT.getColumn(feeder).clone());
                this.tnames.add(this.tnames.get(feeder) + "rev");
            }
        }
        if (!todelTrans.isEmpty()) {
            Iterator iterator = todelTrans.iterator();
            while (iterator.hasNext()) {
                int tid = (Integer)iterator.next();
                this.flowPT.deleteColumn(tid);
                this.flowTP.deleteColumn(tid);
                trem.add(this.tnames.remove(tid));
            }
        }
        if (!prem.isEmpty() || !trem.isEmpty()) {
            System.out.println("Reduce places removed " + totalp + " places and " + todelTrans.size() + " transitions. " + "");
        }
        return totalp;
    }

    public List<Integer> computeConstants() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        Set<Integer> syphon = SiphonComputer.computeEmptySyphon(this.flowPT, this.flowTP, this.marks);
        int pid = this.pnames.size() - 1;
        while (pid >= 0) {
            SparseIntArray to;
            SparseIntArray from = tflowPT.getColumn(pid);
            if (this.isConstantPlace(pid, from, to = tflowTP.getColumn(pid), syphon)) {
                list.add(pid);
            }
            --pid;
        }
        return list;
    }

    public boolean isConstantPlace(int pid, SparseIntArray from, SparseIntArray to, Set<Integer> syphon) {
        return syphon.contains(pid) || from.equals(to) || to.size() == 0 && this.marks.get(pid) == 0 || this.hasNoTrueInputs(pid, from, to);
    }

    public boolean hasNoTrueInputs(int pid, SparseIntArray from, SparseIntArray to) {
        boolean noTrueInputs = false;
        if (this.marks.get(pid) == 0) {
            noTrueInputs = true;
            int i = 0;
            while (i < to.size()) {
                if (to.valueAt(i) > from.get(to.keyAt(i))) {
                    noTrueInputs = false;
                    break;
                }
                ++i;
            }
        }
        return noTrueInputs;
    }

    private String dropPlace(int pid, IntMatrixCol tflowPT, IntMatrixCol tflowTP) {
        tflowPT.deleteColumn(pid);
        tflowTP.deleteColumn(pid);
        String ret = this.pnames.remove(pid);
        this.removeAt(pid, this.untouchable);
        this.marks.remove(pid);
        if (this.keepImage) {
            this.image.remove(pid);
            this.removeAt(pid, this.tokeepImages);
        }
        return ret;
    }

    private int ruleImplicitPlace() {
        int totalp = 0;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        ArrayList deleted = new ArrayList();
        HashSet<Integer> todel = new HashSet<Integer>();
        int pid = this.pnames.size() - 1;
        while (pid >= 0) {
            SparseIntArray to;
            if (!this.untouchable.get(pid) && (to = tflowTP.getColumn(pid)).size() == 1 && to.valueAt(0) == 1) {
                int tfeedP = to.keyAt(0);
                SparseIntArray from = tflowPT.getColumn(pid);
                if (from.size() == 1 && from.valueAt(0) == 1) {
                    int teatP = from.keyAt(0);
                    if (this.flowTP.getColumn(tfeedP).size() == 2 && this.flowPT.getColumn(teatP).size() == 2) {
                        BitSet seen;
                        int other = -1;
                        SparseIntArray eatPT = this.flowPT.getColumn(teatP);
                        int i = 0;
                        while (i < eatPT.size()) {
                            int k = eatPT.keyAt(i);
                            if (k != pid) {
                                if (eatPT.valueAt(i) != 1) break;
                                other = k;
                                break;
                            }
                            ++i;
                        }
                        if (other != -1 && !todel.contains(other) && this.inducedBy(other, tfeedP, tflowPT, tflowTP, seen = new BitSet(), 5)) {
                            todel.add(pid);
                            ++totalp;
                        }
                    }
                }
            }
            --pid;
        }
        if (totalp > 0) {
            this.dropPlaces(new ArrayList<Integer>(todel), false, "Implicit places test (without SMT)");
            System.out.println("Implicit places reduction removed " + totalp + " places " + "");
        }
        return totalp;
    }

    public void dropTransitions(List<Integer> todrop, String rule) {
        this.dropTransitions(todrop, true, rule);
    }

    public void dropTransitions(List<Integer> todrop, boolean trace, String rule) {
        ArrayList<String> deleted = new ArrayList<String>();
        todrop.sort((a, b) -> -a.compareTo((Integer)b));
        for (int tid : todrop) {
            this.flowPT.deleteColumn(tid);
            this.flowTP.deleteColumn(tid);
            deleted.add(this.tnames.remove(tid));
        }
        int totalp = deleted.size();
        if (totalp > 0 && trace) {
            System.out.println("Drop transitions (" + rule + ") removed " + totalp + " transitions " + "");
        }
    }

    public void dropPlaces(List<Integer> todrop, boolean andOutputs, String rule) {
        this.dropPlaces(todrop, andOutputs, true, rule);
    }

    public void dropPlaces(List<Integer> todrop, boolean andOutputs, boolean trace, String rule) {
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        ArrayList<String> deleted = new ArrayList<String>();
        HashSet<Integer> toremT = new HashSet<Integer>();
        todrop.sort(Integer::compare);
        int i = todrop.size() - 1;
        while (i >= 0) {
            int pid = todrop.get(i);
            if (andOutputs) {
                SparseIntArray outs = tflowPT.getColumn(pid);
                int j = 0;
                while (j < outs.size()) {
                    toremT.add(outs.keyAt(j));
                    ++j;
                }
            }
            deleted.add(this.dropPlace(pid, tflowPT, tflowTP));
            --i;
        }
        tflowPT.transposeTo(this.flowPT);
        tflowTP.transposeTo(this.flowTP);
        int totalp = deleted.size();
        if (totalp > 0 && trace) {
            System.out.println("Discarding " + totalp + " places :" + "");
        }
        if (andOutputs) {
            ArrayList<Integer> kt = new ArrayList<Integer>(toremT);
            kt.removeIf(tid -> this.flowPT.getColumn((int)tid).size() != 0 || this.flowPT.getColumn((int)tid).size() != 0);
            if (trace) {
                System.out.println("Also discarding " + kt.size() + " output transitions " + "");
            }
            this.dropTransitions(kt, "Output transitions of discarded places.");
        }
    }

    private void removeAt(int pid, BitSet bs) {
        bs.clear(pid);
        int i = bs.nextSetBit(pid);
        while (i >= 0) {
            bs.set(i - 1);
            bs.clear(i);
            if (i == Integer.MAX_VALUE) break;
            i = bs.nextSetBit(i + 1);
        }
    }

    private boolean inducedBy(int pid, int tcause, IntMatrixCol tflowPT, IntMatrixCol tflowTP, BitSet seen, int depth) {
        if (depth == 0 || this.marks.get(pid) != 0 || seen.get(pid)) {
            return false;
        }
        BitSet newseen = (BitSet)seen.clone();
        newseen.set(pid);
        SparseIntArray to = tflowTP.getColumn(pid);
        if (to.size() != 1 || to.valueAt(0) != 1) {
            return false;
        }
        int tfeedP = to.keyAt(0);
        if (tfeedP == tcause) {
            return true;
        }
        SparseIntArray inputFeed = this.flowPT.getColumn(tfeedP);
        int i = 0;
        while (i < inputFeed.size()) {
            int predid = inputFeed.keyAt(i);
            if (inputFeed.valueAt(i) == 1 && this.inducedBy(predid, tcause, tflowPT, tflowTP, newseen, depth - 1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int ruleTrivialPostAgglo(ReductionType rt) {
        if (rt == ReductionType.LTL || this.keepImage) {
            return 0;
        }
        int total = 0;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        int initt = this.tnames.size();
        long time = System.currentTimeMillis();
        ArrayList<Integer> todel = new ArrayList<Integer>();
        int pid = 0;
        while (pid < this.pnames.size()) {
            if (!this.untouchable.get(pid)) {
                SparseIntArray fcand = tflowPT.getColumn(pid);
                SparseIntArray hcand = tflowTP.getColumn(pid);
                if (fcand.size() != 0 && hcand.size() != 0 && fcand.size() <= 1 && hcand.size() <= 1 && this.flowTP.getColumn(hcand.keyAt(0)).size() <= 1) {
                    boolean isMarked;
                    boolean bl = isMarked = this.marks.get(pid) != 0;
                    if (!isMarked && fcand.valueAt(0) == 1 && hcand.valueAt(0) == 1) {
                        ArrayList<Integer> Hids = new ArrayList<Integer>();
                        ArrayList<Integer> Fids = new ArrayList<Integer>();
                        int fid = fcand.keyAt(0);
                        SparseIntArray fPT = this.flowPT.getColumn(fid);
                        if (fPT.size() <= 1) {
                            Fids.add(fid);
                            int hid = hcand.keyAt(0);
                            if (hid != fid) {
                                Hids.add(hid);
                                if (!this.touches(Hids) && !this.touches(Fids)) {
                                    SparseIntArray fTP = this.flowTP.getColumn(fid);
                                    this.flowTP.setColumn(hid, fTP);
                                    this.flowPT.setColumn(fid, new SparseIntArray());
                                    this.flowTP.setColumn(fid, new SparseIntArray());
                                    todel.add(fid);
                                    this.tnames.set(hid, this.tnames.get(hid) + "." + this.tnames.get(fid));
                                    int j = 0;
                                    int je = fTP.size();
                                    while (j < je) {
                                        int pfed = fTP.keyAt(j);
                                        int val = tflowTP.getColumn(pfed).get(fid);
                                        tflowTP.getColumn(pfed).put(fid, 0);
                                        tflowTP.getColumn(pfed).put(hid, val);
                                        ++j;
                                    }
                                    ++total;
                                    long deltat = System.currentTimeMillis() - time;
                                    if (deltat >= 30000L) {
                                        System.out.println("Performed " + total + " Post agglomeration using trivial condition.");
                                        time = System.currentTimeMillis();
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++pid;
        }
        if (!todel.isEmpty()) {
            this.dropTransitions(todel, "Trivial Post-Agglo cleanup.");
            System.out.println("Trivial Post-agglo rules discarded " + todel.size() + " transitions");
        }
        if (total != 0) {
            System.out.println("Performed " + total + " trivial Post agglomeration. Transition count delta: " + (initt - this.tnames.size()));
        }
        return total;
    }

    /*
     * Unable to fully structure code
     */
    private int rulePostAgglo(boolean doComplex, boolean doSimple, ReductionType rt) {
        if (rt == ReductionType.LTL) {
            return 0;
        }
        total = 0;
        red = 0;
        tflowPT = this.flowPT.transpose();
        tflowTP = this.flowTP.transpose();
        initt = this.tnames.size();
        time = System.currentTimeMillis();
        pid = 0;
        while (pid < this.pnames.size()) {
            block30: {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    if (this.untouchable.get(pid)) break block30;
                                    fcand = tflowPT.getColumn(pid);
                                    hcand = tflowTP.getColumn(pid);
                                    if (fcand.size() == 0 || hcand.size() == 0 || doSimple && (fcand.size() > 1 || hcand.size() > 1) || doSimple && this.flowTP.getColumn(hcand.keyAt(0)).size() > 1 || !doComplex && fcand.size() > 1 && hcand.size() > 1) break block30;
                                    v0 = isMarked = this.marks.get(pid) != 0;
                                    if (isMarked && fcand.size() > 1 || isMarked && !doComplex) break block30;
                                    seenFrom = new ArrayList<Integer>();
                                    seenTo = new ArrayList<Integer>();
                                    checkWeights = false;
                                    Hids = new ArrayList<Integer>();
                                    Fids = new ArrayList<Integer>();
                                    ok = true;
                                    testSet = new HashSet<E>();
                                    fi = 0;
                                    while (fi < fcand.size()) {
                                        fid = fcand.keyAt(fi);
                                        fPT = this.flowPT.getColumn(fid);
                                        if (fPT.size() > 1) {
                                            ok = false;
                                            break;
                                        }
                                        val = fcand.valueAt(fi);
                                        if (val > 1) {
                                            checkWeights = true;
                                        }
                                        if (this.marks.get(pid) % val != 0) {
                                            ok = false;
                                            break;
                                        }
                                        seenFrom.add(val);
                                        Fids.add(fid);
                                        ++fi;
                                    }
                                    if (!ok || rt == ReductionType.SI_CTL && Fids.size() > 1) break block30;
                                    hi = 0;
                                    while (hi < hcand.size()) {
                                        hid = hcand.keyAt(hi);
                                        hPT = this.flowPT.getColumn(hid);
                                        if (hPT.get(pid) != 0) {
                                            ok = false;
                                            break;
                                        }
                                        if (!testSet.isEmpty()) {
                                            i = 0;
                                            e = hPT.size();
                                            while (i < e) {
                                                if (testSet.contains(hPT.keyAt(i))) {
                                                    ok = false;
                                                    break;
                                                }
                                                ++i;
                                            }
                                            if (ok) {
                                                hTP = this.flowTP.getColumn(hid);
                                                i = 0;
                                                e = hTP.size();
                                                while (i < e) {
                                                    if (testSet.contains(hTP.keyAt(i))) {
                                                        ok = false;
                                                        break;
                                                    }
                                                    ++i;
                                                }
                                            }
                                        }
                                        if (!ok) break;
                                        val = hcand.valueAt(hi);
                                        if (val > 1) {
                                            checkWeights = true;
                                        }
                                        seenTo.add(val);
                                        Hids.add(hid);
                                        ++hi;
                                    }
                                    if (!ok) break block30;
                                    if (checkWeights) {
                                        hid = seenTo.iterator();
                                        while (hid.hasNext()) {
                                            feeder = (Integer)hid.next();
                                            val = seenFrom.iterator();
                                            while (val.hasNext()) {
                                                cons = (Integer)val.next();
                                                if (feeder % cons != 0 || cons > feeder) {
                                                    ok = false;
                                                    break;
                                                }
                                                if (feeder <= cons || seenFrom.size() <= 1) continue;
                                                ok = false;
                                                break;
                                            }
                                            if (!ok) break;
                                        }
                                    }
                                    if (!ok || Hids.size() != 1 && Fids.size() != 1 && Hids.size() * Fids.size() >= 32) break block30;
                                    if (this.untouchable.isEmpty()) break block31;
                                    ok = this.checkProtection(Hids, Fids);
                                    if (ok) {
                                        if (isMarked) {
                                            fid = fcand.keyAt(0);
                                            tp = this.flowTP.getColumn(fid);
                                            i = 0;
                                            e = tp.size();
                                            while (i < e) {
                                                if (this.untouchable.get(tp.keyAt(i))) {
                                                    ok = false;
                                                    ** break;
                                                }
                                                ++i;
                                            }
                                        } else {
                                            ** GOTO lbl112
                                        }
                                    }
                                    break block30;
                                }
                                if (!ok) break block30;
                                if (rt != ReductionType.REACHABILITY || this.untouchable.isEmpty() || !this.touches(Fids)) break block32;
                                var23_26 = Hids.iterator();
                                while (var23_26.hasNext()) {
                                    h = (Integer)var23_26.next();
                                    if (SparseIntArray.sumProd(1, this.flowPT.getColumn(h), -1, this.flowTP.getColumn(h)).size() <= 1) continue;
                                    ok = false;
                                    break;
                                }
                                if (ok) break block33;
                                break block30;
                            }
                            if ((rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL) && this.touches(Fids)) break block30;
                        }
                        if (!isMarked || this.keepImage) break block34;
                        fid = fcand.keyAt(0);
                        this.emptyPlaceWithTransition(pid, fid);
                        break block35;
                    }
                    if (isMarked) break block30;
                }
                red += this.agglomerateAround(pid, Hids, Fids, "Post", tflowPT, tflowTP);
                if (doComplex && ++total > 100) break;
                deltat = System.currentTimeMillis() - time;
                if (deltat >= 30000L) {
                    System.out.println("Performed " + total + " Post agglomeration using F-continuation condition.");
                    time = System.currentTimeMillis();
                }
            }
            ++pid;
        }
        if (total != 0) {
            System.out.println("Performed " + total + " Post agglomeration using F-continuation condition" + (red > 0 ? " with reduction of " + red + " identical transitions." : ".Transition count delta: " + (initt - this.tnames.size())));
        }
        return total;
    }

    private boolean checkProtection(List<Integer> Hids, List<Integer> Fids) {
        return !this.touches(Hids) || !this.touches(Fids);
    }

    private boolean touches(SparseIntArray hcand) {
        if (this.untouchable.isEmpty()) {
            return false;
        }
        int i = 0;
        int e = hcand.size();
        while (i < e) {
            int h = hcand.keyAt(i);
            if (this.touches(h)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean touches(List<Integer> Hids) {
        if (this.untouchable.isEmpty()) {
            return false;
        }
        for (int h : Hids) {
            if (!this.touches(h)) continue;
            return true;
        }
        return false;
    }

    private static boolean touches(int h, ISparsePetriNet pn, BitSet untouchable) {
        SparseIntArray col = pn.getFlowPT().getColumn(h);
        int i = 0;
        while (i < col.size()) {
            if (untouchable.get(col.keyAt(i)) && col.valueAt(i) != pn.getFlowTP().getColumn(h).get(col.keyAt(i))) {
                return true;
            }
            ++i;
        }
        col = pn.getFlowTP().getColumn(h);
        i = 0;
        while (i < col.size()) {
            if (untouchable.get(col.keyAt(i)) && col.valueAt(i) != pn.getFlowPT().getColumn(h).get(col.keyAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean touches(int h) {
        return StructuralReduction.touches(h, this, this.untouchable);
    }

    private void emptyPlaceWithTransition(int pid, int fid) {
        SparseIntArray preF = this.flowPT.getColumn(fid);
        SparseIntArray postF = this.flowTP.getColumn(fid);
        while (this.marks.get(pid) > 0) {
            int v;
            int p;
            int ip = 0;
            while (ip < preF.size()) {
                p = preF.keyAt(ip);
                v = preF.valueAt(ip);
                this.marks.set(p, this.marks.get(p) - v);
                this.image.set(p, Expression.op(Op.MINUS, this.image.get(p), Expression.constant(v)));
                ++ip;
            }
            ip = 0;
            while (ip < postF.size()) {
                p = postF.keyAt(ip);
                v = postF.valueAt(ip);
                this.marks.set(p, this.marks.get(p) + v);
                this.image.set(p, Expression.op(Op.ADD, this.image.get(p), Expression.constant(v)));
                ++ip;
            }
        }
    }

    private int agglomerateAround(int pid, List<Integer> Hids, List<Integer> Fids, String type, IntMatrixCol tflowPT, IntMatrixCol tflowTP) {
        ArrayList<SparseIntArray> HsPT = new ArrayList<SparseIntArray>();
        ArrayList<SparseIntArray> HsTP = new ArrayList<SparseIntArray>();
        ArrayList<String> Hnames = new ArrayList<String>();
        for (int i : Hids) {
            HsPT.add(this.flowPT.getColumn(i));
            HsTP.add(this.flowTP.getColumn(i));
            Hnames.add(this.tnames.get(i));
        }
        ArrayList<SparseIntArray> FsPT = new ArrayList<SparseIntArray>();
        ArrayList<SparseIntArray> FsTP = new ArrayList<SparseIntArray>();
        ArrayList<String> Fnames = new ArrayList<String>();
        for (int i : Fids) {
            FsPT.add(this.flowPT.getColumn(i));
            FsTP.add(this.flowTP.getColumn(i));
            Fnames.add(this.tnames.get(i));
        }
        ArrayList<Integer> todel = new ArrayList<Integer>(Hids);
        if (!this.keepImage) {
            todel.addAll(Fids);
        } else {
            this.tokeepImages.set(pid);
        }
        todel.sort((x, y) -> -Integer.compare(x, y));
        if (tflowPT != null) {
            tflowPT.deleteRows(todel);
        }
        if (tflowTP != null) {
            tflowTP.deleteRows(todel);
        }
        Iterator iterator = todel.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.flowPT.deleteColumn(i);
            this.flowTP.deleteColumn(i);
            this.tnames.remove(i);
        }
        IntMatrixCol toaddmatPT = new IntMatrixCol(this.flowPT.getRowCount(), 0);
        IntMatrixCol toaddmatTP = new IntMatrixCol(this.flowPT.getRowCount(), 0);
        ArrayList<String> tnamesadd = new ArrayList<String>();
        int hi = 0;
        while (hi < Hids.size()) {
            int hiv = ((SparseIntArray)HsTP.get(hi)).get(pid);
            int fi = 0;
            while (fi < Fids.size()) {
                int fiv = ((SparseIntArray)FsPT.get(fi)).get(pid);
                int nbocc = hiv / fiv;
                SparseIntArray resPT = SparseIntArray.sumProd(1, (SparseIntArray)HsPT.get(hi), nbocc, (SparseIntArray)FsPT.get(fi), pid);
                toaddmatPT.appendColumn(resPT);
                SparseIntArray resTP = SparseIntArray.sumProd(1, ((SparseIntArray)HsTP.get(hi)).clone(), nbocc, (SparseIntArray)FsTP.get(fi), pid);
                toaddmatTP.appendColumn(resTP);
                String tname = (String)Hnames.get(hi) + "." + (String)Fnames.get(fi);
                tnamesadd.add(tname);
                ++fi;
            }
            ++hi;
        }
        int red = this.ensureUnique(toaddmatPT, toaddmatTP, tnamesadd, null, false);
        this.tnames.addAll(tnamesadd);
        int i = 0;
        while (i < toaddmatPT.getColumnCount()) {
            SparseIntArray row;
            int k;
            int tid = this.flowPT.getColumnCount();
            SparseIntArray col = toaddmatPT.getColumn(i);
            if (tflowPT != null) {
                k = 0;
                while (k < col.size()) {
                    int ppid = col.keyAt(k);
                    row = tflowPT.getColumn(ppid);
                    row.append(tid, col.valueAt(k));
                    ++k;
                }
                tflowPT.addRow();
            }
            this.flowPT.appendColumn(col);
            col = toaddmatTP.getColumn(i);
            if (tflowTP != null) {
                k = 0;
                while (k < col.size()) {
                    int ppid = col.keyAt(k);
                    row = tflowTP.getColumn(ppid);
                    row.append(tid, col.valueAt(k));
                    ++k;
                }
                tflowTP.addRow();
            }
            this.flowTP.appendColumn(col);
            ++i;
        }
        return red;
    }

    private int rulePreAgglo(boolean doComplex, ReductionType rt) {
        if (rt == ReductionType.LTL) {
            return 0;
        }
        int total = 0;
        int red = 0;
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        int pid = 0;
        while (pid < this.pnames.size()) {
            if (!this.untouchable.get(pid)) {
                ArrayList<Integer> Fids = new ArrayList<Integer>();
                ArrayList<Integer> Hids = new ArrayList<Integer>();
                if (this.marks.get(pid) == 0) {
                    HashSet<Integer> touching = new HashSet<Integer>();
                    SparseIntArray col = tflowPT.getColumn(pid);
                    int i = 0;
                    int e = col.size();
                    while (i < e) {
                        touching.add(col.keyAt(i));
                        ++i;
                    }
                    col = tflowTP.getColumn(pid);
                    i = 0;
                    e = col.size();
                    while (i < e) {
                        touching.add(col.keyAt(i));
                        ++i;
                    }
                    boolean ok = true;
                    Iterator iterator = touching.iterator();
                    while (iterator.hasNext()) {
                        int tid = (Integer)iterator.next();
                        int consumesFromP = this.flowPT.getColumn(tid).get(pid);
                        int feedsIntoP = this.flowTP.getColumn(tid).get(pid);
                        if (consumesFromP == 0 && feedsIntoP == 0) continue;
                        if (consumesFromP != 0 && feedsIntoP != 0) {
                            ok = false;
                            break;
                        }
                        if (consumesFromP > 1 || feedsIntoP > 1) {
                            ok = false;
                            break;
                        }
                        if (consumesFromP != 0) {
                            Fids.add(tid);
                            if (doComplex || Hids.size() <= 1 || Fids.size() <= 1) continue;
                            ok = false;
                            break;
                        }
                        Hids.add(tid);
                        if (!doComplex && Hids.size() > 1 && Fids.size() > 1) {
                            ok = false;
                            break;
                        }
                        if (this.flowTP.getColumn(tid).size() > 1) {
                            ok = false;
                            break;
                        }
                        if (!this.isDivergentFree(tid)) {
                            ok = false;
                            break;
                        }
                        if (this.isStronglyQuasiPersistent(tid, tflowPT, rt)) continue;
                        ok = false;
                        break;
                    }
                    if (!(!ok || Fids.isEmpty() || Hids.isEmpty() || !doComplex && Hids.size() > 1 && Fids.size() > 1 || Hids.stream().anyMatch(h -> Fids.contains(h)))) {
                        if (!this.untouchable.isEmpty()) {
                            boolean bl = ok = !this.touches(Hids);
                        }
                        if (ok && (!this.keepImage || Fids.size() < 4)) {
                            red += this.agglomerateAround(pid, Hids, Fids, "Pre", tflowPT, tflowTP);
                            ++total;
                        }
                    }
                }
            }
            ++pid;
        }
        if (total != 0) {
            System.out.println("Performed " + total + (doComplex ? "(complex)" : "") + " Pre agglomeration using Quasi-Persistent + Divergent Free condition." + (String)(red > 0 ? " with reduction of " + red + " identical transitions." : "."));
        }
        return total;
    }

    private static boolean equalUptoPerm(SparseIntArray sa, SparseIntArray sb, int indi, int indj) {
        if (sa.size() != sb.size()) {
            return false;
        }
        if (sa.size() == 0) {
            return true;
        }
        int seenA = -1;
        int seenB = -1;
        int j = 0;
        int i = 0;
        while (i < sa.size() && j < sb.size()) {
            int ka = sa.keyAt(i);
            int va = sa.valueAt(i);
            int kb = sb.keyAt(j);
            int vb = sb.valueAt(j);
            if (ka == kb) {
                if (ka == indi || ka == indj || va != vb) {
                    return false;
                }
                ++i;
                ++j;
                continue;
            }
            if (ka == indi && kb == indj) {
                if (va != vb) {
                    return false;
                }
                seenA = va;
                seenB = vb;
                ++i;
                ++j;
                continue;
            }
            if (ka < kb) {
                if (ka == indi) {
                    if (seenA == -1) {
                        seenA = va;
                    }
                    if (seenB != -1 && seenB != va) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
                continue;
            }
            if (kb >= ka) continue;
            if (kb == indj) {
                if (seenB == -1) {
                    seenB = vb;
                }
                if (seenA != -1 && seenA != vb) {
                    return false;
                }
            } else {
                return false;
            }
            ++j;
        }
        return seenA == seenB;
    }

    private int ruleFusePlaceByFuture(ReductionType rt) {
        if (rt == ReductionType.LIVENESS) {
            return 0;
        }
        IntMatrixCol tflowPT = this.flowPT.transpose();
        ArrayList<Integer> ints = new ArrayList<Integer>(tflowPT.getColumnCount());
        int i = 0;
        while (i < tflowPT.getColumnCount()) {
            if (!this.untouchable.get(i)) {
                ints.add(i);
            }
            ++i;
        }
        Map<Integer, List<Integer>> byNbOutputs = ints.stream().collect(Collectors.groupingBy(a -> tflowPT.getColumn((int)a).size()));
        HashMap<Integer, Integer> toFuse = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, List<Integer>> ent : byNbOutputs.entrySet()) {
            ent.getKey().intValue();
            List<Integer> list = ent.getValue();
            if (list.size() >= 10000) continue;
            int i2 = 0;
            while (i2 < list.size()) {
                int pi = list.get(i2);
                if (!this.untouchable.get(pi) && !toFuse.containsKey(pi)) {
                    SparseIntArray piouts = tflowPT.getColumn(pi);
                    boolean tokeepi = false;
                    if (this.keepImage) {
                        tokeepi = this.tokeepImages.get(pi);
                    }
                    int j = i2 + 1;
                    while (j < list.size()) {
                        int pj = list.get(j);
                        if (!(this.untouchable.get(pj) || rt == ReductionType.LIVENESS && (this.marks.get(pi) != 0 || this.marks.get(pj) != 0) || toFuse.containsKey(pj) || this.keepImage && tokeepi != this.tokeepImages.get(pj))) {
                            SparseIntArray pjouts = tflowPT.getColumn(pj);
                            int ti = 0;
                            BitSet matchedj = new BitSet();
                            while (ti < piouts.size()) {
                                int indti = piouts.keyAt(ti);
                                SparseIntArray tiin = this.flowPT.getColumn(indti);
                                SparseIntArray tiout = this.flowTP.getColumn(indti);
                                if (tiout.size() == 0 && rt == ReductionType.LIVENESS) break;
                                boolean foundmatch = false;
                                int tj = 0;
                                while (tj < pjouts.size()) {
                                    int indtj = pjouts.keyAt(tj);
                                    if (indti == indtj) break;
                                    if (!matchedj.get(tj)) {
                                        SparseIntArray tjin = this.flowPT.getColumn(indtj);
                                        SparseIntArray tjout = this.flowTP.getColumn(indtj);
                                        if ((rt == ReductionType.LIVENESS || StructuralReduction.equalUptoPerm(tiout, tjout, pi, pj)) && (rt != ReductionType.LIVENESS || tiout.equals(tjout)) && StructuralReduction.equalUptoPerm(tiin, tjin, pi, pj)) {
                                            foundmatch = true;
                                            matchedj.set(tj);
                                            break;
                                        }
                                    }
                                    ++tj;
                                }
                                if (!foundmatch) break;
                                ++ti;
                            }
                            if (ti == piouts.size()) {
                                toFuse.put(pj, pi);
                            }
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        }
        if (!toFuse.isEmpty()) {
            this.isSafe = false;
            ArrayList<Integer> todelp = new ArrayList<Integer>();
            TreeSet<Integer> todel = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
            IntMatrixCol tflowTP = this.flowTP.transpose();
            for (Map.Entry ent : toFuse.entrySet()) {
                int pj = (Integer)ent.getKey();
                int pi = (Integer)ent.getValue();
                SparseIntArray jin = tflowTP.getColumn(pj);
                int i3 = 0;
                while (i3 < jin.size()) {
                    int tid = jin.keyAt(i3);
                    SparseIntArray tjouts = this.flowTP.getColumn(tid);
                    int v = tjouts.get(pj);
                    tjouts.delete(pj);
                    tjouts.put(pi, tjouts.get(pi) + v);
                    ++i3;
                }
                this.marks.set(pi, this.marks.get(pi) + this.marks.get(pj));
                this.marks.set(pj, 0);
                this.image.set(pi, Expression.op(Op.ADD, this.image.get(pi), this.image.get(pj)));
                todelp.add(pj);
            }
            if (!todelp.isEmpty()) {
                Iterator iterator = todelp.iterator();
                while (iterator.hasNext()) {
                    int pid = (Integer)((Object)iterator.next());
                    SparseIntArray tpt = tflowPT.getColumn(pid);
                    int i4 = 0;
                    while (i4 < tpt.size()) {
                        todel.add(tpt.keyAt(i4));
                        ++i4;
                    }
                }
                this.dropPlaces(todelp, false, "Symmetric choice cleanup.");
            }
            if (!todel.isEmpty()) {
                this.dropTransitions(new ArrayList<Integer>(todel), false, "Symmetric choice");
            }
        }
        return toFuse.size();
    }

    private void addCol(Set<Integer> ts, SparseIntArray column) {
        int i = 0;
        int e = column.size();
        while (i < e) {
            ts.add(column.keyAt(i));
            ++i;
        }
    }

    private int ruleSymmetricChoice() {
        IntMatrixCol tflowPT = this.flowPT.transpose();
        TreeSet<Integer> todel = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
        int pid = 0;
        while (pid < this.pnames.size()) {
            SparseIntArray pout = tflowPT.getColumn(pid);
            int iti = 0;
            while (iti < pout.size()) {
                int tidi = pout.keyAt(iti);
                if (!todel.contains(tidi)) {
                    int itj = iti + 1;
                    while (itj < pout.size()) {
                        SparseIntArray intj;
                        SparseIntArray inti;
                        int tidj = pout.keyAt(itj);
                        if (!todel.contains(tidj) && (inti = this.flowPT.getColumn(tidi)).equals(intj = this.flowPT.getColumn(tidj))) {
                            SparseIntArray outi = this.flowTP.getColumn(tidi);
                            SparseIntArray outj = this.flowTP.getColumn(tidj);
                            if (outi.size() == outj.size()) {
                                int indpi = -1;
                                int indpj = -1;
                                int i = 0;
                                int j = 0;
                                while (i < outi.size() && j < outj.size()) {
                                    int pi = outi.keyAt(i);
                                    int vi = outi.valueAt(i);
                                    int pj = outj.keyAt(j);
                                    int vj = outj.valueAt(j);
                                    if (pi == pj && vi == vj) {
                                        ++i;
                                        ++j;
                                    } else if (pi < pj) {
                                        if (indpi != -1) {
                                            indpi = -1;
                                            break;
                                        }
                                        indpi = i++;
                                    } else if (pj < pi) {
                                        if (indpj != -1) {
                                            indpj = -1;
                                            break;
                                        }
                                        indpj = j++;
                                    } else {
                                        indpi = -1;
                                        indpj = -1;
                                        break;
                                    }
                                    if (i == outi.size() && j == outj.size() - 1) {
                                        if (indpj == -1) {
                                            indpj = j;
                                        } else {
                                            indpj = -1;
                                            break;
                                        }
                                    }
                                    if (i != outi.size() - 1 || j != outj.size()) continue;
                                    if (indpi == -1) {
                                        indpi = i;
                                        continue;
                                    }
                                    indpi = -1;
                                    break;
                                }
                                if (indpi != -1 && indpj != -1) {
                                    int vi = outi.valueAt(indpi);
                                    int vj = outj.valueAt(indpj);
                                    int pouti = outi.keyAt(indpi);
                                    int poutj = outj.keyAt(indpj);
                                    if (vi == vj) {
                                        SparseIntArray tpouti = tflowPT.getColumn(pouti);
                                        SparseIntArray tpoutj = tflowPT.getColumn(poutj);
                                        if (tpouti.size() == 1 && tpoutj.size() == 1) {
                                            int tti = tpouti.keyAt(0);
                                            int ttj = tpoutj.keyAt(0);
                                            SparseIntArray inputstti = this.flowPT.getColumn(tti).clone();
                                            int v = inputstti.get(pouti);
                                            inputstti.delete(pouti);
                                            inputstti.put(poutj, v);
                                            if (inputstti.equals(this.flowPT.getColumn(ttj)) && this.flowTP.getColumn(tti).equals(this.flowTP.getColumn(ttj))) {
                                                todel.add(tidj);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++itj;
                    }
                }
                ++iti;
            }
            ++pid;
        }
        Iterator iterator = todel.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.flowPT.deleteColumn(i);
            this.flowTP.deleteColumn(i);
            this.tnames.remove(i);
        }
        return todel.size();
    }

    private boolean isStronglyQuasiPersistent(int hid, IntMatrixCol tflowPT, ReductionType rt) {
        SparseIntArray hPT = this.flowPT.getColumn(hid);
        int pi = 0;
        while (pi < hPT.size()) {
            int pid = hPT.keyAt(pi);
            SparseIntArray pPT = tflowPT.getColumn(pid);
            if (pPT.size() > 1) {
                return false;
            }
            ++pi;
        }
        return true;
    }

    private boolean findAndReduceSCCSuffixes(ReductionType rt) throws DeadlockFound {
        if (rt == ReductionType.LTL || rt == ReductionType.LIVENESS) {
            return false;
        }
        Set<Integer> safeNodes = StructuralReduction.findSCCSuffixes(this, rt, this.untouchable);
        if (safeNodes.size() < this.getPlaceCount()) {
            this.dropIrrelevant(safeNodes);
            return true;
        }
        return false;
    }

    public static Set<Integer> findSCCSuffixes(ISparsePetriNet pn, ReductionType rt, BitSet untouchable) throws DeadlockFound {
        IntMatrixCol graph;
        long time = System.currentTimeMillis();
        if (rt == ReductionType.DEADLOCK) {
            HashSet<Integer> stablePlaces = new HashSet<Integer>();
            HashSet<Integer> stableTrans = new HashSet<Integer>();
            StructuralReduction.computeStabilizing(pn, stablePlaces, stableTrans);
            graph = StructuralReduction.buildGraph(pn, rt, stableTrans);
        } else {
            graph = StructuralReduction.buildGraph(pn, rt, -1);
        }
        Set<Integer> safeNodes = StructuralReduction.computeSafeNodes(pn, rt, graph, untouchable);
        if (rt == ReductionType.DEADLOCK) {
            graph = StructuralReduction.buildGraph(pn, rt, -1);
        }
        int nbP = pn.getPlaceCount();
        if (safeNodes.size() < nbP) {
            StructuralReduction.collectPrefix(safeNodes, graph, true);
            if (rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL) {
                int tid = 0;
                int e = pn.getTransitionCount();
                while (tid < e) {
                    SparseIntArray col2 = pn.getFlowPT().getColumn(tid);
                    int pi = 0;
                    int pie = col2.size();
                    while (pi < pie) {
                        int pid = col2.keyAt(pi);
                        if (safeNodes.contains(pid)) {
                            int i = 0;
                            while (i < pie) {
                                safeNodes.add(col2.keyAt(i));
                                ++i;
                            }
                            break;
                        }
                        ++pi;
                    }
                    ++tid;
                }
                StructuralReduction.collectPrefix(safeNodes, graph, true);
            }
        }
        if (safeNodes.size() < nbP) {
            int nbedges = graph.getColumns().stream().mapToInt(col -> col.size()).sum();
            System.out.println("Graph (complete) has " + nbedges + " edges and " + nbP + " vertex of which " + safeNodes.size() + " are kept as prefixes of interest. Removing " + (nbP - safeNodes.size()) + " places using SCC suffix rule." + (System.currentTimeMillis() - time) + " ms");
            return safeNodes;
        }
        return safeNodes;
    }

    public int dropIrrelevant(Set<Integer> safeNodes) {
        ArrayList<Integer> torem = new ArrayList<Integer>();
        int p = 0;
        int nbP = this.pnames.size();
        while (p < nbP) {
            if (!safeNodes.contains(p)) {
                torem.add(p);
            }
            ++p;
        }
        if (!torem.isEmpty()) {
            this.dropPlaces(torem, true, "Prefix Of Interest discarding " + torem.size() + " places");
        }
        return torem.size();
    }

    public static IntMatrixCol buildGraph(ISparsePetriNet pn, ReductionType rt, int skipped) {
        if (skipped == -1) {
            return StructuralReduction.buildGraph(pn, rt, Collections.emptySet());
        }
        return StructuralReduction.buildGraph(pn, rt, Collections.singleton(skipped));
    }

    private static IntMatrixCol buildGraph(ISparsePetriNet pn, ReductionType rt, Set<Integer> skippedTrans) {
        int nbP = pn.getPlaceCount();
        IntMatrixCol graph = new IntMatrixCol(nbP, nbP);
        int tid = 0;
        int tide = pn.getTransitionCount();
        while (tid < tide) {
            if (!skippedTrans.contains(tid)) {
                SparseIntArray hPT = pn.getFlowPT().getColumn(tid);
                SparseIntArray hTP = pn.getFlowTP().getColumn(tid);
                int j = 0;
                while (j < hTP.size()) {
                    if (rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL || rt == ReductionType.DEADLOCK || hTP.valueAt(j) != hPT.get(hTP.keyAt(j))) {
                        int i = 0;
                        while (i < hPT.size()) {
                            if (rt == ReductionType.SI_LTL || rt == ReductionType.LI_LTL || rt == ReductionType.SI_CTL || rt == ReductionType.DEADLOCK || hTP.keyAt(j) != hPT.keyAt(i)) {
                                graph.set(hTP.keyAt(j), hPT.keyAt(i), 1);
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
            ++tid;
        }
        return graph;
    }

    public static Set<Integer> computeSafeNodes(ISparsePetriNet pn, ReductionType rt, IntMatrixCol graph, BitSet untouchable) throws DeadlockFound {
        int nbP = graph.getColumnCount();
        HashSet<Integer> safeNodes = new HashSet<Integer>(nbP * 2);
        if (rt == ReductionType.SI_LTL || rt == ReductionType.SI_CTL || rt == ReductionType.LI_LTL || rt == ReductionType.DEADLOCK) {
            List<List<Integer>> sccs = Tarjan.searchForSCC(graph);
            sccs.removeIf(scc -> scc.size() == 1 && graph.get((Integer)scc.get(0), (Integer)scc.get(0)) == 0);
            if (sccs.isEmpty() && rt == ReductionType.DEADLOCK) {
                System.out.println("Complete graph has no SCC; deadlocks are unavoidable. place count " + pn.getPlaceCount() + " transition count " + pn.getTransitionCount());
                throw new DeadlockFound();
            }
            for (List<Integer> s : sccs) {
                safeNodes.addAll(s);
            }
        }
        if (rt == ReductionType.SI_LTL || rt == ReductionType.SI_CTL || rt == ReductionType.LI_LTL || rt == ReductionType.REACHABILITY) {
            int i = untouchable.nextSetBit(0);
            while (i >= 0) {
                safeNodes.add(i);
                if (i == Integer.MAX_VALUE) break;
                i = untouchable.nextSetBit(i + 1);
            }
            int tid = 0;
            int e = pn.getTransitionCount();
            while (tid < e) {
                if (StructuralReduction.touches(tid, pn, untouchable)) {
                    int i2 = 0;
                    int ee = pn.getFlowPT().getColumn(tid).size();
                    while (i2 < ee) {
                        safeNodes.add(pn.getFlowPT().getColumn(tid).keyAt(i2));
                        ++i2;
                    }
                }
                ++tid;
            }
        }
        return safeNodes;
    }

    public static void collectPrefix(Set<Integer> safeNodes, IntMatrixCol graph, boolean transpose) {
        if (safeNodes.size() == graph.getColumnCount()) {
            return;
        }
        IntMatrixCol tgraph = transpose ? graph.transpose() : graph;
        HashSet<Integer> seen = new HashSet<Integer>();
        ArrayList<Integer> todo = new ArrayList<Integer>(safeNodes);
        while (!todo.isEmpty()) {
            ArrayList<Integer> next = new ArrayList<Integer>();
            seen.addAll(todo);
            Iterator iterator = todo.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                SparseIntArray pred = tgraph.getColumn(n);
                int i = 0;
                while (i < pred.size()) {
                    int pre = pred.keyAt(i);
                    if (seen.add(pre)) {
                        next.add(pre);
                    }
                    ++i;
                }
            }
            todo = next;
        }
        safeNodes.addAll(seen);
    }

    public boolean findFreeSCC(ReductionType rt) {
        if (rt == ReductionType.LTL) {
            return false;
        }
        long time = System.currentTimeMillis();
        int nbP = this.pnames.size();
        IntMatrixCol graph = new IntMatrixCol(nbP, nbP);
        int nbedges = 0;
        int tid = 0;
        while (tid < this.flowPT.getColumnCount()) {
            SparseIntArray hPT = this.flowPT.getColumn(tid);
            SparseIntArray hTP = this.flowTP.getColumn(tid);
            if (hPT.size() == 1 && hTP.size() == 1 && hPT.valueAt(0) == 1 && hTP.valueAt(0) == 1 && !this.untouchable.get(hPT.keyAt(0)) && !this.untouchable.get(hTP.keyAt(0))) {
                graph.set(hTP.keyAt(0), hPT.keyAt(0), 1);
                ++nbedges;
            }
            ++tid;
        }
        List<List<Integer>> sccs = Tarjan.searchForSCC(graph);
        sccs.removeIf(s -> s.size() == 1);
        if (sccs.isEmpty()) {
            return false;
        }
        int nbcovered = sccs.stream().collect(Collectors.summingInt(scc -> scc.size()));
        System.out.println("Graph (trivial) has " + nbedges + " edges and " + nbP + " vertex of which " + nbcovered + " / " + nbP + " are part of one of the " + sccs.size() + " SCC in " + (System.currentTimeMillis() - time) + " ms");
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        ArrayList<Integer> tokill = new ArrayList<Integer>();
        for (List<Integer> sccl : sccs) {
            int kept = sccl.get(0);
            for (int other : sccl.subList(1, sccl.size())) {
                int val;
                int tid2;
                SparseIntArray fromO = tflowPT.getColumn(other);
                int i = 0;
                while (i < fromO.size()) {
                    tid2 = fromO.keyAt(i);
                    val = fromO.valueAt(i);
                    this.flowPT.getColumn(tid2).put(kept, this.flowPT.getColumn(tid2).get(kept) + val);
                    ++i;
                }
                fromO = tflowTP.getColumn(other);
                i = 0;
                while (i < fromO.size()) {
                    tid2 = fromO.keyAt(i);
                    val = fromO.valueAt(i);
                    this.flowTP.getColumn(tid2).put(kept, this.flowTP.getColumn(tid2).get(kept) + val);
                    ++i;
                }
                this.marks.set(kept, this.marks.get(kept) + this.marks.get(other));
                tokill.add(other);
            }
        }
        tokill.sort((a, b) -> -a.compareTo((Integer)b));
        tflowPT = this.flowPT.transpose();
        tflowTP = this.flowTP.transpose();
        ArrayList<String> prem = new ArrayList<String>();
        Iterator iterator = tokill.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            prem.add(this.dropPlace(i, tflowPT, tflowTP));
        }
        this.flowPT = tflowPT.transpose();
        this.flowTP = tflowTP.transpose();
        System.out.println("Free SCC test removed " + prem.size() + " places " + "");
        return true;
    }

    private boolean isDivergentFree(int hid) {
        SparseIntArray hPT = this.flowPT.getColumn(hid);
        SparseIntArray hTP = this.flowTP.getColumn(hid);
        int j = 0;
        int i = 0;
        while (i < hPT.size()) {
            int pi = hPT.keyAt(i);
            int vi = hPT.valueAt(i);
            while (j < hTP.size()) {
                int pj = hTP.keyAt(j);
                int vj = hTP.valueAt(j);
                if (pj < pi) {
                    ++j;
                    continue;
                }
                if (pi < pj) {
                    return true;
                }
                if (vi > vj) {
                    return true;
                }
                ++j;
                break;
            }
            if (j == hTP.size()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IntMatrixCol getFlowPT() {
        return this.flowPT;
    }

    @Override
    public IntMatrixCol getFlowTP() {
        return this.flowTP;
    }

    @Override
    public List<Integer> getMarks() {
        return this.marks;
    }

    @Override
    public List<String> getPnames() {
        return this.pnames;
    }

    @Override
    public List<String> getTnames() {
        return this.tnames;
    }

    public int fusePlaces(List<Integer> base, List<Integer> next) {
        TreeSet<Integer> todel = new TreeSet<Integer>((x, y) -> -Integer.compare(x, y));
        IntMatrixCol tflowTP = this.flowTP.transpose();
        IntMatrixCol tflowPT = this.flowPT.transpose();
        int i = 0;
        while (i < base.size()) {
            int ibase = base.get(i) - 1;
            if (ibase >= this.getPnames().size()) break;
            int itarg = next.get(i) - 1;
            tflowPT.setColumn(ibase, SparseIntArray.sumProd(1, tflowPT.getColumn(ibase), 1, tflowPT.getColumn(itarg)));
            tflowTP.setColumn(ibase, SparseIntArray.sumProd(1, tflowTP.getColumn(ibase), 1, tflowTP.getColumn(itarg)));
            this.marks.set(ibase, this.marks.get(ibase) + this.marks.get(itarg));
            this.image.set(ibase, Expression.op(Op.ADD, this.image.get(ibase), this.image.get(itarg)));
            todel.add(itarg);
            ++i;
        }
        ArrayList<String> prem = new ArrayList<String>();
        Iterator iterator = todel.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            prem.add(this.dropPlace(i2, tflowPT, tflowTP));
        }
        this.flowPT = tflowPT.transpose();
        this.flowTP = tflowTP.transpose();
        System.out.println("Place Fusion rule removed " + prem.size() + " places  " + "");
        return todel.size();
    }

    public void setProtected(BitSet support) {
        this.untouchable = support;
    }

    public int createSumOfVars(Set<Integer> pids, String name) {
        int m = 0;
        for (int p : pids) {
            m += this.marks.get(p).intValue();
        }
        ArrayList<Expression> tosum = new ArrayList<Expression>(pids.size());
        for (int p : pids) {
            tosum.add(this.image.get(p));
        }
        int id = this.marks.size();
        this.image.add(Expression.nop(Op.ADD, tosum));
        this.marks.add(m);
        this.pnames.add(name);
        int tid = 0;
        int e = this.tnames.size();
        while (tid < e) {
            this.updateCol(this.flowPT.getColumn(tid), id, pids);
            this.updateCol(this.flowTP.getColumn(tid), id, pids);
            ++tid;
        }
        this.flowPT.addRow();
        this.flowTP.addRow();
        return id;
    }

    private void updateCol(SparseIntArray col, int sumRep, Set<Integer> toSum) {
        int s = 0;
        int i = 0;
        int ee = col.size();
        while (i < ee) {
            if (toSum.contains(col.keyAt(i))) {
                s += col.valueAt(i);
            }
            ++i;
        }
        if (s != 0) {
            col.append(sumRep, s);
        }
    }

    public void setMarks(List<Integer> marks) {
        this.marks = marks;
    }

    public int abstractReads() {
        int abstracted = 0;
        int tid = 0;
        while (tid < this.tnames.size()) {
            int v;
            int p;
            SparseIntArray pre = new SparseIntArray();
            SparseIntArray post = new SparseIntArray();
            SparseIntArray cpre = this.flowPT.getColumn(tid);
            SparseIntArray cpost = this.flowTP.getColumn(tid);
            int i = 0;
            int ie = cpre.size();
            while (i < ie) {
                p = cpre.keyAt(i);
                v = cpre.valueAt(i);
                if (cpost.get(p) != v) {
                    pre.append(p, v);
                } else {
                    ++abstracted;
                }
                ++i;
            }
            i = 0;
            ie = cpost.size();
            while (i < ie) {
                p = cpost.keyAt(i);
                v = cpost.valueAt(i);
                if (cpre.get(p) != v) {
                    post.append(p, v);
                }
                ++i;
            }
            this.flowPT.setColumn(tid, pre);
            this.flowTP.setColumn(tid, post);
            ++tid;
        }
        return abstracted;
    }

    @Override
    public int getPlaceCount() {
        return this.pnames.size();
    }

    @Override
    public int getTransitionCount() {
        return this.tnames.size();
    }

    @Override
    public boolean isSafe() {
        return this.isSafe;
    }

    @Override
    public void setSafe(boolean isSafe) {
        this.isSafe = isSafe;
    }

    public boolean isKeepImage() {
        return this.keepImage;
    }

    public static void computeStabilizing(ISparsePetriNet pn, Set<Integer> stablePlaces, Set<Integer> stableTransitions) {
        IntMatrixCol flow = new IntMatrixCol(pn.getPlaceCount(), 0);
        boolean hasPosTrans = false;
        HashSet<Integer> negtrans = new HashSet<Integer>();
        int ti = 0;
        int tie = pn.getTransitionCount();
        while (ti < tie) {
            SparseIntArray trans = SparseIntArray.sumProd(-1, pn.getFlowPT().getColumn(ti), 1, pn.getFlowTP().getColumn(ti));
            flow.appendColumn(trans);
            int sumv = trans.sumValues();
            if (!hasPosTrans && sumv > 0) {
                hasPosTrans = true;
            } else if (!hasPosTrans && sumv < 0) {
                negtrans.add(ti);
            }
            ++ti;
        }
        if (!hasPosTrans) {
            stableTransitions.addAll(negtrans);
        }
        IntMatrixCol tflow = flow.transpose();
        boolean changed = true;
        while (changed) {
            int ie;
            int i;
            SparseIntArray effect;
            changed = false;
            int pid = 0;
            int pide = pn.getPlaceCount();
            while (pid < pide) {
                if (!stablePlaces.contains(pid)) {
                    boolean isFed = false;
                    effect = tflow.getColumn(pid);
                    i = 0;
                    ie = effect.size();
                    while (i < ie) {
                        if (!stableTransitions.contains(effect.keyAt(i)) && effect.valueAt(i) > 0) {
                            isFed = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isFed) {
                        stablePlaces.add(pid);
                        changed = true;
                    }
                }
                ++pid;
            }
            int tid = 0;
            int tide = pn.getTransitionCount();
            while (tid < tide) {
                if (!stableTransitions.contains(tid)) {
                    boolean isStable = false;
                    effect = flow.getColumn(tid);
                    i = 0;
                    ie = effect.size();
                    while (i < ie) {
                        if (effect.valueAt(i) < 0 && stablePlaces.contains(effect.keyAt(i))) {
                            isStable = true;
                            break;
                        }
                        ++i;
                    }
                    if (isStable) {
                        stableTransitions.add(tid);
                        changed = true;
                    }
                }
                ++tid;
            }
        }
        System.out.println("Computed a total of " + stablePlaces.size() + " stabilizing places and " + stableTransitions.size() + " stable transitions");
    }

    public void dropSurroundingTransitions(List<Integer> deadPlaces, String rule) {
        HashSet<Integer> tokill = new HashSet<Integer>();
        IntMatrixCol tflowPT = this.flowPT.transpose();
        IntMatrixCol tflowTP = this.flowTP.transpose();
        for (Integer pid : deadPlaces) {
            SparseIntArray row = tflowPT.getColumn(pid);
            int i = 0;
            int ie = row.size();
            while (i < ie) {
                tokill.add(row.keyAt(i));
                ++i;
            }
            row = tflowTP.getColumn(pid);
            i = 0;
            ie = row.size();
            while (i < ie) {
                tokill.add(row.keyAt(i));
                ++i;
            }
        }
        this.dropTransitions(new ArrayList<Integer>(tokill), true, rule);
    }

    public int applyCausalDecomposition(int placeId) {
        if (placeId < 0 || placeId >= this.pnames.size()) {
            System.out.println("Invalid placeId: " + placeId);
            return 0;
        }
        IntMatrixCol tflowTP = this.flowTP.transpose();
        IntMatrixCol tflowPT = this.flowPT.transpose();
        SparseIntArray feeders = tflowTP.getColumn(placeId);
        int k = feeders.size();
        if (k <= 1) {
            System.out.println("Place " + this.pnames.get(placeId) + " has " + k + " feeders; no decomposition needed.");
            return 0;
        }
        if (this.marks.get(placeId) != 0) {
            System.out.println("Place " + this.pnames.get(placeId) + " has non-zero initial marking; decomposition may not be safe.");
        }
        int nbP = this.pnames.size();
        int i = 0;
        while (i < k) {
            String newPlaceName = this.pnames.get(placeId) + "_" + i;
            int newPlaceId = this.pnames.size();
            this.pnames.add(newPlaceName);
            this.marks.add(0);
            this.image.add(Expression.var(newPlaceId));
            this.flowPT.addRow();
            this.flowTP.addRow();
            ++i;
        }
        i = 0;
        while (i < feeders.size()) {
            int tid = feeders.keyAt(i);
            int weight = feeders.valueAt(i);
            this.flowTP.getColumn(tid).put(placeId, 0);
            this.flowTP.getColumn(tid).put(nbP + i, weight);
            ++i;
        }
        SparseIntArray consumers = tflowPT.getColumn(placeId);
        int nbT = this.tnames.size();
        ArrayList<Integer> tokill = new ArrayList<Integer>();
        int index = 0;
        while (index < consumers.size()) {
            int tid = consumers.keyAt(index);
            tokill.add(tid);
            int i2 = 0;
            while (i2 < k) {
                String newTransName = this.tnames.get(tid) + "_" + i2;
                SparseIntArray origPre = this.flowPT.getColumn(tid).clone();
                SparseIntArray origPost = this.flowTP.getColumn(tid).clone();
                origPre.put(nbP + i2, origPre.get(placeId));
                origPre.put(placeId, 0);
                this.flowPT.appendColumn(origPre);
                this.flowTP.appendColumn(origPost);
                this.tnames.add(newTransName);
                ++i2;
            }
            ++index;
        }
        this.dropTransitions(tokill, true, "Causal decomposition of place " + this.pnames.get(placeId));
        System.out.println("Causal decomposition created " + k + " new places and " + consumers.size() * k + " new transitions for place " + this.pnames.get(placeId));
        return k;
    }

    public static enum ReductionType {
        DEADLOCK,
        REACHABILITY,
        SI_LTL,
        LTL,
        LIVENESS,
        STATESPACE,
        LI_LTL,
        SI_CTL,
        NONE;

    }
}

