/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.StructuralReduction;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class StructuralToGreatSPN {
    private static Logger log = Logger.getLogger("fr.lip6.move.gal");
    private List<String> order = new ArrayList<String>();

    private static Logger getLog() {
        return log;
    }

    public void transform(StructuralReduction sr, String path) throws IOException {
        PrintWriter pwdef = new PrintWriter(new File(path + ".def"));
        PrintWriter pwnet = new PrintWriter(new File(path + ".net"));
        this.handlePage(sr, pwdef, pwnet);
        pwnet.close();
        pwdef.close();
    }

    public static String normalizeName(String text) {
        String res = text.replace(' ', '_');
        res = res.replace('-', '_');
        res = res.replace('/', '_');
        res = res.replace('*', 'x');
        res = res.replace('=', '_');
        return res;
    }

    private void handlePage(StructuralReduction sr, PrintWriter pwdef, PrintWriter pwnet) {
        HashMap<Integer, Integer> placeMap = new HashMap<Integer, Integer>();
        pwdef.println("|256\n%\n|\n");
        pwnet.append("|0|\n|\nf 0 ");
        long nbplaces = sr.getPnames().size();
        pwnet.append(nbplaces + " ");
        pwnet.append("0 ");
        long nbtrans = sr.getTnames().size();
        pwnet.append(nbtrans + " ");
        pwnet.append("0 ");
        pwnet.append("0 ");
        pwnet.append("0\n");
        int nb = 1;
        int pid = 0;
        while (pid < sr.getPnames().size()) {
            String pname = StructuralToGreatSPN.normalizeName(sr.getPnames().get(pid));
            int value = sr.getMarks().get(pid);
            this.order.add(pname);
            pwnet.append(pname).append("    ");
            pwnet.append(value + " ");
            pwnet.append("1.0 1.0 ");
            pwnet.append("1.0 1.0 ");
            pwnet.append("0\n");
            placeMap.put(pid, nb++);
            ++pid;
        }
        StructuralToGreatSPN.getLog().info("Transformed " + (nb - 1) + " places.");
        int tid = 0;
        while (tid < sr.getTnames().size()) {
            int val;
            int pid2;
            String tname = StructuralToGreatSPN.normalizeName(sr.getTnames().get(tid));
            pwnet.append(tname + " ");
            pwnet.append("1.0   ");
            pwnet.append("1 ");
            pwnet.append("0 ");
            int nbArcsIn = sr.getFlowPT().getColumn(tid).size();
            pwnet.append(nbArcsIn + " ");
            pwnet.append("0 ");
            pwnet.append("1.0 1.0 ");
            pwnet.append("1.0 1.0 ");
            pwnet.append("1.0 1.0 ");
            pwnet.append("0\n");
            SparseIntArray inputs = sr.getFlowPT().getColumn(tid);
            int i = 0;
            while (i < inputs.size()) {
                pid2 = (Integer)placeMap.get(inputs.keyAt(i));
                val = inputs.valueAt(i);
                pwnet.append("   ");
                pwnet.append(val + "   ");
                pwnet.append(pid2 + "   ");
                pwnet.append("0 ");
                pwnet.append("0\n");
                ++i;
            }
            inputs = sr.getFlowTP().getColumn(tid);
            pwnet.append("   " + inputs.size() + "\n");
            i = 0;
            while (i < inputs.size()) {
                pid2 = (Integer)placeMap.get(inputs.keyAt(i));
                val = inputs.valueAt(i);
                pwnet.append("   ");
                pwnet.append(val + "   ");
                pwnet.append(pid2 + "   ");
                pwnet.append("0 ");
                pwnet.append("0\n");
                ++i;
            }
            pwnet.append("   0\n");
            ++tid;
        }
        StructuralToGreatSPN.getLog().info("Transformed " + nbtrans + " transitions.");
    }

    public List<String> getInitialOrder() {
        return this.order;
    }
}

