/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.SparsePetriNet;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class StructuralToPNML {
    private static Logger log = Logger.getLogger("fr.lip6.move.gal");

    private static Logger getLog() {
        return log;
    }

    public static void transform(SparsePetriNet sr, String path) throws IOException {
        int val;
        int p;
        int i;
        long time = System.currentTimeMillis();
        PrintWriter pw = new PrintWriter(new File(path));
        pw.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        pw.append("<pnml xmlns=\"http://www.pnml.org/version-2009/grammar/pnml\">\n");
        pw.append("<net id=\"" + sr.getName() + "\" type=\"http://www.pnml.org/version-2009/grammar/ptnet\">\n");
        pw.append("<page id=\"page0\"><name><text>DefaultPage</text></name>\n");
        int nbplaces = 0;
        int p2 = 0;
        while (p2 < sr.getPnames().size()) {
            pw.append("<place id=\"p" + p2 + "\">");
            pw.append("<name><text>" + sr.getPnames().get(p2) + "</text></name>");
            Integer mark = sr.getMarks().get(p2);
            if (mark != 0) {
                pw.append("<initialMarking><text>" + String.valueOf(mark) + "</text></initialMarking>");
            }
            pw.append("</place>\n");
            ++nbplaces;
            ++p2;
        }
        int nbtrans = 0;
        int t = 0;
        while (t < sr.getTnames().size()) {
            pw.append("<transition id=\"t" + t + "\">");
            pw.append("<name><text>" + sr.getTnames().get(t) + "</text></name>");
            pw.append("</transition>\n");
            ++nbtrans;
            ++t;
        }
        int arcid = 0;
        int t2 = 0;
        while (t2 < sr.getTnames().size()) {
            SparseIntArray pt = sr.getFlowPT().getColumn(t2);
            i = 0;
            while (i < pt.size()) {
                p = pt.keyAt(i);
                val = pt.valueAt(i);
                pw.append("<arc id=\"arc" + arcid++ + "\" source=\"p" + p + "\" target=\"t" + t2 + "\">");
                if (val != 1) {
                    pw.append("<inscription><text>" + val + "</text></inscription>");
                }
                pw.append("</arc>\n");
                ++i;
            }
            ++t2;
        }
        t2 = 0;
        while (t2 < sr.getTnames().size()) {
            SparseIntArray tp = sr.getFlowTP().getColumn(t2);
            i = 0;
            while (i < tp.size()) {
                p = tp.keyAt(i);
                val = tp.valueAt(i);
                pw.append("<arc id=\"arc" + arcid++ + "\" source=\"t" + t2 + "\" target=\"p" + p + "\">");
                if (val != 1) {
                    pw.append("<inscription><text>" + val + "</text></inscription>");
                }
                pw.append("</arc>\n");
                ++i;
            }
            ++t2;
        }
        pw.append("</page>\n");
        pw.append("<name><text>" + sr.getName() + "</text></name></net>\n");
        pw.append("</pnml>\n");
        pw.flush();
        pw.close();
        StructuralToPNML.getLog().info("Export to PNML in file " + path + " of net with " + nbplaces + " places, " + nbtrans + " transitions and " + arcid + " arcs took " + (System.currentTimeMillis() - time) + " ms.");
    }
}

