/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WalkUtils {
    private int behaviorCount;
    private int[] behaviorMap;
    private int[][] behaviors;
    private IntMatrixCol combFlow;
    private ISparsePetriNet net;
    private IntMatrixCol tFlowPT;
    private int emptyEffect = -1;
    private int[] initialEnabling;

    public WalkUtils(ISparsePetriNet sr) {
        this.net = sr;
        LinkedHashMap<SparseIntArray, List> effects = new LinkedHashMap<SparseIntArray, List>();
        this.combFlow = new IntMatrixCol(this.net.getPlaceCount(), 0);
        int i = 0;
        while (i < this.net.getFlowPT().getColumnCount()) {
            SparseIntArray col = SparseIntArray.sumProd(-1, this.net.getFlowPT().getColumn(i), 1, this.net.getFlowTP().getColumn(i));
            this.combFlow.appendColumn(col);
            effects.computeIfAbsent(col, k -> new ArrayList()).add(i);
            ++i;
        }
        this.behaviorMap = new int[this.net.getTransitionCount()];
        this.behaviors = new int[effects.size()][];
        i = 0;
        for (Map.Entry ent : effects.entrySet()) {
            this.behaviors[i] = new int[((List)ent.getValue()).size()];
            int j = 0;
            for (Integer t : (List)ent.getValue()) {
                this.behaviorMap[t.intValue()] = i;
                this.behaviors[i][j++] = t;
            }
            if (((SparseIntArray)ent.getKey()).size() == 0) {
                this.emptyEffect = i;
            }
            ++i;
        }
        this.behaviorCount = effects.size();
        this.tFlowPT = this.net.getFlowPT().transpose();
    }

    public int[] computeEnabled(SparseIntArray state) {
        int[] list = new int[this.net.getTransitionCount() + 1];
        boolean[] seenEffects = new boolean[this.behaviorCount];
        int li = 1;
        int t = 0;
        int e = this.net.getTransitionCount();
        while (t < e) {
            if (!seenEffects[this.behaviorMap[t]] && SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t))) {
                list[li++] = t;
                seenEffects[this.behaviorMap[t]] = true;
            }
            ++t;
        }
        list[0] = li - 1;
        return list;
    }

    public boolean canStutter(int[] enabled) {
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (this.behaviorMap[t] == this.emptyEffect) {
                return true;
            }
            --i;
        }
        return false;
    }

    void dropEmpty(int[] enabled) {
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (this.combFlow.getColumn(t).size() == 0) {
                WalkUtils.dropAt(enabled, i);
            }
            --i;
        }
    }

    void dropUnavailable(int[] enabled, SparseIntArray parikh) {
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (parikh.get(t) <= 0) {
                WalkUtils.dropAt(enabled, i);
            }
            --i;
        }
    }

    public SparseIntArray fire(int t, SparseIntArray state) {
        return SparseIntArray.sumProd(1, state, 1, this.combFlow.getColumn(t));
    }

    public IntMatrixCol getCombFlow() {
        return this.combFlow;
    }

    public IntMatrixCol getFlowPT() {
        return this.net.getFlowPT();
    }

    public IntMatrixCol getFlowTP() {
        return this.net.getFlowTP();
    }

    public SparseIntArray getInitial() {
        return new SparseIntArray(this.net.getMarks());
    }

    public void updateEnabled(SparseIntArray state, int[] enabled, int tfired) {
        this.updateEnabled(state, enabled, tfired, true);
    }

    public void updateEnabled(SparseIntArray state, int[] enabled, int tfired, boolean dropEmptyEffects) {
        if (this.combFlow.getColumn(tfired).size() == 0) {
            return;
        }
        boolean[] seen = new boolean[this.net.getTransitionCount()];
        boolean[] seenEffects = new boolean[this.behaviorCount];
        SparseIntArray disabledEffects = new SparseIntArray();
        int i = enabled[0];
        while (i >= 1) {
            int t = enabled[i];
            if (seen[t] || seenEffects[this.behaviorMap[t]]) {
                WalkUtils.dropAt(enabled, i);
            } else if (SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t))) {
                seen[t] = true;
                seenEffects[this.behaviorMap[t]] = true;
            } else {
                if (!seenEffects[this.behaviorMap[t]]) {
                    disabledEffects.put(this.behaviorMap[t], 1);
                }
                WalkUtils.dropAt(enabled, i);
            }
            --i;
        }
        SparseIntArray tp = this.combFlow.getColumn(tfired);
        int pi = 0;
        int pie = tp.size();
        while (pi < pie) {
            int p = tp.keyAt(pi);
            if (tp.valueAt(pi) > 0) {
                SparseIntArray col = this.tFlowPT.getColumn(p);
                int i2 = 0;
                while (i2 < col.size()) {
                    int t = col.keyAt(i2);
                    if (!(seen[t] || seenEffects[this.behaviorMap[t]] || dropEmptyEffects && this.combFlow.getColumn(t).size() == 0 || !SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t)))) {
                        WalkUtils.add(enabled, t);
                        seen[t] = true;
                        seenEffects[this.behaviorMap[t]] = true;
                    }
                    ++i2;
                }
            }
            ++pi;
        }
        int i3 = 0;
        int ie = disabledEffects.size();
        while (i3 < ie) {
            int effect = disabledEffects.keyAt(i3);
            if (!seenEffects[effect]) {
                int[] nArray = this.behaviors[effect];
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int t = nArray[n2];
                    if (!seen[t] && SparseIntArray.greaterOrEqual(state, this.net.getFlowPT().getColumn(t))) {
                        WalkUtils.add(enabled, t);
                        break;
                    }
                    ++n2;
                }
            }
            ++i3;
        }
    }

    public static void add(int[] enabled, int value) {
        enabled[enabled[0] + 1] = value;
        enabled[0] = enabled[0] + 1;
    }

    public static void dropAt(int[] enabled, int index) {
        if (index < enabled[0]) {
            enabled[index] = enabled[enabled[0]];
        }
        enabled[0] = enabled[0] - 1;
    }

    public ISparsePetriNet getNet() {
        return this.net;
    }

    public int[] getInitialEnabling() {
        if (this.initialEnabling == null) {
            this.initialEnabling = this.computeEnabled(this.getInitial());
        }
        return this.initialEnabling;
    }
}

