/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;

public class ArrayVarRef
implements Expression {
    public int base;
    public Expression index;

    public ArrayVarRef(int base, Expression index) {
        this.base = base;
        this.index = index;
    }

    @Override
    public int eval(SparseIntArray state) {
        return state.get(this.base + this.index.eval(state));
    }

    @Override
    public int getValue() {
        return this.base + this.index.eval(null);
    }

    @Override
    public <T> T accept(ExprVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String toString() {
        return "s" + this.base + "[" + String.valueOf(this.index) + "]";
    }

    @Override
    public int evalDistance(SparseIntArray state, boolean isNeg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op getOp() {
        return Op.HLPLACEREF;
    }

    public int hashCode() {
        int result = 1;
        result = 11171 * result + this.base;
        result = 11171 * result + (this.index == null ? 0 : this.index.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayVarRef other = (ArrayVarRef)obj;
        if (this.base != other.base) {
            return false;
        }
        return !(this.index == null ? other.index != null : !this.index.equals(other.index));
    }

    @Override
    public int nbChildren() {
        return 1;
    }

    @Override
    public Expression childAt(int i) {
        if (i == 0) {
            return this.index;
        }
        throw new UnsupportedOperationException();
    }
}

