/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.expr.AtomicProp;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.CExpressionPrinter;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Simplifier;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AtomicPropManager {
    private Map<String, Expression> propsWithAp = new HashMap<String, Expression>();
    private Map<String, AtomicProp> uniqueMap = new HashMap<String, AtomicProp>();
    private Map<String, AtomicProp> apMap = new LinkedHashMap<String, AtomicProp>();

    public AtomicProp registerExpression(Expression e) {
        AtomicProp atom = new AtomicProp("p" + this.apMap.size(), e);
        this.apMap.put(atom.getName(), atom);
        return atom;
    }

    public Collection<AtomicProp> getAtoms() {
        return this.apMap.values();
    }

    public Map<String, Expression> loadAtomicProps(List<Property> props) {
        this.apMap.clear();
        this.propsWithAp.clear();
        this.uniqueMap.clear();
        for (Property prop : props) {
            if (prop.getType() != PropertyType.LTL && prop.getType() != PropertyType.CTL && prop.getType() != PropertyType.INVARIANT) continue;
            Expression e = this.collectAndRewriteUsingAtoms(prop.getBody(), this.uniqueMap);
            this.propsWithAp.put(prop.getName(), e);
        }
        return this.propsWithAp;
    }

    public int size() {
        return this.apMap.size();
    }

    public static boolean isPureBool(Expression obj) {
        if (obj == null) {
            return true;
        }
        switch (obj.getOp()) {
            case NOT: 
            case AND: 
            case OR: {
                int i = 0;
                int ie = obj.nbChildren();
                while (i < ie) {
                    Expression child = obj.childAt(i);
                    if (!AtomicPropManager.isPureBool(child)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: 
            case ENABLED: 
            case BOOLCONST: {
                return true;
            }
        }
        return false;
    }

    public static String toString(Expression e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CExpressionPrinter printer = new CExpressionPrinter(new PrintWriter(baos), "src");
        e.accept(printer);
        printer.close();
        return baos.toString();
    }

    public Expression collectAndRewriteUsingAtoms(Expression expr, Map<String, AtomicProp> uniqueMap) {
        Expression child;
        if (expr == null) {
            return expr;
        }
        if (expr.getOp() == Op.BOOLCONST) {
            return expr;
        }
        if (expr.getOp() == Op.NOT) {
            Expression nc = this.collectAndRewriteUsingAtoms(expr.childAt(0), uniqueMap);
            if (nc != expr.childAt(0)) {
                return Expression.not(nc);
            }
            return expr;
        }
        if (AtomicPropManager.isPureBool(expr)) {
            String stringProp = AtomicPropManager.toString(expr);
            AtomicProp atom = uniqueMap.get(stringProp);
            if (atom == null) {
                Expression neg = Simplifier.pushNegation(Expression.not(expr));
                String negstringProp = AtomicPropManager.toString(neg);
                atom = uniqueMap.get(negstringProp);
                if (atom == null) {
                    atom = new AtomicProp("p" + this.apMap.size(), expr);
                    this.apMap.put(atom.getName(), atom);
                    uniqueMap.put(stringProp, atom);
                } else {
                    return Expression.not(Expression.apRef(atom));
                }
            }
            return Expression.apRef(atom);
        }
        if (expr.nbChildren() > 2 && (expr.getOp() == Op.OR || expr.getOp() == Op.AND)) {
            ArrayList<Expression> subAtoms = new ArrayList<Expression>();
            ArrayList<Expression> others = new ArrayList<Expression>();
            int cid = 0;
            int cide = expr.nbChildren();
            while (cid < cide) {
                child = expr.childAt(cid);
                if (AtomicPropManager.isPureBool(child)) {
                    subAtoms.add(child);
                } else {
                    others.add(child);
                }
                ++cid;
            }
            if (subAtoms.size() > 1) {
                Expression newAtom = Expression.nop(expr.getOp(), subAtoms);
                AtomicProp ap = this.registerExpression(newAtom);
                ArrayList<Expression> resc = new ArrayList<Expression>(others.size() + 1);
                for (Expression child2 : others) {
                    resc.add(this.collectAndRewriteUsingAtoms(child2, uniqueMap));
                }
                resc.add(Expression.apRef(ap));
                Expression res = Expression.nop(expr.getOp(), resc);
                return res;
            }
        }
        if (expr.getOp() == Op.APREF) {
            return this.collectAndRewriteUsingAtoms(((AtomicPropRef)expr).getAp().getExpression(), uniqueMap);
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int ci = 0;
        int cie = expr.nbChildren();
        while (ci < cie) {
            child = expr.childAt(ci);
            Expression nc = this.collectAndRewriteUsingAtoms(child, uniqueMap);
            if (nc != child) {
                changed = true;
            }
            resc.add(nc);
            ++ci;
        }
        if (changed) {
            return Expression.nop(expr.getOp(), resc);
        }
        return expr;
    }

    public Expression getAPformula(String name) {
        return this.propsWithAp.get(name);
    }

    public AtomicProp findAP(String name) {
        return this.apMap.get(name);
    }

    public static Expression rewriteWithoutAP(Expression expr) {
        if (expr == null) {
            return expr;
        }
        if (expr.getOp() == Op.BOOLCONST) {
            return expr;
        }
        if (expr.getOp() == Op.APREF) {
            AtomicPropRef apr = (AtomicPropRef)expr;
            return apr.getAp().getExpression();
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int ci = 0;
        int cie = expr.nbChildren();
        while (ci < cie) {
            Expression child = expr.childAt(ci);
            Expression nc = AtomicPropManager.rewriteWithoutAP(child);
            if (nc != child) {
                changed = true;
            }
            resc.add(nc);
            ++ci;
        }
        if (changed) {
            return Expression.nop(expr.getOp(), resc);
        }
        return expr;
    }
}

