/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.function.Function;

public class BinOp
implements Expression {
    public Op op;
    public Expression left;
    public Expression right;

    public BinOp(Op op, Expression left, Expression right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    @Override
    public int eval(SparseIntArray state) {
        switch (this.op) {
            case AND: {
                return this.left.eval(state) == 1 && this.right.eval(state) == 1 ? 1 : 0;
            }
            case OR: {
                return this.left.eval(state) == 1 || this.right.eval(state) == 1 ? 1 : 0;
            }
        }
        int l = this.left.eval(state);
        int r = this.right != null ? this.right.eval(state) : 0;
        switch (this.op) {
            case EQ: {
                return l == r ? 1 : 0;
            }
            case NEQ: {
                return l != r ? 1 : 0;
            }
            case LT: {
                return l < r ? 1 : 0;
            }
            case GT: {
                return l > r ? 1 : 0;
            }
            case LEQ: {
                return l <= r ? 1 : 0;
            }
            case GEQ: {
                return l >= r ? 1 : 0;
            }
            case NOT: {
                return l == 0 ? 1 : 0;
            }
            case ADD: {
                return l + r;
            }
            case MULT: {
                return l * r;
            }
            case DIV: {
                return l / r;
            }
            case MINUS: {
                return l - r;
            }
            case MOD: {
                return l % r;
            }
        }
        throw new RuntimeException("Unexpected operator type in expression " + String.valueOf((Object)this.op));
    }

    @Override
    public String toString() {
        return "(" + String.valueOf((Object)this.op) + (String)(this.left != null ? " " + this.left.toString() : "") + (String)(this.right != null ? " " + this.right.toString() : "") + ")";
    }

    @Override
    public <T> T accept(ExprVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int evalDistance(SparseIntArray state, boolean isNeg) {
        if (!isNeg) {
            switch (this.op) {
                case AND: {
                    return this.left.evalDistance(state, isNeg) + this.right.evalDistance(state, isNeg);
                }
                case OR: {
                    return Math.min(this.left.evalDistance(state, isNeg), this.right.evalDistance(state, isNeg));
                }
                case NOT: {
                    return this.left.evalDistance(state, !isNeg);
                }
                case EQ: {
                    return Math.abs(this.left.eval(state) - this.right.eval(state));
                }
                case NEQ: {
                    return this.left.eval(state) == this.right.eval(state) ? 1 : 0;
                }
                case LT: {
                    return Math.max(this.left.eval(state) - this.right.eval(state) + 1, 0);
                }
                case GT: {
                    return Math.max(this.right.eval(state) - this.left.eval(state) + 1, 0);
                }
                case LEQ: {
                    return Math.max(this.left.eval(state) - this.right.eval(state), 0);
                }
                case GEQ: {
                    return Math.max(this.right.eval(state) - this.left.eval(state), 0);
                }
            }
        } else {
            switch (this.op) {
                case AND: {
                    return Math.min(this.left.evalDistance(state, isNeg), this.right.evalDistance(state, isNeg));
                }
                case OR: {
                    return this.left.evalDistance(state, isNeg) + this.right.evalDistance(state, isNeg);
                }
                case NOT: {
                    return this.left.evalDistance(state, !isNeg);
                }
                case EQ: {
                    return this.left.eval(state) == this.right.eval(state) ? 1 : 0;
                }
                case NEQ: {
                    return Math.abs(this.left.eval(state) - this.right.eval(state));
                }
                case LT: {
                    return Math.max(this.right.eval(state) - this.left.eval(state), 0);
                }
                case GT: {
                    return Math.max(this.left.eval(state) - this.right.eval(state), 0);
                }
                case LEQ: {
                    return Math.max(this.right.eval(state) - this.left.eval(state) + 1, 0);
                }
                case GEQ: {
                    return Math.max(this.left.eval(state) - this.right.eval(state) + 1, 0);
                }
            }
        }
        throw new RuntimeException("Unexpected operator type in expression " + String.valueOf((Object)this.op));
    }

    @Override
    public Op getOp() {
        return this.op;
    }

    @Override
    public <T> void forEachChild(Function<Expression, T> foo) {
        if (this.left != null) {
            foo.apply(this.left);
        }
        if (this.right != null) {
            foo.apply(this.right);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 17477 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 17477 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 17477 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinOp other = (BinOp)obj;
        if (this.op != other.op) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }

    @Override
    public int nbChildren() {
        int nb = 0;
        if (this.left != null) {
            ++nb;
        }
        if (this.right != null) {
            ++nb;
        }
        return nb;
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            if (this.left != null) {
                return this.left;
            }
            return this.right;
        }
        if (index == 1) {
            return this.right;
        }
        throw new UnsupportedOperationException();
    }
}

