/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;

public class BoolConstant
implements Expression {
    public boolean value;

    public BoolConstant(boolean value) {
        this.value = value;
    }

    @Override
    public int eval(SparseIntArray state) {
        return this.value ? 1 : 0;
    }

    @Override
    public <T> T accept(ExprVisitor<T> v) {
        return v.visitBool(this);
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public int evalDistance(SparseIntArray state, boolean isNegated) {
        if (this.value ^ isNegated) {
            return 0;
        }
        return 1000;
    }

    @Override
    public Op getOp() {
        return Op.BOOLCONST;
    }

    @Override
    public int getValue() {
        return this.eval(null);
    }

    public int hashCode() {
        if (this.value) {
            return 12689;
        }
        return 20411;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoolConstant other = (BoolConstant)obj;
        return this.value == other.value;
    }
}

