/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import fr.lip6.move.gal.structural.expr.ArrayVarRef;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.BoolConstant;
import fr.lip6.move.gal.structural.expr.Constant;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.ParamRef;
import fr.lip6.move.gal.structural.expr.TransRef;
import fr.lip6.move.gal.structural.expr.VarRef;
import java.io.PrintWriter;

public class CExpressionPrinter
implements ExprVisitor<Void> {
    private String prefix;
    protected PrintWriter pw;

    public CExpressionPrinter(PrintWriter pw, String prefix) {
        this.pw = pw;
        this.prefix = prefix;
    }

    public void close() {
        this.pw.close();
    }

    public void infix(BinOp binOp, String op) {
        this.pw.append("(");
        binOp.left.accept(this);
        this.pw.append(op);
        binOp.right.accept(this);
        this.pw.append(")");
    }

    @Override
    public Void visit(ArrayVarRef arrayVarRef) {
        throw new UnsupportedOperationException("Unexpected Array Ref in expression translated to C : " + String.valueOf(arrayVarRef));
    }

    @Override
    public Void visit(BinOp binOp) {
        switch (binOp.getOp()) {
            case AND: {
                this.infix(binOp, "&&");
                break;
            }
            case OR: {
                this.infix(binOp, "||");
                break;
            }
            case NOT: {
                this.pw.append("!");
                binOp.left.accept(this);
                break;
            }
            case ADD: {
                this.infix(binOp, "+");
                break;
            }
            case EQ: {
                this.infix(binOp, "==");
                break;
            }
            case NEQ: {
                this.infix(binOp, "!=");
                break;
            }
            case LT: {
                this.infix(binOp, "<");
                break;
            }
            case LEQ: {
                this.infix(binOp, "<=");
                break;
            }
            case GEQ: {
                this.infix(binOp, ">=");
                break;
            }
            case GT: {
                this.infix(binOp, ">");
                break;
            }
            case DIV: {
                this.infix(binOp, "/");
                break;
            }
            case MINUS: {
                this.infix(binOp, "-");
                break;
            }
            case MOD: {
                this.infix(binOp, "%");
                break;
            }
            case MULT: {
                this.infix(binOp, "*");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected temporal operator in Boolean expression :" + String.valueOf(binOp));
            }
        }
        return null;
    }

    @Override
    public Void visit(Constant constant) {
        this.pw.append(Integer.toString(constant.getValue()));
        return null;
    }

    @Override
    public Void visit(NaryOp naryOp) {
        String symbol = null;
        switch (naryOp.getOp()) {
            case AND: {
                symbol = "&&";
                break;
            }
            case OR: {
                symbol = "||";
                break;
            }
            case ADD: {
                symbol = "+";
                break;
            }
            case MULT: {
                symbol = "*";
                break;
            }
            case ENABLED: 
            case CARD: {
                symbol = ",";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected Nary operator in expression translated to C : " + String.valueOf(naryOp));
            }
        }
        this.pw.append("(");
        int i = 0;
        int ie = naryOp.nbChildren();
        while (i < ie) {
            Expression child = naryOp.childAt(i);
            child.accept(this);
            if (i < ie - 1) {
                this.pw.append(symbol);
            }
            ++i;
        }
        this.pw.append(")");
        return null;
    }

    @Override
    public Void visit(ParamRef paramRef) {
        throw new UnsupportedOperationException("Unexpected ParamRef in Boolean expression : " + String.valueOf(paramRef));
    }

    @Override
    public Void visit(TransRef transRef) {
        this.pw.append("t" + transRef.getValue());
        return null;
    }

    @Override
    public Void visit(VarRef varRef) {
        this.pw.append(this.prefix).append("[").append(Integer.toString(varRef.getValue())).append("]");
        return null;
    }

    @Override
    public Void visitBool(BoolConstant boolConstant) {
        this.pw.append(boolConstant.getValue() != 0 ? "true" : "false");
        return null;
    }

    @Override
    public Void visit(AtomicPropRef apRef) {
        this.pw.append(apRef.getAp().getName());
        return null;
    }
}

