/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.expr.ArrayVarRef;
import fr.lip6.move.gal.structural.expr.AtomicProp;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.BoolConstant;
import fr.lip6.move.gal.structural.expr.Constant;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import fr.lip6.move.gal.structural.expr.Param;
import fr.lip6.move.gal.structural.expr.ParamRef;
import fr.lip6.move.gal.structural.expr.TransRef;
import fr.lip6.move.gal.structural.expr.VarRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;

public interface Expression {
    public static final /* synthetic */ int[] $SWITCH_TABLE$fr$lip6$move$gal$structural$expr$Op;

    public int eval(SparseIntArray var1);

    public int evalDistance(SparseIntArray var1, boolean var2);

    public <T> T accept(ExprVisitor<T> var1);

    public String toString();

    public Op getOp();

    default public <T> void forEachChild(Function<Expression, T> foo) {
    }

    default public int nbChildren() {
        return 0;
    }

    default public Expression childAt(int index) {
        throw new UnsupportedOperationException();
    }

    default public int getValue() {
        throw new UnsupportedOperationException();
    }

    public static Expression not(Expression be) {
        return Expression.op(Op.NOT, be, null);
    }

    public static Expression op(Op op, Expression l, Expression r) {
        switch (op) {
            case AND: {
                if (l.getOp() == Op.BOOLCONST) {
                    if (l.getValue() == 1) {
                        return r;
                    }
                    return l;
                }
                if (r.getOp() == Op.BOOLCONST) {
                    if (r.getValue() == 1) {
                        return l;
                    }
                    return r;
                }
                if (!(l.getOp() == Op.NOT ? ((BinOp)l).left.equals(r) : r.getOp() == Op.NOT && ((BinOp)r).left.equals(l))) break;
                return Expression.constant(false);
            }
            case OR: {
                if (l.getOp() == Op.BOOLCONST) {
                    if (l.getValue() == 1) {
                        return l;
                    }
                    return r;
                }
                if (r.getOp() == Op.BOOLCONST) {
                    if (r.getValue() == 1) {
                        return r;
                    }
                    return l;
                }
                if (!(l.getOp() == Op.NOT ? ((BinOp)l).left.equals(r) : r.getOp() == Op.NOT && ((BinOp)r).left.equals(l))) break;
                return Expression.constant(true);
            }
            case NOT: {
                if (l.getOp() == Op.BOOLCONST) {
                    if (l.getValue() == 1) {
                        return Expression.constant(false);
                    }
                    return Expression.constant(true);
                }
                if (l.getOp() != Op.NOT) break;
                return ((BinOp)l).left;
            }
            case MULT: {
                if (l.getOp() == Op.CONST) {
                    if (l.getValue() == 0) {
                        return l;
                    }
                    if (l.getValue() == 1) {
                        return r;
                    }
                }
                if (r.getOp() != Op.CONST) break;
                if (r.getValue() == 0) {
                    return r;
                }
                if (r.getValue() != 1) break;
                return l;
            }
            case ADD: {
                if (l.getOp() == Op.CONST && l.getValue() == 0) {
                    return r;
                }
                if (r.getOp() == Op.CONST && r.getValue() == 0) {
                    return l;
                }
            }
            case MINUS: 
            case DIV: 
            case MOD: {
                if (l.getOp() != Op.CONST || r.getOp() != Op.CONST) break;
                return Expression.constant(new BinOp(op, l, r).eval(null));
            }
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: {
                if (l.getOp() != Op.CONST || r.getOp() != Op.CONST) break;
                return Expression.constant(new BinOp(op, l, r).eval(null) == 1);
            }
            case EF: 
            case EG: 
            case AF: 
            case AG: 
            case F: 
            case G: 
            case X: {
                if (l.getOp() != Op.BOOLCONST) break;
                return l;
            }
        }
        if (op == Op.MULT || op == Op.ADD || op == Op.AND || op == Op.OR) {
            ArrayList<Expression> children = new ArrayList<Expression>();
            if (l.getOp() == op || r.getOp() == op) {
                if (l.getOp() == op) {
                    l.forEachChild(e -> children.add((Expression)e));
                } else {
                    children.add(l);
                }
                if (r.getOp() == op) {
                    r.forEachChild(e -> children.add((Expression)e));
                } else {
                    children.add(r);
                }
            } else {
                children.add(l);
                children.add(r);
            }
            if ((op == Op.MULT || op == Op.ADD) && children.stream().allMatch(c -> c.getOp() == Op.CONST)) {
                return Expression.constant(new NaryOp(op, children).eval(null));
            }
            return new NaryOp(op, children);
        }
        return new BinOp(op, l, r);
    }

    public static Expression var(int index) {
        return new VarRef(index);
    }

    public static Expression array(int base, Expression index) {
        return new ArrayVarRef(base, index);
    }

    public static Expression paramRef(Param p) {
        return new ParamRef(p);
    }

    public static Expression constant(boolean value) {
        return new BoolConstant(value);
    }

    public static Expression constant(int i) {
        return new Constant(i);
    }

    public static Expression nop(Op op) {
        return Expression.nop(op, new ArrayList<Expression>());
    }

    public static Expression nop(Op op, Expression ... children) {
        return Expression.nop(op, Arrays.asList(children));
    }

    public static Expression nop(Op op, List<Expression> children) {
        switch (op) {
            case AND: {
                List<Expression> resc;
                boolean changed = false;
                for (Expression expression : children) {
                    if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 1) {
                        changed = true;
                        break;
                    }
                    if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 0) {
                        return Expression.constant(false);
                    }
                    if (expression.getOp() != Op.AND) continue;
                    changed = true;
                    break;
                }
                if (changed) {
                    resc = new ArrayList<Expression>(children.size());
                    for (Expression expression : children) {
                        if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 1) {
                            changed = true;
                            continue;
                        }
                        if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 0) {
                            return Expression.constant(false);
                        }
                        if (expression.getOp() == Op.AND) {
                            changed = true;
                            resc.addAll(((NaryOp)expression).getChildren());
                            continue;
                        }
                        resc.add(expression);
                    }
                    children = resc;
                } else {
                    resc = children;
                }
                if (resc.size() == 1) {
                    return resc.get(0);
                }
                if (resc.size() != 0) break;
                return Expression.constant(true);
            }
            case OR: {
                List<Expression> resc;
                boolean changed = false;
                for (Expression c3 : children) {
                    if (c3.getOp() == Op.BOOLCONST && c3.getValue() == 0) {
                        changed = true;
                        break;
                    }
                    if (c3.getOp() == Op.BOOLCONST && c3.getValue() == 1) {
                        return Expression.constant(true);
                    }
                    if (c3.getOp() != Op.OR) continue;
                    changed = true;
                    break;
                }
                if (changed) {
                    resc = new ArrayList<Expression>(children.size());
                    for (Expression expression : children) {
                        if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 0) {
                            changed = true;
                            continue;
                        }
                        if (expression.getOp() == Op.BOOLCONST && expression.getValue() == 1) {
                            return Expression.constant(true);
                        }
                        if (expression.getOp() == Op.OR) {
                            changed = true;
                            resc.addAll(((NaryOp)expression).getChildren());
                            continue;
                        }
                        resc.add(expression);
                    }
                    children = resc;
                } else {
                    resc = children;
                }
                if (resc.size() == 1) {
                    return resc.get(0);
                }
                if (resc.size() != 0) break;
                return Expression.constant(false);
            }
            case ADD: {
                children.removeIf(c -> c.getOp() == Op.CONST && c.getValue() == 0);
                if (children.size() == 1) {
                    return children.get(0);
                }
                if (children.size() != 0) break;
                return Expression.constant(0);
            }
            case NOT: 
            case EF: 
            case EG: 
            case AF: 
            case AG: 
            case EX: 
            case AX: 
            case F: 
            case G: 
            case X: {
                return Expression.op(op, children.get(0), null);
            }
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: 
            case EU: 
            case AU: 
            case U: {
                return Expression.op(op, children.get(0), children.get(1));
            }
        }
        if ((op == Op.MULT || op == Op.ADD) && children.stream().allMatch(c -> c.getOp() == Op.CONST)) {
            return Expression.constant(new NaryOp(op, children).eval(null));
        }
        return new NaryOp(op, children);
    }

    public static Expression trans(int transitionIndex) {
        return new TransRef(transitionIndex);
    }

    public static Expression replaceSubExpressions(Expression expr, IdentityHashMap<Expression, Expression> map) {
        if (expr == null) {
            return null;
        }
        Expression img = map.get(expr);
        if (img != null) {
            return img;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = Expression.replaceSubExpressions(bin.left, map);
            Expression r = Expression.replaceSubExpressions(bin.right, map);
            if (l != bin.left || r != bin.right) {
                return Expression.op(bin.op, l, r);
            }
            return expr;
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>(nop.getChildren().size());
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression e = Expression.replaceSubExpressions(child, map);
                resc.add(e);
                if (e == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        return expr;
    }

    public static Expression apRef(AtomicProp ap) {
        return new AtomicPropRef(ap);
    }

    public static Expression resolveAP(Expression e) {
        if (e == null) {
            return null;
        }
        if (e instanceof AtomicPropRef) {
            AtomicPropRef apref = (AtomicPropRef)e;
            return apref.getAp().getExpression();
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(e.nbChildren());
        boolean changed = false;
        int i = 0;
        while (i < e.nbChildren()) {
            Expression child = e.childAt(i);
            Expression e2 = Expression.resolveAP(child);
            resc.add(e2);
            if (e2 != child) {
                changed = true;
            }
            ++i;
        }
        if (!changed) {
            return e;
        }
        return Expression.nop(e.getOp(), resc);
    }
}

