/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.expr.ExprVisitor;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.List;
import java.util.function.Function;

public class NaryOp
implements Expression {
    private Op op;
    private List<Expression> children;

    public NaryOp(Op op, List<Expression> children) {
        this.op = op;
        this.children = children;
    }

    @Override
    public Op getOp() {
        return this.op;
    }

    @Override
    public int eval(SparseIntArray state) {
        switch (this.op) {
            case AND: {
                boolean res = true;
                for (Expression e : this.children) {
                    if (e.eval(state) == 1) continue;
                    res = false;
                    break;
                }
                return res ? 1 : 0;
            }
            case OR: {
                boolean res = false;
                for (Expression e : this.children) {
                    if (e.eval(state) != 1) continue;
                    res = true;
                    break;
                }
                return res ? 1 : 0;
            }
            case ADD: 
            case CARD: {
                int res = 0;
                for (Expression e : this.children) {
                    res += e.eval(state);
                }
                return res;
            }
            case MULT: {
                int res = 1;
                for (Expression e : this.children) {
                    res *= e.eval(state);
                }
                return res;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int evalDistance(SparseIntArray state, boolean isNeg) {
        if (!isNeg) {
            switch (this.op) {
                case AND: {
                    int sum = 0;
                    for (Expression child : this.getChildren()) {
                        sum += child.evalDistance(state, isNeg);
                    }
                    return sum;
                }
                case OR: {
                    int min = Integer.MAX_VALUE;
                    for (Expression child : this.getChildren()) {
                        min = Math.min(min, child.evalDistance(state, isNeg));
                    }
                    return min;
                }
                case ADD: {
                    return this.eval(state);
                }
            }
        } else {
            switch (this.op) {
                case AND: {
                    int min = Integer.MAX_VALUE;
                    for (Expression child : this.getChildren()) {
                        min = Math.min(min, child.evalDistance(state, isNeg));
                    }
                    return min;
                }
                case OR: {
                    int sum = 0;
                    for (Expression child : this.getChildren()) {
                        sum += child.evalDistance(state, isNeg);
                    }
                    return sum;
                }
            }
        }
        throw new RuntimeException("Unexpected operator type in expression " + String.valueOf((Object)this.op));
    }

    public void addChild(Expression child) {
        this.children.add(child);
    }

    @Override
    public <T> T accept(ExprVisitor<T> v) {
        return v.visit(this);
    }

    public List<Expression> getChildren() {
        return this.children;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append((Object)this.op).append(" ");
        boolean first = true;
        for (Expression c : this.children) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(c);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public <T> void forEachChild(Function<Expression, T> foo) {
        for (Expression c : this.children) {
            foo.apply(c);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 9157 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 9157 * result + (this.op == null ? 0 : this.op.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NaryOp other = (NaryOp)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        return this.op == other.op;
    }

    @Override
    public int nbChildren() {
        return this.children.size();
    }

    @Override
    public Expression childAt(int index) {
        return this.children.get(index);
    }
}

