/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

public enum Op {
    NOT,
    AND,
    OR,
    ADD,
    MULT,
    MINUS,
    DIV,
    MOD,
    EQ,
    NEQ,
    GEQ,
    GT,
    LEQ,
    LT,
    ENABLED,
    CARD,
    BOUND,
    CONST,
    BOOLCONST,
    DEAD,
    PARAMREF,
    PLACEREF,
    HLPLACEREF,
    TRANSREF,
    APREF,
    EF,
    EG,
    AF,
    AG,
    EX,
    AX,
    EU,
    AU,
    F,
    G,
    X,
    U;


    public static Op negate(Op op) {
        switch (op) {
            case EQ: {
                return NEQ;
            }
            case NEQ: {
                return EQ;
            }
            case GT: {
                return LEQ;
            }
            case GEQ: {
                return LT;
            }
            case LEQ: {
                return GT;
            }
            case LT: {
                return GEQ;
            }
            case F: {
                return G;
            }
            case G: {
                return F;
            }
            case X: {
                return X;
            }
            case U: {
                return U;
            }
            case AF: {
                return EG;
            }
            case EG: {
                return AF;
            }
            case EF: {
                return AG;
            }
            case AG: {
                return EF;
            }
            case EX: {
                return AX;
            }
            case AX: {
                return EX;
            }
            case AND: {
                return OR;
            }
            case OR: {
                return AND;
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isComparison(Op op) {
        switch (op) {
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: {
                return true;
            }
        }
        return false;
    }
}

