/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import fr.lip6.move.gal.structural.expr.AtomicProp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.ArrayDeque;
import java.util.List;

public class PrefixParser {
    public static Expression parsePrefix(String expr, List<AtomicProp> list) {
        ArrayDeque<Expression> operands = new ArrayDeque<Expression>();
        String[] tokens = expr.split(" ");
        int index = tokens.length - 1;
        while (index >= 0) {
            String token = tokens[index];
            if ("&".equals(token)) {
                Expression c1 = (Expression)operands.pop();
                c2 = (Expression)operands.pop();
                operands.push(Expression.op(Op.AND, c1, c2));
            } else if ("|".equals(token)) {
                Expression c1 = (Expression)operands.pop();
                c2 = (Expression)operands.pop();
                operands.push(Expression.op(Op.OR, c1, c2));
            } else if ("U".equals(token)) {
                Expression c1 = (Expression)operands.pop();
                c2 = (Expression)operands.pop();
                operands.push(Expression.op(Op.U, c1, c2));
            } else if ("F".equals(token)) {
                Expression child = (Expression)operands.pop();
                operands.push(Expression.op(Op.F, child, null));
            } else if ("G".equals(token)) {
                Expression child = (Expression)operands.pop();
                operands.push(Expression.op(Op.G, child, null));
            } else if ("X".equals(token)) {
                Expression child = (Expression)operands.pop();
                operands.push(Expression.op(Op.X, child, null));
            } else if ("!".equals(token)) {
                Expression child = (Expression)operands.pop();
                operands.push(Expression.not(child));
            } else if (token.startsWith("p")) {
                int val = Integer.parseInt(token.substring(1));
                operands.push(list.get(val).getExpression());
            } else if ("f".equals(token)) {
                operands.push(Expression.constant(false));
            } else if ("t".equals(token)) {
                operands.push(Expression.constant(true));
            } else {
                throw new UnsupportedOperationException("Unknown operator in LBt syntax :" + token);
            }
            --index;
        }
        return (Expression)operands.pop();
    }
}

