/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.expr;

import android.util.SparseIntArray;
import fr.lip6.move.gal.structural.Property;
import fr.lip6.move.gal.structural.PropertyType;
import fr.lip6.move.gal.structural.SparsePetriNet;
import fr.lip6.move.gal.structural.expr.AtomicPropManager;
import fr.lip6.move.gal.structural.expr.AtomicPropRef;
import fr.lip6.move.gal.structural.expr.BinOp;
import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.expr.NaryOp;
import fr.lip6.move.gal.structural.expr.Op;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Simplifier {
    public static Expression pushNegation(Expression expr) {
        return Simplifier.pushNegation(expr, false);
    }

    public static Expression simplifyBoolean(Expression expr) {
        return Simplifier.simplifyBoolean(expr, new HashSet<Expression>(), new HashSet<Expression>(), new HashSet<Expression>());
    }

    private static Expression simplifyBoolean(Expression expr, Set<Expression> seenPos, Set<Expression> seenNeg, Set<Expression> dominant) {
        if (expr == null) {
            return expr;
        }
        switch (expr.getOp()) {
            case EQ: 
            case NEQ: 
            case GEQ: 
            case GT: 
            case LEQ: 
            case LT: 
            case ENABLED: 
            case CARD: 
            case BOUND: 
            case APREF: {
                if (seenPos.contains(expr)) {
                    return Expression.constant(true);
                }
                if (seenNeg.contains(expr)) {
                    return Expression.constant(false);
                }
                if (expr instanceof BinOp) {
                    BinOp cmp = (BinOp)expr;
                    if (cmp.left.equals(cmp.right)) {
                        switch (expr.getOp()) {
                            case EQ: 
                            case GEQ: 
                            case LEQ: {
                                return Expression.constant(true);
                            }
                            case NEQ: 
                            case GT: 
                            case LT: {
                                return Expression.constant(false);
                            }
                        }
                    }
                }
                return expr;
            }
            case NOT: {
                Expression l = ((BinOp)expr).left;
                if (seenPos.contains(l)) {
                    return Expression.constant(false);
                }
                if (seenNeg.contains(l)) {
                    return Expression.constant(true);
                }
                return expr;
            }
            case BOOLCONST: {
                return expr;
            }
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            Expression l = Simplifier.simplifyBoolean(bin.left, new HashSet<Expression>(), new HashSet<Expression>(), new HashSet<Expression>());
            Expression r = Simplifier.simplifyBoolean(bin.right, new HashSet<Expression>(), new HashSet<Expression>(), new HashSet<Expression>());
            if (l == bin.left && r == bin.right) {
                return expr;
            }
            return Expression.op(bin.op, l, r);
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>();
            if (nop.getOp() == Op.AND) {
                ArrayList<Expression> tovisit = new ArrayList<Expression>();
                HashSet<Expression> nseenPos = new HashSet<Expression>(seenPos);
                HashSet<Expression> nseenNeg = new HashSet<Expression>(seenNeg);
                if (!dominant.isEmpty()) {
                    for (Expression child : nop.getChildren()) {
                        if (!dominant.contains(child)) continue;
                        return child;
                    }
                }
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() == Op.NOT) {
                        Expression e = ((BinOp)child).left;
                        if (nseenNeg.contains(e)) continue;
                        if (nseenPos.contains(e)) {
                            return Expression.constant(false);
                        }
                        nseenNeg.add(e);
                        resc.add(child);
                        continue;
                    }
                    if (child.getOp() == Op.OR) {
                        tovisit.add(child);
                        continue;
                    }
                    if (child.getOp() == Op.BOOLCONST) {
                        if (child.getValue() == 1) continue;
                        return Expression.constant(false);
                    }
                    if (nseenPos.contains(child)) continue;
                    if (nseenNeg.contains(child)) {
                        return Expression.constant(false);
                    }
                    nseenPos.add(child);
                    resc.add(child);
                }
                for (Expression e : tovisit) {
                    Expression img = Simplifier.simplifyBoolean(e, nseenPos, nseenNeg, dominant);
                    if (img.getOp() == Op.BOOLCONST) {
                        if (img.getValue() == 1) continue;
                        return Expression.constant(false);
                    }
                    resc.add(img);
                    if (img == e) continue;
                }
                return Expression.nop(nop.getOp(), resc);
            }
            if (nop.getOp() == Op.OR) {
                ArrayList<Expression> tovisit = new ArrayList<Expression>();
                HashSet<Expression> ndominant = new HashSet<Expression>(dominant);
                HashSet<Expression> nseenPos = new HashSet<Expression>();
                HashSet<Expression> nseenNeg = new HashSet<Expression>();
                for (Expression child : nop.getChildren()) {
                    if (child.getOp() == Op.NOT) {
                        Expression e = ((BinOp)child).left;
                        if (seenNeg.contains(e)) {
                            return Expression.constant(true);
                        }
                        if (seenPos.contains(e)) continue;
                        if (nseenPos.contains(e)) {
                            return Expression.constant(true);
                        }
                        if (!nseenNeg.add(e)) continue;
                        ndominant.add(child);
                        resc.add(child);
                        continue;
                    }
                    if (child.getOp() == Op.AND) {
                        tovisit.add(child);
                        continue;
                    }
                    if (child.getOp() == Op.BOOLCONST) {
                        if (child.getValue() == 0) continue;
                        return Expression.constant(true);
                    }
                    if (seenPos.contains(child)) {
                        return Expression.constant(true);
                    }
                    if (nseenNeg.contains(child)) {
                        return Expression.constant(true);
                    }
                    if (seenNeg.contains(child) || !nseenPos.add(child)) continue;
                    ndominant.add(child);
                    resc.add(child);
                }
                for (Expression e : tovisit) {
                    Expression img = Simplifier.simplifyBoolean(e, seenPos, seenNeg, ndominant);
                    if (img.getOp() == Op.BOOLCONST) {
                        if (img.getValue() == 0) continue;
                        return Expression.constant(true);
                    }
                    if (img.getOp() == Op.NOT ? !nseenNeg.add(((BinOp)img).left) : !nseenPos.add(img)) continue;
                    resc.add(img);
                }
                return Expression.nop(nop.getOp(), resc);
            }
            return expr;
        }
        return expr;
    }

    private static Expression pushNegation(Expression expr, boolean isNeg) {
        if (expr == null) {
            return expr;
        }
        if (expr.getOp() == Op.BOOLCONST) {
            if (!isNeg) {
                return expr;
            }
            return Expression.constant(expr.getValue() == 0);
        }
        if (Op.isComparison(expr.getOp())) {
            if (isNeg) {
                return Expression.op(Op.negate(expr.getOp()), expr.childAt(0), expr.childAt(1));
            }
            return expr;
        }
        if (expr.getOp() == Op.ENABLED || expr.getOp() == Op.EU || expr.getOp() == Op.AU || expr.getOp() == Op.U || expr.getOp() == Op.APREF) {
            if (isNeg) {
                return Expression.not(expr);
            }
            return expr;
        }
        if (expr.getOp() == Op.NOT) {
            return Simplifier.pushNegation(expr.childAt(0), !isNeg);
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int cid = 0;
        int cide = expr.nbChildren();
        while (cid < cide) {
            Expression child = expr.childAt(cid);
            Expression e = Simplifier.pushNegation(child, isNeg);
            resc.add(e);
            if (e != child) {
                changed = true;
            }
            ++cid;
        }
        if (isNeg) {
            return Expression.nop(Op.negate(expr.getOp()), resc);
        }
        if (!changed) {
            return expr;
        }
        return Expression.nop(expr.getOp(), resc);
    }

    public static Expression assumeVarsPositive(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            switch (bin.getOp()) {
                case GEQ: 
                case GT: 
                case LEQ: 
                case LT: {
                    Expression l = bin.left;
                    Expression r = bin.right;
                    if (l.getOp() == Op.CONST && l.getValue() == 0 && (r.getOp() == Op.PLACEREF || r.getOp() == Op.CARD || r.getOp() == Op.HLPLACEREF) && bin.getOp() == Op.LEQ || r.getOp() == Op.CONST && r.getValue() == 0 && (l.getOp() == Op.PLACEREF || l.getOp() == Op.CARD || l.getOp() == Op.HLPLACEREF) && bin.getOp() == Op.GEQ) {
                        return Expression.constant(true);
                    }
                    if ((r.getOp() != Op.CONST || r.getValue() != 0 || l.getOp() != Op.PLACEREF && l.getOp() != Op.CARD && l.getOp() != Op.HLPLACEREF || bin.getOp() != Op.LT) && (l.getOp() != Op.CONST || l.getValue() != 0 || r.getOp() != Op.PLACEREF && r.getOp() != Op.CARD && r.getOp() != Op.HLPLACEREF || bin.getOp() != Op.GT)) break;
                    return Expression.constant(false);
                }
            }
        }
        if (expr.nbChildren() == 0) {
            return expr;
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int cid = 0;
        int cide = expr.nbChildren();
        while (cid < cide) {
            Expression child = expr.childAt(cid);
            Expression e = Simplifier.assumeVarsPositive(child);
            resc.add(e);
            if (e != child) {
                changed = true;
            }
            ++cid;
        }
        if (!changed) {
            return expr;
        }
        return Expression.nop(expr.getOp(), resc);
    }

    public static Expression assumeOnebounded(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            Expression r;
            Expression l;
            BinOp bin = (BinOp)expr;
            switch (bin.getOp()) {
                case EQ: 
                case NEQ: 
                case GEQ: 
                case GT: 
                case LEQ: 
                case LT: {
                    Expression res;
                    l = bin.left;
                    r = bin.right;
                    if (l.getOp() == Op.PLACEREF && r.getOp() == Op.CONST || l.getOp() == Op.CONST && r.getOp() == Op.PLACEREF) {
                        ArrayList<Expression> res2 = new ArrayList<Expression>();
                        Expression var = l.getOp() == Op.PLACEREF ? l : r;
                        int val = 0;
                        while (val <= 1) {
                            Expression valExpr = Expression.constant(val);
                            Expression eval = Expression.op(bin.getOp(), l.getOp() == Op.PLACEREF ? valExpr : l, r.getOp() == Op.PLACEREF ? valExpr : r);
                            if (eval.eval(null) == 1) {
                                res2.add(Expression.op(Op.EQ, var, valExpr));
                            }
                            ++val;
                        }
                        if (res2.size() == 2) {
                            return Expression.constant(true);
                        }
                        return Expression.nop(Op.OR, res2);
                    }
                    if (l.getOp() != Op.PLACEREF || r.getOp() != Op.PLACEREF) break;
                    Op op = bin.getOp();
                    switch (op) {
                        case GEQ: {
                            l = bin.right;
                            r = bin.left;
                            op = Op.LEQ;
                            break;
                        }
                        case GT: {
                            l = bin.right;
                            r = bin.left;
                            op = Op.LT;
                        }
                    }
                    switch (op) {
                        case EQ: {
                            res = Expression.op(Op.AND, Expression.op(Op.EQ, l, Expression.constant(0)), Expression.op(Op.EQ, r, Expression.constant(0)));
                            res = Expression.op(Op.OR, Expression.op(Op.EQ, l, Expression.constant(1)), Expression.op(Op.EQ, r, Expression.constant(1)));
                            break;
                        }
                        case NEQ: {
                            res = Expression.op(Op.AND, Expression.op(Op.EQ, l, Expression.constant(0)), Expression.op(Op.EQ, r, Expression.constant(1)));
                            res = Expression.op(Op.OR, Expression.op(Op.EQ, l, Expression.constant(1)), Expression.op(Op.EQ, r, Expression.constant(0)));
                            break;
                        }
                        case LT: {
                            res = Expression.op(Op.AND, Expression.op(Op.EQ, l, Expression.constant(0)), Expression.op(Op.EQ, r, Expression.constant(1)));
                            break;
                        }
                        case LEQ: {
                            res = Expression.op(Op.OR, Expression.op(Op.EQ, l, Expression.constant(0)), Expression.op(Op.EQ, r, Expression.constant(1)));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected comparison operator in conversion " + String.valueOf(expr));
                        }
                    }
                    return res;
                }
            }
            l = Simplifier.assumeOnebounded(bin.left);
            r = Simplifier.assumeOnebounded(bin.right);
            if (l != bin.left || r != bin.right) {
                return Expression.op(bin.op, l, r);
            }
            return expr;
        }
        if (expr instanceof NaryOp) {
            NaryOp nop = (NaryOp)expr;
            ArrayList<Expression> resc = new ArrayList<Expression>(nop.getChildren().size());
            boolean changed = false;
            for (Expression child : nop.getChildren()) {
                Expression e = Simplifier.assumeOnebounded(child);
                resc.add(e);
                if (e == child) continue;
                changed = true;
            }
            if (!changed) {
                return expr;
            }
            return Expression.nop(nop.getOp(), resc);
        }
        return expr;
    }

    public static boolean allEnablingsAreNegated(Property p, SparsePetriNet spn) {
        SparseIntArray init = new SparseIntArray(spn.getMarks());
        switch (p.getType()) {
            case INVARIANT: {
                return Simplifier.allEnablingsAreNegated(p.getBody(), false);
            }
            case CTL: 
            case LTL: {
                return Simplifier.allEnablingsAreInitiallyFalse(p.getBody(), init, spn);
            }
        }
        return !Simplifier.containsEnablings(p.getBody());
    }

    private static boolean allEnablingsAreInitiallyFalse(Expression e, SparseIntArray init, SparsePetriNet spn) {
        if (e == null) {
            return true;
        }
        if (e.getOp() == Op.ENABLED) {
            int cid = 0;
            int cide = e.nbChildren();
            while (cid < cide) {
                if (SparseIntArray.greaterOrEqual(init, spn.getFlowPT().getColumn(e.childAt(cid).getValue()))) {
                    return false;
                }
                ++cid;
            }
            return true;
        }
        if (Op.isComparison(e.getOp())) {
            return true;
        }
        int cid = 0;
        int cide = e.nbChildren();
        while (cid < cide) {
            if (!Simplifier.allEnablingsAreInitiallyFalse(e.childAt(cid), init, spn)) {
                return false;
            }
            ++cid;
        }
        return true;
    }

    private static boolean containsEnablings(Expression e) {
        if (e == null) {
            return false;
        }
        if (e.getOp() == Op.ENABLED) {
            return true;
        }
        if (Op.isComparison(e.getOp())) {
            return false;
        }
        int i = 0;
        int ie = e.nbChildren();
        while (i < ie) {
            if (Simplifier.containsEnablings(e.childAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean allEnablingsAreNegated(Expression e, boolean isNeg) {
        if (e == null) {
            return true;
        }
        if (e.getOp() == Op.ENABLED) {
            return isNeg;
        }
        if (e.getOp() == Op.NOT) {
            return Simplifier.allEnablingsAreNegated(e.childAt(0), !isNeg);
        }
        if (Op.isComparison(e.getOp())) {
            return true;
        }
        int cid = 0;
        int cide = e.nbChildren();
        while (cid < cide) {
            if (!Simplifier.allEnablingsAreNegated(e.childAt(cid), isNeg)) {
                return false;
            }
            ++cid;
        }
        return true;
    }

    public static boolean isACTLstar(Property prop) {
        switch (prop.getType()) {
            case CTL: {
                return Simplifier.isACTLstar(prop.getBody(), false);
            }
        }
        return true;
    }

    private static boolean isACTLstar(Expression body, boolean isNeg) {
        if (body == null) {
            return true;
        }
        if (body.getOp() == Op.AX || body.getOp() == Op.AF || body.getOp() == Op.AU || body.getOp() == Op.AG) {
            return !isNeg;
        }
        if (body.getOp() == Op.EX || body.getOp() == Op.EF || body.getOp() == Op.EU || body.getOp() == Op.EG) {
            return isNeg;
        }
        if (Op.isComparison(body.getOp())) {
            return true;
        }
        if (body.getOp() == Op.NOT) {
            return Simplifier.isACTLstar(body.childAt(0), !isNeg);
        }
        int cid = 0;
        int cide = body.nbChildren();
        while (cid < cide) {
            if (!Simplifier.isACTLstar(body.childAt(cid), isNeg)) {
                return false;
            }
            ++cid;
        }
        return true;
    }

    public static boolean isSyntacticallyStuttering(Property prop) {
        switch (prop.getType()) {
            case CTL: 
            case LTL: {
                return Simplifier.isSyntacticallyStuttering(prop.getBody());
            }
        }
        return true;
    }

    private static boolean isSyntacticallyStuttering(Expression body) {
        if (body == null) {
            return true;
        }
        if (body.getOp() == Op.AX || body.getOp() == Op.EX || body.getOp() == Op.X) {
            return false;
        }
        int cid = 0;
        int cide = body.nbChildren();
        while (cid < cide) {
            if (!Simplifier.isSyntacticallyStuttering(body.childAt(cid))) {
                return false;
            }
            ++cid;
        }
        return true;
    }

    public static boolean isAnInvariant(Property property) {
        Op firstOp;
        if (property.getType() == PropertyType.INVARIANT) {
            return true;
        }
        if (property.getType() == PropertyType.CTL && ((firstOp = property.getBody().getOp()) == Op.AG || firstOp == Op.EF)) {
            return AtomicPropManager.isPureBool(property.getBody().childAt(0));
        }
        return false;
    }

    public static Expression evalWithAPValue(Expression expr, String apname, boolean value) {
        AtomicPropRef apref;
        if (expr == null) {
            return null;
        }
        if (expr instanceof AtomicPropRef && (apref = (AtomicPropRef)expr).getAp().getName().equals(apname)) {
            return Expression.constant(value);
        }
        if (expr.nbChildren() == 0) {
            return expr;
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int cid = 0;
        int cide = expr.nbChildren();
        while (cid < cide) {
            Expression child = expr.childAt(cid);
            Expression e = Simplifier.evalWithAPValue(child, apname, value);
            resc.add(e);
            if (e != child) {
                changed = true;
            }
            ++cid;
        }
        if (!changed) {
            return expr;
        }
        return Expression.nop(expr.getOp(), resc);
    }

    public static Expression existentialQuantification(Expression expr, String ap) {
        return Simplifier.simplifyBoolean(Expression.op(Op.OR, Simplifier.evalWithAPValue(expr, ap, false), Simplifier.evalWithAPValue(expr, ap, true)));
    }

    public static Expression simplifySumComparisons(Expression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof BinOp) {
            BinOp bin = (BinOp)expr;
            switch (bin.getOp()) {
                case EQ: 
                case NEQ: 
                case GEQ: 
                case GT: 
                case LEQ: 
                case LT: {
                    Op operator = Op.ADD;
                    Expression left = bin.left;
                    Expression right = bin.right;
                    if (left.getOp() == Op.CARD || right.getOp() == Op.CARD) {
                        operator = Op.CARD;
                    }
                    if (left.getOp() != operator && right.getOp() != operator) break;
                    HashMap<Expression, Integer> onl = new HashMap<Expression, Integer>();
                    if (left.getOp() == operator) {
                        int i = 0;
                        while (i < left.nbChildren()) {
                            onl.compute(left.childAt(i), (k, v) -> v == null ? 1 : v + 1);
                            ++i;
                        }
                    } else {
                        onl.put(left, 1);
                    }
                    boolean changed = false;
                    HashMap<Expression, Integer> onr = new HashMap<Expression, Integer>();
                    if (right.getOp() == operator) {
                        int i = 0;
                        while (i < right.nbChildren()) {
                            Expression child = right.childAt(i);
                            Integer li = (Integer)onl.get(child);
                            if (li == null) {
                                onr.compute(child, (k, v) -> v == null ? 1 : v + 1);
                            } else {
                                if (li == 1) {
                                    onl.remove(child);
                                } else {
                                    onl.put(child, li - 1);
                                }
                                changed = true;
                            }
                            ++i;
                        }
                    } else {
                        Integer li = (Integer)onl.get(right);
                        if (li == null) {
                            onr.compute(right, (k, v) -> v == null ? 1 : v + 1);
                        } else {
                            if (li == 1) {
                                onl.remove(right);
                            } else {
                                onl.put(right, li - 1);
                            }
                            changed = true;
                        }
                    }
                    if (changed) {
                        Expression nr;
                        Expression nl;
                        if (onl.size() == 0) {
                            nl = Expression.constant(0);
                        } else {
                            ArrayList<Expression> args = new ArrayList<Expression>(onl.size());
                            for (Map.Entry e : onl.entrySet()) {
                                int i = 0;
                                while (i < (Integer)e.getValue()) {
                                    args.add((Expression)e.getKey());
                                    ++i;
                                }
                            }
                            nl = Expression.nop(operator, args);
                        }
                        if (onr.size() == 0) {
                            nr = Expression.constant(0);
                        } else {
                            ArrayList<Expression> args = new ArrayList<Expression>(onr.size());
                            for (Map.Entry e : onr.entrySet()) {
                                int i = 0;
                                while (i < (Integer)e.getValue()) {
                                    args.add((Expression)e.getKey());
                                    ++i;
                                }
                            }
                            nr = Expression.nop(operator, args);
                        }
                        return Expression.op(bin.getOp(), nl, nr);
                    }
                    return bin;
                }
            }
        }
        if (expr.nbChildren() == 0) {
            return expr;
        }
        ArrayList<Expression> resc = new ArrayList<Expression>(expr.nbChildren());
        boolean changed = false;
        int cid = 0;
        int cide = expr.nbChildren();
        while (cid < cide) {
            Expression child = expr.childAt(cid);
            Expression e = Simplifier.simplifySumComparisons(child);
            resc.add(e);
            if (e != child) {
                changed = true;
            }
            ++cid;
        }
        if (!changed) {
            return expr;
        }
        return Expression.nop(expr.getOp(), resc);
    }
}

