/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.graph;

import android.util.SparseIntArray;
import fr.lip6.move.gal.graph.Tarjan;
import fr.lip6.move.gal.structural.ISparsePetriNet;
import fr.lip6.move.gal.util.IntMatrixCol;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PlacesInNonTrivialSCCComputer {
    public static Set<Integer> computePlacesInNonTrivialSCC(ISparsePetriNet spn) {
        IntMatrixCol graph = PlacesInNonTrivialSCCComputer.computeAdjacency(spn);
        HashSet<Integer> nonTrivialSCC = new HashSet<Integer>();
        List<List<Integer>> sccs = Tarjan.searchForSCC(graph);
        for (List<Integer> scc : sccs) {
            if (scc.size() <= 1 && graph.get(scc.get(0), scc.get(0)) != 1) continue;
            nonTrivialSCC.addAll(scc);
        }
        return nonTrivialSCC;
    }

    private static IntMatrixCol computeAdjacency(ISparsePetriNet graph) {
        IntMatrixCol adj = new IntMatrixCol(graph.getPlaceCount(), graph.getPlaceCount());
        IntMatrixCol flowPT = graph.getFlowPT();
        IntMatrixCol flowTP = graph.getFlowTP();
        int tid = 0;
        while (tid < flowPT.getColumnCount()) {
            SparseIntArray hPT = flowPT.getColumn(tid);
            SparseIntArray hTP = flowTP.getColumn(tid);
            int i = 0;
            while (i < hPT.size()) {
                int j = 0;
                while (j < hTP.size()) {
                    adj.set(hTP.keyAt(j), hPT.keyAt(i), 1);
                    ++j;
                }
                ++i;
            }
            ++tid;
        }
        return adj;
    }
}

