/*
 * Decompiled with CFR 0.152.
 */
package fr.lip6.move.gal.structural.hlpn;

import fr.lip6.move.gal.structural.expr.Expression;
import fr.lip6.move.gal.structural.hlpn.Sort;
import java.util.Arrays;
import java.util.List;

public class HLPlace {
    private String name;
    private int startIndex;
    private int[] initial;
    private boolean isConstant = false;
    private List<Sort> sort;
    private int[] multipliers = null;

    public HLPlace(String name, int start, int[] initial, List<Sort> sort) {
        this.name = name;
        this.startIndex = start;
        this.initial = initial;
        this.sort = sort;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Object init = Arrays.toString(this.initial);
        if (((String)init).length() > 30) {
            init = ((String)init).substring(0, 30) + "...]";
        }
        return "[name=" + this.name + "(" + String.valueOf(this.sort) + "), startIndex=" + this.startIndex + ", initial=" + (String)init + "]\n";
    }

    public void setConstant(boolean b) {
        this.isConstant = b;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public int[] getInitial() {
        return this.initial;
    }

    public void setInitial(int[] initial) {
        this.initial = initial;
        this.multipliers = null;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        this.multipliers = null;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    public int resolve(List<Expression> r) {
        this.getMultipliers();
        int sum = 0;
        int i = 0;
        while (i < r.size()) {
            sum += this.multipliers[i] * r.get(i).eval(null);
            ++i;
        }
        return sum;
    }

    public int[] getMultipliers() {
        if (this.multipliers == null) {
            this.multipliers = new int[this.sort.size()];
            this.multipliers[this.sort.size() - 1] = 1;
            int i = this.sort.size() - 2;
            while (i >= 0) {
                this.multipliers[i] = this.multipliers[i + 1] * this.sort.get(i + 1).size();
                --i;
            }
        }
        return this.multipliers;
    }
}

